/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03MenuItemDelegate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class A03SwingUtilities
implements SwingConstants {
    private static transient boolean updatePending;
    static Method getPopupMenuOriginMethod;

    static {
        getPopupMenuOriginMethod = null;
    }

    public static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    public static int loc2IndexFileList(JList list, Point point) {
        Object bySize;
        int index = list.locationToIndex(point);
        if (index != -1 && (bySize = list.getClientProperty("List.isFileList")) instanceof Boolean && ((Boolean)bySize).booleanValue() && !A03SwingUtilities.pointIsInActualBounds(list, index, point)) {
            index = -1;
        }
        return index;
    }

    private static boolean pointIsInActualBounds(JList list, int index, Point point) {
        ListCellRenderer renderer = list.getCellRenderer();
        ListModel dataModel = list.getModel();
        Object value = dataModel.getElementAt(index);
        Component item = renderer.getListCellRendererComponent(list, value, index, false, false);
        Dimension itemSize = item.getPreferredSize();
        Rectangle cellBounds = list.getCellBounds(index, index);
        if (!A03SwingUtilities.isLeftToRight(item)) {
            cellBounds.x += cellBounds.width - itemSize.width;
        }
        cellBounds.width = itemSize.width;
        return cellBounds.contains(point);
    }

    public static int getMaxIconWidth(Container parent) {
        int width = 0;
        if (parent != null) {
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                JMenuItem mi;
                Icon icon;
                Component component = componentArray[n2];
                if (component instanceof JMenuItem && (icon = (mi = (JMenuItem)component).getIcon()) != null) {
                    width = Math.max(width, icon.getIconWidth());
                }
                ++n2;
            }
        }
        return width;
    }

    public static int getMaxIconHeight(Container parent) {
        int height = 0;
        if (parent != null) {
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                JMenuItem mi;
                Icon icon;
                Component component = componentArray[n2];
                if (component instanceof JMenuItem && (icon = (mi = (JMenuItem)component).getIcon()) != null) {
                    height = Math.max(height, icon.getIconHeight());
                }
                ++n2;
            }
        }
        return height;
    }

    public static boolean isCheckIconVisible(Container parent) {
        if (parent != null) {
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component instanceof JCheckBoxMenuItem || component instanceof JRadioButtonMenuItem) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isArrowIconVisible(Container parent) {
        if (parent != null) {
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component instanceof JMenu) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Dimension getPreferredMenuItemSize(JMenuItem menuItem, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, Font acceleratorFont) {
        int maxIconWidth;
        String acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        int width = 0;
        int height = 0;
        Container parent = menuItem.getParent();
        if (A03SwingUtilities.isCheckIconVisible(parent)) {
            width += checkIcon.getIconWidth() + defaultTextIconGap;
            height = checkIcon.getIconHeight();
        }
        if ((maxIconWidth = A03SwingUtilities.getMaxIconWidth(parent)) > 0) {
            width += maxIconWidth + defaultTextIconGap;
        }
        height = Math.max(height, A03SwingUtilities.getMaxIconHeight(parent));
        String text = menuItem.getText();
        FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
        int stringWidth = A03GraphicsUtilities.stringWidth(fm, text);
        width += stringWidth;
        height = Math.max(height, fm.getHeight());
        KeyStroke accelerator = menuItem.getAccelerator();
        if (accelerator != null) {
            int keyCode;
            StringBuilder builder = new StringBuilder();
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                builder.append(KeyEvent.getKeyModifiersText(modifiers));
                builder.append(acceleratorDelimiter);
            }
            if ((keyCode = accelerator.getKeyCode()) != 0) {
                builder.append(KeyEvent.getKeyText(keyCode));
            } else {
                builder.append(accelerator.getKeyChar());
            }
            FontMetrics fmAccel = menuItem.getFontMetrics(acceleratorFont);
            String acceleratorText = builder.toString();
            int accelStringWidth = A03GraphicsUtilities.stringWidth(fmAccel, acceleratorText);
            width += defaultTextIconGap + accelStringWidth;
            height = Math.max(height, fmAccel.getHeight());
        }
        if (A03SwingUtilities.isArrowIconVisible(parent)) {
            int arrowIconWidth = UIManager.getIcon("Menu.arrowIcon").getIconWidth();
            width += arrowIconWidth;
        }
        Insets insets = menuItem.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    public static boolean isAnchestorDecorated(Component c) {
        return SwingUtilities.getAncestorOfClass(JInternalFrame.class, c) != null || JFrame.isDefaultLookAndFeelDecorated() || JDialog.isDefaultLookAndFeelDecorated();
    }

    private static void setUpdatePending(boolean update) {
        updatePending = update;
    }

    private static boolean isUpdatePending() {
        return updatePending;
    }

    public static void updateUI() {
        if (!A03SwingUtilities.isUpdatePending()) {
            A03SwingUtilities.setUpdatePending(true);
            Runnable uiUpdater = new Runnable(){

                public void run() {
                    Frame[] frameArray = Frame.getFrames();
                    int n = frameArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Frame frame = frameArray[n2];
                        SwingUtilities.updateComponentTreeUI(frame);
                        Window[] windowArray = frame.getOwnedWindows();
                        int n3 = windowArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Window window = windowArray[n4];
                            SwingUtilities.updateComponentTreeUI(window);
                            ++n4;
                        }
                        ++n2;
                    }
                    A03SwingUtilities.setUpdatePending(false);
                }
            };
            SwingUtilities.invokeLater(uiUpdater);
        }
    }

    public static Object getDelegate(JComponent c, Object defaultDelegate) {
        Object delegate = c.getClientProperty("delegate");
        if (delegate == null) {
            delegate = defaultDelegate;
        }
        return delegate;
    }

    public static void paintMenuItem(A03MenuItemDelegate delegate, Graphics2D graphics, JMenuItem menuItem, Icon checkIcon, Icon arrowIcon, Font acceleratorFont, int defaultTextIconGap) {
        Icon icon;
        int maxIconWidth;
        boolean leftToRight = A03SwingUtilities.isLeftToRight(menuItem);
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Insets i = menuItem.getInsets();
        delegate.paintBackground(menuItem, graphics);
        Container parent = menuItem.getParent();
        int x = leftToRight ? i.left : menuWidth - i.right;
        if (A03SwingUtilities.isCheckIconVisible(parent)) {
            int checkIconWidth = checkIcon.getIconWidth();
            if (!leftToRight) {
                x -= checkIconWidth;
            }
            checkIcon.paintIcon(menuItem, graphics, x, (menuHeight - checkIcon.getIconHeight()) / 2);
            x = leftToRight ? (x += checkIconWidth + defaultTextIconGap) : (x -= defaultTextIconGap);
        }
        if ((maxIconWidth = A03SwingUtilities.getMaxIconWidth(parent)) > 0 && !leftToRight) {
            x -= maxIconWidth;
        }
        if ((icon = menuItem.getIcon()) != null) {
            icon.paintIcon(menuItem, graphics, x, (menuHeight - icon.getIconHeight()) / 2);
        }
        if (maxIconWidth > 0) {
            x = leftToRight ? (x += maxIconWidth + defaultTextIconGap) : (x -= defaultTextIconGap);
        }
        String text = menuItem.getText();
        FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
        int stringWidth = A03GraphicsUtilities.stringWidth(fm, text);
        if (!leftToRight) {
            x -= stringWidth;
        }
        Rectangle textRect = new Rectangle(x, (menuItem.getHeight() + fm.getAscent() - fm.getDescent()) / 2, stringWidth, menuHeight - (i.top + i.bottom));
        String acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        A03GraphicsUtilities.installDesktopHints(graphics);
        KeyStroke accelerator = menuItem.getAccelerator();
        if (accelerator != null) {
            int keyCode;
            StringBuilder builder = new StringBuilder();
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                builder.append(KeyEvent.getKeyModifiersText(modifiers));
                builder.append(acceleratorDelimiter);
            }
            if ((keyCode = accelerator.getKeyCode()) != 0) {
                builder.append(KeyEvent.getKeyText(keyCode));
            } else {
                builder.append(accelerator.getKeyChar());
            }
            FontMetrics fmAccel = menuItem.getFontMetrics(acceleratorFont);
            String acceleratorText = builder.toString();
            int accelStringWidth = A03GraphicsUtilities.stringWidth(fmAccel, acceleratorText);
            Rectangle acceleratorRect = new Rectangle(0, 1, accelStringWidth, fmAccel.getHeight());
            acceleratorRect.x = leftToRight ? menuWidth - acceleratorRect.width - 2 - i.right : i.left + 2;
            if (A03SwingUtilities.isArrowIconVisible(parent)) {
                int arrowIconWidth = UIManager.getIcon("Menu.arrowIcon").getIconWidth();
                acceleratorRect.x = leftToRight ? (acceleratorRect.x -= arrowIconWidth) : (acceleratorRect.x += arrowIconWidth);
            }
            Font oldfont = graphics.getFont();
            graphics.setFont(acceleratorFont);
            delegate.paintAcceleratorText(menuItem, graphics, acceleratorText, acceleratorRect.x, acceleratorRect.y + fmAccel.getAscent());
            graphics.setFont(oldfont);
        }
        if (menuItem.getParent() instanceof JMenuBar) {
            textRect.x = leftToRight ? (textRect.x += defaultTextIconGap) : (textRect.x -= defaultTextIconGap);
        }
        delegate.paintText(menuItem, graphics, text, textRect.x, textRect.y);
        if (arrowIcon != null && !(menuItem.getParent() instanceof JMenuBar)) {
            x = leftToRight ? menuWidth - arrowIcon.getIconWidth() - i.right : i.left;
            arrowIcon.paintIcon(menuItem, graphics, x, textRect.y - arrowIcon.getIconHeight());
        }
        delegate.paintBorder(menuItem, graphics, 0, 0, menuWidth, menuHeight);
    }

    public static Point getPopupMenuOrigin(Class<?> cls, JMenuItem menuItem) {
        try {
            if (getPopupMenuOriginMethod == null) {
                getPopupMenuOriginMethod = cls.getDeclaredMethod("getPopupMenuOrigin", new Class[0]);
                getPopupMenuOriginMethod.setAccessible(true);
            }
            return (Point)getPopupMenuOriginMethod.invoke((Object)menuItem, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("No method getPopupMenuOrigin() defined in class " + cls.getName() + "with specified parameter types.");
        }
    }

    public static Dimension getPreferredButtonSize(AbstractButton b, int textIconGap) {
        Dimension baseDimension;
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : b.getIconTextGap());
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        Dimension result = baseDimension = r.getSize();
        if (text != null && text.length() > 0) {
            int baseWidth = baseDimension.width;
            baseWidth = Math.max(baseWidth, A03SwingUtilities.getMinButtonWidth(b.getFont().getSize()));
            result = new Dimension(baseWidth, baseDimension.height);
            int baseHeight = result.height;
            baseHeight = Math.max(baseHeight, A03SwingUtilities.getMinButtonHeight(b.getFont().getSize()));
            result = new Dimension(result.width, baseHeight);
        }
        if (icon != null) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - 6.0) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - 6.0) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + 6, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + 6);
        }
        return result;
    }

    public static int getMinButtonHeight(int fontSize) {
        return 11 + (fontSize - 5) * 3 / 2;
    }

    public static int getMinButtonWidth(int fontSize) {
        return A03SwingUtilities.getMinButtonHeight(fontSize);
    }
}

