/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03ArrowButton;
import a03.swing.plaf.A03SpinnerDelegate;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plugin.A03PluginManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class A03SpinnerUI
extends BasicSpinnerUI {
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListenerImpl();
    protected JButton nextButton;
    protected JButton prevButton;
    private A03SpinnerDelegate delegate;

    public static ComponentUI createUI(JComponent c) {
        return new A03SpinnerUI();
    }

    public void installUI(JComponent c) {
        this.delegate = (A03SpinnerDelegate)A03SwingUtilities.getDelegate(c, UIManager.get("Spinner.delegate"));
        super.installUI(c);
        A03PluginManager.getInstance().registerComponent(this.spinner);
    }

    public void uninstallUI(JComponent c) {
        A03PluginManager.getInstance().unregisterComponent(this.spinner);
        super.uninstallUI(c);
    }

    private void updateBackground(JSpinner c) {
        Color background = c.getBackground();
        if (background instanceof UIResource) {
            Color disabledBG = UIManager.getColor("Spinner.disabledBackground");
            Color bg = UIManager.getColor("Spinner.background");
            Color newColor = null;
            if (!c.isEnabled()) {
                newColor = disabledBG;
            }
            if (newColor == null) {
                newColor = bg;
            }
            if (newColor != null && newColor != background) {
                c.setBackground(newColor);
                c.getEditor().setBackground(newColor);
            }
        }
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateBackground(this.spinner);
    }

    protected void installListeners() {
        super.installListeners();
        this.spinner.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.spinner.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected Component createPreviousButton() {
        this.prevButton = this.createArrowButton(5);
        this.prevButton.setName("Spinner.previousButton");
        this.prevButton.setBorder(UIManager.getBorder("Spinner.arrowButtonBorder"));
        this.installPreviousButtonListeners(this.prevButton);
        return this.prevButton;
    }

    protected Component createNextButton() {
        this.nextButton = this.createArrowButton(1);
        this.nextButton.setName("Spinner.nextButton");
        this.nextButton.setBorder(UIManager.getBorder("Spinner.arrowButtonBorder"));
        this.installNextButtonListeners(this.nextButton);
        return this.nextButton;
    }

    private JButton createArrowButton(int direction) {
        A03ArrowButton button = new A03ArrowButton(direction, this.delegate);
        button.setInheritsPopupMenu(true);
        return button;
    }

    public void paint(Graphics g, JComponent c) {
        int width = c.getWidth();
        int height = c.getHeight();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setColor(c.getBackground());
        graphics.fillRect(0, 0, width - 1, height - 1);
        graphics.dispose();
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayoutManager();
    }

    class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        PropertyChangeListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                A03SpinnerUI.this.updateBackground(A03SpinnerUI.this.spinner);
            } else if (evt.getPropertyName().equals("editor")) {
                JComponent newEditor = (JComponent)evt.getNewValue();
                Component[] componentArray = newEditor.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    c.setBackground(A03SpinnerUI.this.spinner.getBackground());
                    ++n2;
                }
            }
        }
    }

    protected class SpinnerLayoutManager
    implements LayoutManager {
        protected SpinnerLayoutManager() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension buttonSize = UIManager.getDimension("Spinner.arrowButtonSize");
            Dimension editorD = A03SpinnerUI.this.spinner.getEditor().getPreferredSize();
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += buttonSize.width;
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            Insets buttonInsets = A03SpinnerUI.this.nextButton.getInsets();
            size.width += buttonInsets.left + buttonInsets.right;
            return size;
        }

        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Dimension buttonSize = UIManager.getDimension("Spinner.arrowButtonSize");
            Insets insets = parent.getInsets();
            int buttonsWidth = buttonSize.width;
            int editorHeight = height - (insets.top + insets.bottom);
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth;
                buttonsX = width - buttonsWidth - insets.right;
            } else {
                buttonsX = insets.left;
                editorX = buttonsX + buttonsWidth;
                editorWidth = width - buttonsWidth - insets.right;
            }
            int nextY = insets.top;
            int nextHeight = (height - insets.top - insets.bottom) / 2;
            int previousY = nextY + nextHeight;
            int previousHeight = nextHeight;
            A03SpinnerUI.this.spinner.getEditor().setBounds(editorX, insets.top, editorWidth, editorHeight);
            A03SpinnerUI.this.nextButton.setBounds(buttonsX, nextY, buttonsWidth, nextHeight);
            A03SpinnerUI.this.prevButton.setBounds(buttonsX, previousY, buttonsWidth, previousHeight);
        }
    }
}

