/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03TitlePane;
import a03.swing.plugin.A03PluginManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class A03RootPaneUI
extends BasicRootPaneUI {
    private Window window;
    private JComponent titlePane;
    private MouseInputListener mouseInputListener;
    private MouseInputListener titleMouseInputHandler;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    protected JRootPane root;
    protected Window currentWindow;
    protected Dimension currentSize;
    protected HierarchyListener hierarchyListener;
    protected ComponentListener windowComponentListener;
    protected GraphicsConfiguration currentRootPaneGC;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    protected static Method getLocationOnScreenMethod;
    protected WindowListener windowListener;
    private static final int[] cursorMapping;

    static {
        try {
            getLocationOnScreenMethod = MouseEvent.class.getDeclaredMethod("getLocationOnScreen", new Class[0]);
        }
        catch (Exception e) {
            getLocationOnScreenMethod = null;
        }
        int[] nArray = new int[25];
        nArray[0] = 6;
        nArray[1] = 6;
        nArray[2] = 8;
        nArray[3] = 7;
        nArray[4] = 7;
        nArray[5] = 6;
        nArray[9] = 7;
        nArray[10] = 10;
        nArray[14] = 11;
        nArray[15] = 4;
        nArray[16] = 4;
        nArray[18] = 5;
        nArray[19] = 5;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 9;
        nArray[23] = 5;
        nArray[24] = 5;
        cursorMapping = nArray;
    }

    public static ComponentUI createUI(JComponent c) {
        return new A03RootPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.root = (JRootPane)c;
        int style = this.root.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(this.root);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    public void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, "RootPane.border");
        }
    }

    private void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(root);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
            if (this.titlePane != null) {
                if (this.titleMouseInputHandler == null) {
                    this.titleMouseInputHandler = new TitleMouseInputHandler();
                }
                this.titlePane.addMouseMotionListener(this.titleMouseInputHandler);
                this.titlePane.addMouseListener(this.titleMouseInputHandler);
            }
            this.setMaximized();
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.titlePane != null) {
            this.titlePane.removeMouseListener(this.titleMouseInputHandler);
            this.titlePane.removeMouseMotionListener(this.titleMouseInputHandler);
        }
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    protected void installListeners(final JRootPane root) {
        super.installListeners(root);
        this.hierarchyListener = new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                Container parent = root.getParent();
                if (parent != null) {
                    Window currWindow = null;
                    currWindow = root.getParent() instanceof Window ? (Window)root.getParent() : SwingUtilities.getWindowAncestor(root.getParent());
                    if (A03RootPaneUI.this.windowComponentListener != null) {
                        A03RootPaneUI.this.currentWindow.removeComponentListener(A03RootPaneUI.this.windowComponentListener);
                        A03RootPaneUI.this.windowComponentListener = null;
                    }
                    if (currWindow != null) {
                        A03RootPaneUI.this.windowComponentListener = new ComponentAdapter(){

                            public void componentMoved(ComponentEvent e) {
                                this.processNewPosition();
                            }

                            public void componentResized(ComponentEvent e) {
                                this.processNewPosition();
                            }

                            protected void processNewPosition() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        ((this).this).A03RootPaneUI.this.currentRootPaneGC = null;
                                        if (!A03RootPaneUI.this.window.isShowing()) {
                                            return;
                                        }
                                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                                        GraphicsDevice[] gds = ge.getScreenDevices();
                                        Point midLoc = new Point(((A03RootPaneUI)((this).this).A03RootPaneUI.this).window.getLocationOnScreen().x + A03RootPaneUI.this.window.getWidth() / 2, ((A03RootPaneUI)((this).this).A03RootPaneUI.this).window.getLocationOnScreen().y);
                                        if (midLoc.y < 0) {
                                            midLoc.y = 0;
                                        }
                                        int index = 0;
                                        GraphicsDevice[] graphicsDeviceArray = gds;
                                        int n = gds.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            GraphicsDevice gd = graphicsDeviceArray[n2];
                                            GraphicsConfiguration gc = gd.getDefaultConfiguration();
                                            Rectangle bounds = gc.getBounds();
                                            if (bounds.contains(midLoc)) {
                                                ((this).this).A03RootPaneUI.this.currentRootPaneGC = gc;
                                                A03RootPaneUI.this.setMaximized();
                                                break;
                                            }
                                            ++index;
                                            ++n2;
                                        }
                                    }
                                });
                            }
                        };
                        if (parent instanceof JFrame) {
                            currWindow.addComponentListener(A03RootPaneUI.this.windowComponentListener);
                        }
                        A03RootPaneUI.this.window = currWindow;
                    }
                    A03RootPaneUI.this.currentWindow = currWindow;
                    if (A03RootPaneUI.this.currentWindow != null) {
                        A03PluginManager.getInstance().registerComponent(A03RootPaneUI.this.currentWindow);
                    }
                }
            }
        };
        root.addHierarchyListener(this.hierarchyListener);
    }

    protected void uninstallListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeComponentListener(this.windowComponentListener);
            this.window.removeWindowListener(this.windowListener);
            this.windowComponentListener = null;
            this.windowListener = null;
        }
        root.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        super.uninstallListeners(root);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        JComponent titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.window != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    protected JComponent createTitlePane(JRootPane root) {
        return new A03TitlePane(root, this);
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane root) {
        return new MouseInputHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new A03RootLayout();
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            A03PluginManager.getInstance().unregisterComponent(oldTitlePane);
            if (oldTitlePane instanceof A03TitlePane) {
                ((A03TitlePane)oldTitlePane).uninstall();
            }
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            A03PluginManager.getInstance().registerComponent(titlePane);
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    private void setMaximized() {
        Container tla = this.root.getTopLevelAncestor();
        GraphicsConfiguration gc = this.currentRootPaneGC != null ? this.currentRootPaneGC : tla.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        screenBounds.x = 0;
        screenBounds.y = 0;
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Border rootBorder = this.root.getBorder();
        Insets insets = rootBorder == null ? new Insets(0, 0, 0, 0) : rootBorder.getBorderInsets(this.root);
        Rectangle maxBounds = new Rectangle(screenBounds.x + screenInsets.left - insets.left, screenBounds.y + screenInsets.top - insets.right, screenBounds.width - (screenInsets.left + screenInsets.right - insets.left - insets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom - insets.top - insets.bottom));
        if (tla instanceof JFrame) {
            ((JFrame)tla).setMaximizedBounds(maxBounds);
        }
    }

    public JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e.getSource();
            int style = root.getWindowDecorationStyle();
            this.uninstallClientDecorations(root);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
    }

    public void update(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (c.isOpaque()) {
            graphics.setColor(c.getBackground());
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(graphics, c);
        graphics.dispose();
    }

    protected static class A03RootLayout
    implements LayoutManager2 {
        protected A03RootLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof A03RootPaneUI && (titlePane = ((A03RootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof A03RootPaneUI && (titlePane = ((A03RootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof A03RootPaneUI && (titlePane = ((A03RootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof A03RootPaneUI && (titlePane = ((A03RootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;
        private final PrivilegedExceptionAction<Point> getLocationAction = new PrivilegedExceptionAction<Point>(){

            @Override
            public Point run() throws HeadlessException {
                return MouseInfo.getPointerInfo().getLocation();
            }
        };

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent ev) {
            int frameState;
            JRootPane rootPane = A03RootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w = (Window)ev.getSource();
            if (w != null) {
                w.toFront();
            }
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, A03RootPaneUI.this.getTitlePane());
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int n = frameState = f != null ? f.getExtendedState() : 0;
            if (A03RootPaneUI.this.getTitlePane() != null && A03RootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset)) {
                Insets insets = A03RootPaneUI.this.getRootPane().getInsets();
                if ((f != null && (frameState & 6) == 0 || d != null) && dragWindowOffset.y >= insets.top && dragWindowOffset.x >= insets.left && dragWindowOffset.x < w.getWidth() - insets.right) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                }
            } else if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w.getWidth();
                this.dragHeight = w.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && A03RootPaneUI.this.window != null && !A03RootPaneUI.this.window.isValid()) {
                A03RootPaneUI.this.window.validate();
                A03RootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        public void mouseMoved(MouseEvent ev) {
            JRootPane root = A03RootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = (Window)ev.getSource();
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int cursor = this.getCursor(this.calculateCorner(w, ev.getX(), ev.getY()));
            if (cursor != 0 && (f != null && f.isResizable() && (f.getExtendedState() & 6) == 0 || d != null && d.isResizable())) {
                w.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                w.setCursor(A03RootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        public void mouseDragged(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Point pt = ev.getPoint();
            if (this.isMovingWindow) {
                try {
                    Point windowPt = AccessController.doPrivileged(this.getLocationAction);
                    windowPt.x -= this.dragOffsetX;
                    windowPt.y -= this.dragOffsetY;
                    w.setLocation(windowPt);
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else if (this.dragCursor != 0) {
                Rectangle r = w.getBounds();
                Rectangle startBounds = new Rectangle(r);
                Dimension min = w.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                }
                if (!r.equals(startBounds)) {
                    w.setBounds(r);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        w.validate();
                        A03RootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            A03RootPaneUI.this.lastCursor = w.getCursor();
            this.mouseMoved(ev);
        }

        public void mouseExited(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            w.setCursor(A03RootPaneUI.this.lastCursor);
        }

        public void mouseClicked(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Frame f = null;
            if (!(w instanceof Frame)) {
                return;
            }
            f = (Frame)w;
            Point convertedPoint = SwingUtilities.convertPoint(w, ev.getPoint(), A03RootPaneUI.this.getTitlePane());
            int state = f.getExtendedState();
            if (A03RootPaneUI.this.getTitlePane() != null && A03RootPaneUI.this.getTitlePane().contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
                if ((state & 6) != 0) {
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    f.setExtendedState(state | 6);
                }
                return;
            }
        }

        private int calculateCorner(Window w, int x, int y) {
            Insets insets = w.getInsets();
            int xPosition = this.calculatePosition(x - insets.left, w.getWidth() - insets.left - insets.right);
            int yPosition = this.calculatePosition(y - insets.top, w.getHeight() - insets.top - insets.bottom);
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return cursorMapping[corner];
        }

        private int calculatePosition(int spot, int width) {
            Insets insets = A03RootPaneUI.this.getRootPane().getInsets();
            if (spot < insets.left) {
                return 0;
            }
            if (spot >= width - insets.right) {
                return 4;
            }
            return 2;
        }
    }

    private class TitleMouseInputHandler
    extends MouseInputAdapter {
        private Point dragOffset = new Point(0, 0);

        private TitleMouseInputHandler() {
        }

        public void mousePressed(MouseEvent ev) {
            JRootPane rootPane = A03RootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Component source = (Component)ev.getSource();
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(source, dragWindowOffset, A03RootPaneUI.this.getTitlePane());
            dragWindowOffset = SwingUtilities.convertPoint(source, dragWindowOffset, A03RootPaneUI.this.window);
            if (A03RootPaneUI.this.getTitlePane() != null && A03RootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset) && A03RootPaneUI.this.window != null) {
                A03RootPaneUI.this.window.toFront();
                this.dragOffset = dragWindowOffset;
            }
        }

        public void mouseDragged(MouseEvent ev) {
            Component source = (Component)ev.getSource();
            Point eventLocationOnScreen = null;
            if (getLocationOnScreenMethod != null) {
                try {
                    eventLocationOnScreen = (Point)getLocationOnScreenMethod.invoke((Object)ev, new Object[0]);
                }
                catch (Exception exc) {
                    eventLocationOnScreen = null;
                }
            }
            if (eventLocationOnScreen == null) {
                eventLocationOnScreen = new Point(ev.getX() + source.getLocationOnScreen().x, ev.getY() + source.getLocationOnScreen().y);
            }
            if (A03RootPaneUI.this.window instanceof Frame) {
                int frameState;
                Frame f = (Frame)A03RootPaneUI.this.window;
                int n = frameState = f != null ? f.getExtendedState() : 0;
                if (f != null && (frameState & 6) == 0) {
                    A03RootPaneUI.this.window.setLocation(eventLocationOnScreen.x - this.dragOffset.x, eventLocationOnScreen.y - this.dragOffset.y);
                }
            } else {
                A03RootPaneUI.this.window.setLocation(eventLocationOnScreen.x - this.dragOffset.x, eventLocationOnScreen.y - this.dragOffset.y);
            }
        }

        public void mouseClicked(MouseEvent ev) {
            Frame f = null;
            if (!(A03RootPaneUI.this.window instanceof Frame)) {
                return;
            }
            f = (Frame)A03RootPaneUI.this.window;
            Point convertedPoint = SwingUtilities.convertPoint(A03RootPaneUI.this.window, ev.getPoint(), A03RootPaneUI.this.getTitlePane());
            int state = f.getExtendedState();
            if (A03RootPaneUI.this.getTitlePane() != null && A03RootPaneUI.this.getTitlePane().contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
                if ((state & 6) != 0) {
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    f.setExtendedState(state | 6);
                }
                return;
            }
        }
    }
}

