/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03RadioButtonDelegate;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plugin.A03PluginManager;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class A03RadioButtonUI
extends BasicRadioButtonUI {
    private static A03RadioButtonUI ui = new A03RadioButtonUI();
    private A03RadioButtonDelegate delegate;

    public static ComponentUI createUI(JComponent c) {
        return ui;
    }

    public void installUI(JComponent c) {
        this.delegate = (A03RadioButtonDelegate)A03SwingUtilities.getDelegate(c, UIManager.get(String.valueOf(this.getPropertyPrefix()) + "delegate"));
        super.installUI(c);
        A03PluginManager.getInstance().registerComponent(c);
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.putClientProperty("A03_ORIGINAL_OPACITY", b.isOpaque());
        b.setOpaque(false);
    }

    public void uninstallUI(JComponent c) {
        A03PluginManager.getInstance().unregisterComponent(c);
        super.uninstallUI(c);
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setOpaque((Boolean)b.getClientProperty("A03_ORIGINAL_OPACITY"));
        b.putClientProperty("A03_ORIGINAL_OPACITY", null);
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        FontMetrics fm = c.getFontMetrics(g.getFont());
        int x = textRect.x + this.getTextShiftOffset();
        int y = textRect.y + this.getTextShiftOffset() + fm.getAscent();
        this.delegate.paintText(c, g, text, x, y);
    }

    public synchronized void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g;
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension size = c.getSize();
        Font f = c.getFont();
        graphics.setFont(f);
        FontMetrics fm = c.getFontMetrics(f);
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = c.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Icon altIcon = b.getIcon();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            graphics.setColor(b.getBackground());
            graphics.fillRect(0, 0, size.width, size.height);
        }
        if (altIcon != null) {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, graphics, iconRect.x, iconRect.y);
        } else {
            this.getDefaultIcon().paintIcon(c, graphics, iconRect.x, iconRect.y);
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        A03GraphicsUtilities.installDesktopHints(graphics);
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(graphics, textRect);
            } else {
                this.paintText(g, c, textRect, text);
            }
            if (b.hasFocus() && b.isFocusPainted() && textRect.width > 0 && textRect.height > 0) {
                this.paintFocus(graphics, textRect, size);
            }
        }
    }

    public void update(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (c.isOpaque()) {
            graphics.setColor(c.getBackground());
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(graphics, c);
        graphics.dispose();
    }
}

