/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03ProgressBarDelegate;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plugin.A03PluginManager;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class A03ProgressBarUI
extends BasicProgressBarUI {
    private int animationIndex = 0;
    private A03ProgressBarDelegate delegate;

    public static ComponentUI createUI(JComponent c) {
        return new A03ProgressBarUI();
    }

    public void installUI(JComponent c) {
        this.delegate = (A03ProgressBarDelegate)A03SwingUtilities.getDelegate(c, UIManager.get("ProgressBar.delegate"));
        super.installUI(c);
        A03PluginManager.getInstance().registerComponent(c);
    }

    public void uninstallUI(JComponent c) {
        A03PluginManager.getInstance().unregisterComponent(c);
        super.uninstallUI(c);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.progressBar.putClientProperty("A03_ORIGINAL_OPACITY", this.progressBar.isOpaque());
        this.progressBar.setOpaque(false);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.progressBar.setOpaque((Boolean)this.progressBar.getClientProperty("A03_ORIGINAL_OPACITY"));
        this.progressBar.putClientProperty("A03_ORIGINAL_OPACITY", null);
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        Insets insets = c.getInsets();
        int barRectWidth = c.getWidth() - (insets.right + insets.left);
        int barRectHeight = c.getHeight() - (insets.top + insets.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(insets, barRectWidth, barRectHeight);
        this.delegate.paintDeterminate(this.progressBar, g, amountFull);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, insets.left, insets.top, barRectWidth, barRectHeight, insets);
        }
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        Insets insets = this.progressBar.getInsets();
        g.translate(insets.left, insets.top);
        int barRectWidth = this.progressBar.getWidth() - (insets.right + insets.left);
        int barRectHeight = this.progressBar.getHeight() - (insets.top + insets.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        this.delegate.paintIndeterminate(this.progressBar, g, this.animationIndex);
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g, insets.left, insets.top, barRectWidth, barRectHeight, insets);
            } else {
                this.paintString(g, insets.left, insets.top, barRectWidth, barRectHeight, insets);
            }
        }
        this.progressBar.repaint();
    }

    private void paintString(Graphics g, int x, int y, int width, int height, Insets b) {
        Font font;
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        A03GraphicsUtilities.installDesktopHints(graphics);
        String progressString = this.progressBar.getString();
        Point renderLocation = this.getStringPlacement(graphics, progressString, x, y, width, height);
        if (this.progressBar.getOrientation() == 0) {
            font = this.progressBar.getFont();
        } else {
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            font = this.progressBar.getFont().deriveFont(rotate);
        }
        graphics.setFont(font);
        if (this.progressBar.isEnabled()) {
            graphics.setColor(this.progressBar.getForeground());
        } else {
            graphics.setColor(UIManager.getColor("textInactiveText"));
        }
        this.delegate.paintText(this.progressBar, graphics, progressString, renderLocation.x, renderLocation.y);
    }

    protected Point getStringPlacement(Graphics g, String progressString, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics(this.progressBar.getFont());
        int stringWidth = A03GraphicsUtilities.stringWidth(fm, progressString);
        if (this.progressBar.getOrientation() == 0) {
            return new Point(x + Math.round(width / 2 - stringWidth / 2), y + (height + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2);
        }
        return new Point(x + width - (width + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2, y + Math.round(height / 2 - stringWidth / 2));
    }

    protected void incrementAnimationIndex() {
        ++this.animationIndex;
    }

    protected void setAnimationIndex(int newValue) {
        this.animationIndex = newValue;
    }

    protected int getAnimationIndex() {
        return this.animationIndex;
    }

    protected Dimension getPreferredInnerHorizontal() {
        return this.delegate.getPreferredInnerHorizontal();
    }

    protected Dimension getPreferredInnerVertical() {
        return this.delegate.getPreferredInnerVertical();
    }

    public void update(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        if (c.isOpaque()) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(c.getBackground());
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(graphics, c);
        graphics.dispose();
    }
}

