/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03ListDelegate;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plugin.A03PluginManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class A03ListUI
extends BasicListUI {
    private static Method convertLocationToRowInColumnMethod;
    private static Method getCellBoundsMethods;
    private A03ListDelegate delegate;

    static {
        try {
            convertLocationToRowInColumnMethod = BasicListUI.class.getDeclaredMethod("convertLocationToRowInColumn", Integer.TYPE, Integer.TYPE);
            convertLocationToRowInColumnMethod.setAccessible(true);
            getCellBoundsMethods = BasicListUI.class.getDeclaredMethod("getCellBounds", JList.class, Integer.TYPE, Integer.TYPE);
            getCellBoundsMethods.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new A03ListUI();
    }

    public void installUI(JComponent c) {
        this.delegate = (A03ListDelegate)A03SwingUtilities.getDelegate(c, UIManager.get("List.delegate"));
        super.installUI(c);
        A03PluginManager.getInstance().registerComponent(c);
    }

    public void uninstallUI(JComponent c) {
        A03PluginManager.getInstance().unregisterComponent(c);
        super.uninstallUI(c);
    }

    public void paint(Graphics g, JComponent c) {
        if (this.list.getLayoutOrientation() == 0) {
            try {
                Rectangle paintBounds = g.getClipBounds();
                int maxY = paintBounds.y + paintBounds.height;
                int row = this.list.getModel().getSize() - 1;
                if (row > 0) {
                    Rectangle rowBounds = (Rectangle)getCellBoundsMethods.invoke((Object)this, this.list, row, row);
                    int x = rowBounds.x;
                    int y = rowBounds.y + rowBounds.height;
                    ++row;
                    int y0 = y;
                    while (y0 < maxY) {
                        g.setColor(this.delegate.getBackground(this.list, this.list.getLayoutOrientation(), row));
                        g.fillRect(x, y0, rowBounds.width, rowBounds.height);
                        y0 += rowBounds.height;
                        ++row;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.paint(g, c);
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        if (isSelected) {
            boolean isEnabled = this.list.isEnabled();
            rendererComponent.setForeground(isEnabled ? this.delegate.getSelectionForeground() : this.delegate.getDisabledSelectionForeground());
            g.setColor(isEnabled ? this.delegate.getSelectionBackground() : this.delegate.getDisabledSelectionBackground());
        } else {
            rendererComponent.setForeground(this.delegate.getForeground(this.list, this.list.getLayoutOrientation(), row));
            g.setColor(this.delegate.getBackground(this.list, this.list.getLayoutOrientation(), row));
        }
        g.fillRect(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
        this.rendererPane.paintComponent(g, rendererComponent, this.list, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, true);
    }

    public void update(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (c.isOpaque()) {
            Rectangle2D rectangle = (Rectangle2D)g.getClip();
            graphics.setColor(c.getBackground());
            graphics.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        }
        this.paint(graphics, c);
        graphics.dispose();
    }
}

