/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03RGBColorChooserPanel;
import a03.swing.widget.A03ColorPreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicColorChooserUI;

public class A03ColorChooserUI
extends BasicColorChooserUI {
    private JPanel previewContainer;
    protected JComponent previewPanel;
    protected ChangeListener changeListener;
    private JTabbedPane chooserContainer;

    public static ComponentUI createUI(JComponent c) {
        return new A03ColorChooserUI();
    }

    public void installUI(JComponent c) {
        this.chooser = (JColorChooser)c;
        this.installDefaults();
        this.installListeners();
        this.chooser.setLayout(new BorderLayout());
        this.previewContainer = new JPanel(new BorderLayout());
        this.chooserContainer = new JTabbedPane();
        this.chooser.add((Component)this.chooserContainer, "Center");
        A03RGBColorChooserPanel chooserPanel = new A03RGBColorChooserPanel(this.chooser);
        chooserPanel.setPreviewContainer(this.previewContainer);
        AbstractColorChooserPanel[] choosers = new AbstractColorChooserPanel[]{chooserPanel};
        this.chooser.setChooserPanels(choosers);
        this.installPreviewPanel();
    }

    public void uninstallUI(JComponent c) {
        this.chooser.removeAll();
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.defaultChoosers = null;
        this.chooser = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String prop = evt.getPropertyName();
                if (prop == "chooserPanels") {
                    AbstractColorChooserPanel[] newPanels;
                    AbstractColorChooserPanel[] oldPanels;
                    AbstractColorChooserPanel[] abstractColorChooserPanelArray = oldPanels = (AbstractColorChooserPanel[])evt.getOldValue();
                    int n = oldPanels.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractColorChooserPanel oldPanel = abstractColorChooserPanelArray[n2];
                        oldPanel.uninstallChooserPanel(A03ColorChooserUI.this.chooser);
                        ++n2;
                    }
                    A03ColorChooserUI.this.chooserContainer.removeAll();
                    AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = newPanels = (AbstractColorChooserPanel[])evt.getNewValue();
                    int n3 = newPanels.length;
                    n = 0;
                    while (n < n3) {
                        AbstractColorChooserPanel newPanel = abstractColorChooserPanelArray2[n];
                        newPanel.installChooserPanel(A03ColorChooserUI.this.chooser);
                        A03ColorChooserUI.this.chooserContainer.addTab(newPanel.getDisplayName(), newPanel);
                        ++n;
                    }
                } else if (prop == "previewPanel") {
                    A03ColorChooserUI.this.previewPanel = (JComponent)evt.getNewValue();
                    A03ColorChooserUI.this.previewPanel.setForeground(A03ColorChooserUI.this.chooser.getColor());
                    A03ColorChooserUI.this.chooser.setPreviewPanel(A03ColorChooserUI.this.previewPanel);
                }
            }
        };
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ColorSelectionModel model = (ColorSelectionModel)e.getSource();
                if (A03ColorChooserUI.this.previewPanel != null) {
                    A03ColorChooserUI.this.previewPanel.setForeground(model.getSelectedColor());
                    A03ColorChooserUI.this.previewPanel.repaint();
                }
            }
        };
        this.chooser.getSelectionModel().addChangeListener(this.changeListener);
    }

    protected void installPreviewPanel() {
        this.previewPanel = new A03ColorPreviewPanel();
        this.previewPanel.setBorder(new EmptyBorder(0, 0, 0, 1));
        this.previewPanel.setForeground(this.chooser.getColor());
        this.chooser.setPreviewPanel(this.previewPanel);
    }

    protected void uninstallDefaultChoosers() {
        this.chooserContainer.removeAll();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
    }

    protected void uninstallDefaults() {
    }
}

