/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03ButtonDelegate;
import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plugin.A03PluginManager;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class A03ButtonUI
extends BasicButtonUI {
    private static final ComponentUI ui = new A03ButtonUI();
    private A03ButtonDelegate delegate;

    public static ComponentUI createUI(JComponent c) {
        return ui;
    }

    public void installUI(JComponent c) {
        this.delegate = (A03ButtonDelegate)A03SwingUtilities.getDelegate(c, UIManager.get(String.valueOf(this.getPropertyPrefix()) + "delegate"));
        super.installUI(c);
        A03PluginManager.getInstance().registerComponent(c);
    }

    public void uninstallUI(JComponent c) {
        A03PluginManager.getInstance().unregisterComponent(c);
        super.uninstallUI(c);
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.putClientProperty("A03_ORIGINAL_OPACITY", b.isOpaque());
        b.setOpaque(false);
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setOpaque((Boolean)b.getClientProperty("A03_ORIGINAL_OPACITY"));
        b.putClientProperty("A03_ORIGINAL_OPACITY", null);
    }

    public boolean contains(JComponent c, int x, int y) {
        return this.delegate.contains(c, x, y);
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        A03GraphicsUtilities.installDesktopHints(graphics);
        if (b.isContentAreaFilled()) {
            this.delegate.paintBackground(c, graphics);
        }
        super.paint(graphics, c);
        graphics.dispose();
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        FontMetrics fm = c.getFontMetrics(g.getFont());
        int x = textRect.x + this.getTextShiftOffset();
        int y = textRect.y + this.getTextShiftOffset() + fm.getAscent();
        this.delegate.paintText(c, g, text, x, y);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        this.delegate.paintFocus(b, g, viewRect, textRect, iconRect);
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        return A03SwingUtilities.getPreferredButtonSize(b, b.getIconTextGap());
    }

    public void update(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (c.isOpaque()) {
            graphics.setColor(c.getBackground());
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(graphics, c);
        graphics.dispose();
    }
}

