/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03ArrowButtonDelegate;
import a03.swing.plaf.A03BorderDelegate;
import a03.swing.plaf.A03ButtonDelegate;
import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03ListDelegate;
import a03.swing.plaf.A03OptionPaneDelegate;
import a03.swing.plaf.A03ScrollPaneDelegate;
import a03.swing.plaf.A03SplitPaneDelegate;
import a03.swing.plaf.A03TableDelegate;
import a03.swing.plaf.A03TableHeaderDelegate;
import a03.swing.plaf.A03TextComponentDelegate;
import a03.swing.plaf.A03TitledBorderDelegate;
import a03.swing.plaf.A03ToolBarDelegate;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class A03BorderFactory {
    public static Border createButtonBorder(A03ButtonDelegate delegate) {
        return new BorderUIResource.CompoundBorderUIResource(new DelegatedBorder(delegate), new ButtonMarginBorder());
    }

    public static Border createArrowButtonDelegatedBorder(A03ArrowButtonDelegate delegate) {
        return new BorderUIResource.CompoundBorderUIResource(new ArrowButtonDelegatedBorder(delegate), new ArrowButtonMarginBorder(delegate));
    }

    public static Border createDelegatedBorder(A03BorderDelegate delegate) {
        return new DelegatedBorder(delegate);
    }

    public static Border createSplitPaneDividerBorder(A03SplitPaneDelegate delegate) {
        return new SplitPaneDividerBorder(delegate);
    }

    public static Border createScrollPaneTableBorder(A03TableDelegate delegate) {
        return new ScrollPaneTableBorder(delegate);
    }

    public static Border createTableFocusSelectedCellHighlightBorder(A03TableDelegate delegate) {
        return new TableFocusSelectedCellHighlightBorder(delegate);
    }

    public static Border createListFocusCellHighlightBorder(A03ListDelegate delegate) {
        return new ListFocusCellHighlightBorder(delegate);
    }

    public static Border createListNoFocusBorder(A03ListDelegate delegate) {
        return new ListNoFocusBorder(delegate);
    }

    public static Border createToolBarNonRolloverToggleBorder(A03ToolBarDelegate delegate) {
        return new BorderUIResource.CompoundBorderUIResource(new ToolBarButtonBorder(), new ToolBarMarginBorder(delegate));
    }

    public static Border createToolBarNonRolloverBorder(A03ToolBarDelegate delegate) {
        return new BorderUIResource.CompoundBorderUIResource(new ToolBarButtonBorder(), new ToolBarMarginBorder(delegate));
    }

    public static Border createScrollPaneViewportBorder(A03ScrollPaneDelegate delegate) {
        return new ScrollPaneViewportBorder(delegate);
    }

    public static Border createOptionPaneMessageAreaBorder(A03OptionPaneDelegate delegate) {
        return new OptionPaneMessageAreaBorder(delegate);
    }

    public static Border createOptionPaneButtonAreaBorder(A03OptionPaneDelegate delegate) {
        return new OptionPaneButtonAreaBorder(delegate);
    }

    public static Border createTitledBorder(A03TitledBorderDelegate delegate) {
        return new TitledBorder(delegate);
    }

    public static Border createTableHeaderCellBorder(A03TableHeaderDelegate delegate) {
        return new BorderUIResource.CompoundBorderUIResource(new DelegatedBorder(delegate), new TableHeaderMarginBorder());
    }

    public static Border createTextComponentBorder(A03TextComponentDelegate delegate) {
        return new BorderUIResource.CompoundBorderUIResource(new DelegatedBorder(delegate), new TextComponentMarginBorder());
    }

    public static class ArrowButtonDelegatedBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 6765602694989528273L;
        private A03ArrowButtonDelegate delegate;

        public ArrowButtonDelegatedBorder(A03ArrowButtonDelegate delegate) {
            this.delegate = delegate;
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            Insets borderInsets = this.delegate.getArrowBorderInsets(c, insets);
            if (borderInsets != null) {
                insets.top = borderInsets.top;
                insets.left = borderInsets.left;
                insets.bottom = borderInsets.bottom;
                insets.right = borderInsets.right;
            }
            return insets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintArrowBorder(c, g, x, y, width, height);
        }
    }

    public static class ArrowButtonMarginBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 8977008175382851286L;
        private A03ArrowButtonDelegate delegate;

        public ArrowButtonMarginBorder(A03ArrowButtonDelegate delegate) {
            this.delegate = delegate;
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            InsetsUIResource margin = this.delegate.getArrowMargin();
            insets.top = margin.top;
            insets.left = margin.left;
            insets.bottom = margin.bottom;
            insets.right = margin.right;
            return insets;
        }
    }

    public static class ButtonMarginBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 3010554796378299044L;

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            AbstractButton b = (AbstractButton)c;
            Insets margin = b.getMargin();
            insets.top = margin.top;
            insets.left = margin.left;
            insets.bottom = margin.bottom;
            insets.right = margin.right;
            return insets;
        }
    }

    public static class DelegatedBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 6765602694989528273L;
        private A03BorderDelegate delegate;

        public DelegatedBorder(A03BorderDelegate delegate) {
            this.delegate = delegate;
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            Insets borderInsets = this.delegate.getBorderInsets(c, insets);
            if (borderInsets != null) {
                insets.top = borderInsets.top;
                insets.left = borderInsets.left;
                insets.bottom = borderInsets.bottom;
                insets.right = borderInsets.right;
            }
            return insets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintBorder(c, g, x, y, width, height);
        }
    }

    static class ListFocusCellHighlightBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 7968141264398216456L;
        private A03ListDelegate delegate;

        public ListFocusCellHighlightBorder(A03ListDelegate delegate) {
            this.delegate = delegate;
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 1;
            insets.left = 1;
            insets.right = 1;
            insets.bottom = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }
    }

    static class ListNoFocusBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 7968141264398216456L;
        private A03ListDelegate delegate;

        public ListNoFocusBorder(A03ListDelegate delegate) {
            this.delegate = delegate;
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 1;
            insets.left = 1;
            insets.right = 1;
            insets.bottom = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }
    }

    static class OptionPaneButtonAreaBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 7734699072720898323L;
        private A03OptionPaneDelegate delegate;

        public OptionPaneButtonAreaBorder(A03OptionPaneDelegate delegate) {
            this.delegate = delegate;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintButtonAreaBorder(c, g, x, y, width, height);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            return this.delegate.getButtonAreaBorderInsets(c, insets);
        }
    }

    static class OptionPaneMessageAreaBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 2289397920006615878L;
        private A03OptionPaneDelegate delegate;

        public OptionPaneMessageAreaBorder(A03OptionPaneDelegate delegate) {
            this.delegate = delegate;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintMessageAreaBorder(c, g, x, y, width, height);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            return this.delegate.getMessageAreaBorderInsets(c, insets);
        }
    }

    static class ScrollPaneTableBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 7968141264398216456L;
        private A03TableDelegate delegate;

        public ScrollPaneTableBorder(A03TableDelegate delegate) {
            this.delegate = delegate;
        }

        public Insets getBorderInsets(Component c) {
            return this.delegate.getScrollPaneBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintScrollPaneBorder(c, g, x, y, width, height);
        }
    }

    static class ScrollPaneViewportBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 7968141264398216456L;
        private A03ScrollPaneDelegate delegate;

        public ScrollPaneViewportBorder(A03ScrollPaneDelegate delegate) {
            this.delegate = delegate;
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            return this.delegate.getViewportBorderInsets(c, insets);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintViewportBorder(c, g, x, y, width, height);
        }
    }

    static class SplitPaneDividerBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 7698765249749822588L;
        private A03SplitPaneDelegate delegate;

        public SplitPaneDividerBorder(A03SplitPaneDelegate delegate) {
            this.delegate = delegate;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintDividerBorder(c, g, x, y, width, height);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            return this.delegate.getDividerBorderInsets(c, insets);
        }
    }

    static class TableFocusSelectedCellHighlightBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 7968141264398216456L;
        private A03TableDelegate delegate;

        public TableFocusSelectedCellHighlightBorder(A03TableDelegate delegate) {
            this.delegate = delegate;
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 2;
            insets.left = 1;
            insets.right = 2;
            insets.bottom = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }
    }

    public static class TableHeaderMarginBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 3178995686179477126L;

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = UIManager.getInsets("TableHeader.margin");
            if (margin != null) {
                insets.top = margin.top;
                insets.left = margin.left;
                insets.bottom = margin.bottom;
                insets.right = margin.right;
            }
            return insets;
        }
    }

    static class TextComponentMarginBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 3010554796378299044L;

        TextComponentMarginBorder() {
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            if (c instanceof JTextComponent) {
                Insets margin = ((JTextComponent)c).getMargin();
                if (margin != null) {
                    insets.top = margin.top;
                    insets.left = margin.left;
                    insets.bottom = margin.bottom;
                    insets.right = margin.right;
                }
            } else {
                insets.top = 0;
                insets.left = 0;
                insets.bottom = 0;
                insets.right = 0;
            }
            return insets;
        }
    }

    static class TitledBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -2670058652954901675L;
        private A03TitledBorderDelegate delegate;

        public TitledBorder(A03TitledBorderDelegate delegate) {
            this.delegate = delegate;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            A03GraphicsUtilities.installDesktopHints(g);
            this.delegate.paintBorder(c, g, x, y, width, height);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            return this.delegate.getBorderInsets(c, insets);
        }
    }

    static class ToolBarButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -9026128254901451163L;

        ToolBarButtonBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            return insets;
        }
    }

    static class ToolBarMarginBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 3345689612176994793L;
        private A03ToolBarDelegate delegate;

        public ToolBarMarginBorder(A03ToolBarDelegate delegate) {
            this.delegate = delegate;
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = this.delegate.getMargin();
            if (margin != null) {
                insets.top = margin.top;
                insets.left = margin.left;
                insets.bottom = margin.bottom;
                insets.right = margin.right;
            }
            return insets;
        }
    }
}

