/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03Constants;
import a03.swing.plaf.A03ListCellRenderer;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plaf.A03TableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.awt.shell.ShellFolder;
import thirdparty.biz.lulanet.swing.SortTableCellRenderer;
import thirdparty.biz.lulanet.swing.TableSorter;

public class A03AdvancedFileChooserUI
extends BasicFileChooserUI {
    private static final int GAP = 4;
    private static List<String> fileHistory = new ArrayList<String>();
    private static List<String> directoryHistory = new ArrayList<String>();
    private static final Hashtable<String, Icon> systemIcons = new Hashtable();
    private static SimpleDateFormat simpleDateTimeFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.US);
    private JList fileList;
    private FileListModel fileListModel;
    private JTable fileTable;
    private FileTableModel fileTableModel;
    private TableSorter sorter = null;
    private JScrollPane fileScrollPane;
    private DefaultTreeModel directoryTreeModel;
    private DirectoryTreeNode currentNode;
    private JTree directoryTree;
    private JLabel filterLabel;
    private JComboBox filterComboBox;
    private ListSelectionListener listSelectionListener;
    private JLabel choiceLabel;
    private JTextField fileTextField;
    private EditableComboBoxModel historyComboBoxModel;
    private EditableComboBoxModel filterComboBoxModel;
    private JButton approveButton;
    private JButton cancelButton;
    private Locale locale;
    private JPopupMenu filePopupMenu;
    private JMenuItem newFolderItem;
    private JMenuItem deleteItem;
    private JMenuItem renameItem;
    private JPanel accessoryContainer;
    private JComboBox navigationHistoryList;
    private static NavigationHistoryComboBoxModel navigationHistoryListModel;
    private boolean filePathSelectionIsAdjusting;
    private boolean directoryTreeSelectionIsAdjusting;
    private boolean fileSelectionsIsAdjusting;
    private WildcardsFileFilter wildcardsFileFilter;

    public A03AdvancedFileChooserUI(JFileChooser fc) {
        super(fc);
        this.locale = fc.getLocale();
    }

    public static ComponentUI createUI(JComponent c) {
        return new A03AdvancedFileChooserUI((JFileChooser)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.installComponents(this.getFileChooser());
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallComponents((JFileChooser)c);
    }

    private static String getRegexPattern(String text) {
        if (!text.startsWith("*") && !text.startsWith("?")) {
            text = "^" + text;
        }
        text = text.replace("?", "(\\w)");
        text = text.replace("*", "(\\w)*");
        if (!(text = text.replace(".", "\\.")).endsWith("*")) {
            text = text.concat("$");
        }
        return "\\.\\.|" + text;
    }

    private JPanel buildNorthPanel() {
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.setBorder(new EmptyBorder(0, 0, 3, 0));
        northPanel.add(new JLabel(UIManager.getString("FileChooser.navigationHistoryText")));
        northPanel.add(Box.createHorizontalStrut(4));
        northPanel.add(this.getNavigationHistoryComboBox());
        return northPanel;
    }

    private JPanel buildSouthPanel() {
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        southPanel.setBorder(new EmptyBorder(3, 0, 0, 0));
        String str = UIManager.getString("FileChooser.fileNameLabelText");
        this.choiceLabel = new JLabel(str);
        FontMetrics fm = this.choiceLabel.getFontMetrics(this.choiceLabel.getFont());
        this.choiceLabel.setPreferredSize(new Dimension(fm.stringWidth(str), 20));
        southPanel.add(this.choiceLabel);
        southPanel.add(Box.createHorizontalStrut(4));
        this.historyComboBoxModel = new EditableComboBoxModel();
        this.historyComboBoxModel.setList(fileHistory);
        this.fileTextField = new JTextField(32);
        this.fileTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    A03AdvancedFileChooserUI.this.approveButton.doClick();
                }
            }
        });
        southPanel.add(this.fileTextField);
        southPanel.add(Box.createHorizontalStrut(8));
        str = UIManager.getString("FileChooser.filterText");
        this.filterLabel = new JLabel(str);
        fm = this.filterLabel.getFontMetrics(this.filterLabel.getFont());
        this.filterLabel.setPreferredSize(new Dimension(fm.stringWidth(str), 20));
        southPanel.add(this.filterLabel);
        southPanel.add(Box.createHorizontalStrut(4));
        this.filterComboBoxModel = new EditableComboBoxModel();
        this.wildcardsFileFilter = new WildcardsFileFilter();
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(new FilterCellRenderer());
        this.filterComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FileFilter filter;
                    Object selectedItem = A03AdvancedFileChooserUI.this.filterComboBox.getSelectedItem();
                    if (selectedItem instanceof String) {
                        A03AdvancedFileChooserUI.this.wildcardsFileFilter.setPattern((String)selectedItem);
                        filter = A03AdvancedFileChooserUI.this.wildcardsFileFilter;
                    } else {
                        filter = (FileFilter)selectedItem;
                    }
                    A03AdvancedFileChooserUI.this.filterComboBox.setEditable(filter instanceof WildcardsFileFilter);
                    A03AdvancedFileChooserUI.this.applyFilter(filter);
                }
            }
        });
        JTextField filterComboBoxEditor = (JTextField)this.filterComboBox.getEditor().getEditorComponent();
        filterComboBoxEditor.getDocument().addDocumentListener(this.getFileListModel());
        southPanel.add(this.filterComboBox);
        southPanel.add(Box.createHorizontalStrut(8));
        this.approveButton = new JButton(this.getApproveButtonText(this.getFileChooser()));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.getFileChooser()));
        this.approveButton.setEnabled(false);
        southPanel.add(this.approveButton);
        southPanel.add(Box.createHorizontalStrut(8));
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        southPanel.add(this.cancelButton);
        return southPanel;
    }

    private void applyFilter(FileFilter filter) {
        this.getFileListModel().setFilter(filter);
        this.getFileTableModel().setFilter(filter);
        this.updateDetails();
    }

    private void buildDetailsPopupMenu() {
        this.filePopupMenu = new JPopupMenu();
        this.filePopupMenu.setOpaque(false);
        this.filePopupMenu.setDoubleBuffered(true);
        this.filePopupMenu.setFocusable(false);
        JMenu viewMenu = new JMenu("View");
        JMenuItem viewDetailsMenuItem = new JMenuItem(UIManager.getString("FileChooser.fileDetailsText"));
        viewDetailsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                A03AdvancedFileChooserUI.this.getFileScrollPane().setViewportView(A03AdvancedFileChooserUI.this.getFileTable());
            }
        });
        viewMenu.add(viewDetailsMenuItem);
        JMenuItem viewListMenuItem = new JMenuItem(UIManager.getString("FileChooser.fileListText"));
        viewListMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                A03AdvancedFileChooserUI.this.getFileScrollPane().setViewportView(A03AdvancedFileChooserUI.this.getFileList());
            }
        });
        viewMenu.add(viewListMenuItem);
        this.filePopupMenu.add(viewMenu);
        JMenuItem homeItem = new JMenuItem();
        homeItem.setAction(this.getGoHomeAction());
        this.filePopupMenu.add(homeItem);
        this.filePopupMenu.addSeparator();
        this.newFolderItem = new JMenuItem("New Folder");
        this.newFolderItem.setAction(this.getNewFolderAction());
        this.filePopupMenu.add(this.newFolderItem);
        this.deleteItem = new JMenuItem("Delete");
        this.deleteItem.addActionListener(EventHandler.create(ActionListener.class, this, "doDelete"));
        this.filePopupMenu.add(this.deleteItem);
        this.renameItem = new JMenuItem("Rename");
        this.renameItem.addActionListener(EventHandler.create(ActionListener.class, this, "doRename"));
        this.filePopupMenu.add(this.renameItem);
    }

    public void doRename() {
        File newFile;
        File file = this.getSelectedFiles(this.filePopupMenu.getInvoker())[0];
        String newName = JOptionPane.showInputDialog(this.getFileChooser(), "To", file.getName());
        if (newName != null && file.renameTo(newFile = new File(file.getParentFile(), newName))) {
            this.getFileChooser().setCurrentDirectory(newFile.getParentFile());
            this.rescanCurrentDirectory(this.getFileChooser());
        }
    }

    public static boolean delete(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                boolean answer;
                File file = fileArray[n2];
                if (file.isDirectory() ? !(answer = A03AdvancedFileChooserUI.delete(file)) : !file.delete()) {
                    return false;
                }
                ++n2;
            }
        }
        return directory.delete();
    }

    public void doDelete() {
        if (JOptionPane.showConfirmDialog(this.getFileChooser(), "Are you sure ?", "Confirm", 0) == 0) {
            Component source = this.filePopupMenu.getInvoker();
            File[] files = this.getSelectedFiles(source);
            if (source == this.getFileList()) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    A03AdvancedFileChooserUI.delete(file);
                    if (file.isDirectory()) {
                        DirectoryTreeNode node = this.getDirectoryTreeNode(file);
                        node.removeFromParent();
                    }
                    ++n2;
                }
                this.rescanCurrentDirectory(this.getFileChooser());
            } else if (source == this.getFileTable()) {
                File[] fileArray = files;
                int n = files.length;
                int n3 = 0;
                while (n3 < n) {
                    File file = fileArray[n3];
                    A03AdvancedFileChooserUI.delete(file);
                    if (file.isDirectory()) {
                        DirectoryTreeNode node = this.getDirectoryTreeNode(file);
                        node.removeFromParent();
                    }
                    ++n3;
                }
                this.rescanCurrentDirectory(this.getFileChooser());
            } else {
                A03AdvancedFileChooserUI.delete(this.currentNode.getFile());
                DirectoryTreeNode parent = (DirectoryTreeNode)this.currentNode.getParent();
                this.currentNode.removeFromParent();
                this.currentNode = parent;
                this.rescanCurrentDirectory(this.getFileChooser());
                this.getFileChooser().setCurrentDirectory(this.currentNode.getFile());
            }
        }
    }

    public void installComponents(JFileChooser fc) {
        fc.setBorder(new EmptyBorder(3, 3, 3, 3));
        fc.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(1);
        splitPane.setLeftComponent(new JScrollPane(this.getDirectoryTree()));
        splitPane.setDividerLocation(300);
        splitPane.setRightComponent(this.getFileScrollPane());
        splitPane.setPreferredSize(new Dimension(800, 300));
        fc.add((Component)splitPane, "Center");
        this.accessoryContainer = new JPanel();
        this.accessoryContainer.setLayout(new BorderLayout());
        fc.add((Component)this.accessoryContainer, "East");
        JPanel southPanel = this.buildSouthPanel();
        fc.add((Component)southPanel, "South");
        JPanel northPanel = this.buildNorthPanel();
        fc.add((Component)northPanel, "North");
        this.buildDetailsPopupMenu();
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
    }

    private Icon getSystemIcon(File f) {
        try {
            FileSystemView fsv = this.getFileChooser().getFileSystemView();
            ShellFolder sf = ShellFolder.getShellFolder(f);
            String folderType = sf.getFolderType();
            Icon icon = systemIcons.get(folderType);
            if (icon == null && (icon = fsv.getSystemIcon(f)) != null) {
                systemIcons.put(folderType, icon);
            }
            return icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        this.getFileList().ensureIndexIsVisible(this.getFileList().getSelectedIndex());
        JTable table = this.getFileTable();
        int index = table.getSelectedRow();
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(index, 0, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                A03AdvancedFileChooserUI.this.currentNode.rescan();
                A03AdvancedFileChooserUI.this.getDirectoryTreeModel().reload();
                TreePath path = new TreePath(A03AdvancedFileChooserUI.this.currentNode.getPath());
                A03AdvancedFileChooserUI.this.getDirectoryTree().expandPath(path);
                A03AdvancedFileChooserUI.this.getDirectoryTree().setSelectionPath(path);
                A03AdvancedFileChooserUI.this.updateDetails();
            }
        });
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListenerImpl();
    }

    private DefaultTreeModel getDirectoryTreeModel() {
        if (this.directoryTreeModel == null) {
            this.currentNode = new DirectoryTreeNode(this.getFileChooser().getFileSystemView().getRoots()[0]);
            this.directoryTreeModel = new DefaultTreeModel(this.currentNode);
        }
        return this.directoryTreeModel;
    }

    private JTree getDirectoryTree() {
        if (this.directoryTree == null) {
            this.directoryTree = new JTree(this.getDirectoryTreeModel());
            new DnDTreeHandler(this.directoryTree);
            this.directoryTree.addTreeWillExpandListener(new DirectoryTreeWillExpandListener());
            this.directoryTree.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    A03AdvancedFileChooserUI.this.processMouseEvent(A03AdvancedFileChooserUI.this.directoryTree, e);
                }
            });
            this.directoryTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
                    if (newLeadSelectionPath != null) {
                        A03AdvancedFileChooserUI.this.currentNode = (DirectoryTreeNode)newLeadSelectionPath.getLastPathComponent();
                        if (A03AdvancedFileChooserUI.this.currentNode != null) {
                            A03AdvancedFileChooserUI.this.directoryTreeSelectionIsAdjusting = true;
                            A03AdvancedFileChooserUI.this.getFileChooser().setCurrentDirectory(A03AdvancedFileChooserUI.this.currentNode.getFile());
                            A03AdvancedFileChooserUI.this.directoryTreeSelectionIsAdjusting = false;
                        }
                    }
                }
            });
            this.directoryTree.setCellRenderer(new DirectoryNodeRenderer());
            this.directoryTree.getSelectionModel().setSelectionMode(1);
            this.directoryTree.setShowsRootHandles(false);
        }
        return this.directoryTree;
    }

    private DirectoryTreeNode getDirectoryTreeNode(File target) {
        DirectoryTreeNode node = (DirectoryTreeNode)this.getDirectoryTree().getModel().getRoot();
        FileSystemView fsw = this.getFileChooser().getFileSystemView();
        if (fsw.getParentDirectory(target) == null) {
            return node;
        }
        ArrayList<File> children = new ArrayList<File>();
        File file = target;
        do {
            children.add(file);
        } while (fsw.getParentDirectory(file = fsw.getParentDirectory(file)) != null);
        int i = children.size();
        block1: while (--i >= 0) {
            file = (File)children.get(i);
            Enumeration<TreeNode> e = node.children();
            if (!node.isLeaf() && !e.hasMoreElements()) {
                node.rescan();
                e = node.children();
            }
            while (e.hasMoreElements()) {
                DirectoryTreeNode child = (DirectoryTreeNode)e.nextElement();
                File childFile = child.getFile();
                if (!childFile.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                node = child;
                continue block1;
            }
        }
        return node;
    }

    public ListSelectionListener getListSelectionListener() {
        if (this.listSelectionListener == null) {
            this.listSelectionListener = new ListSelectionListenerImpl();
        }
        return this.listSelectionListener;
    }

    public FileListModel getFileListModel() {
        if (this.fileListModel == null) {
            this.fileListModel = new FileListModel();
        }
        return this.fileListModel;
    }

    private JList getFileList() {
        if (this.fileList == null) {
            this.fileList = new JList(this.getFileListModel());
            this.fileList.setCellRenderer(new FileListCellRenderer());
            this.fileList.setLayoutOrientation(1);
            this.fileList.setVisibleRowCount(-1);
            this.fileList.setFixedCellHeight(19);
            this.fileList.getSelectionModel().addListSelectionListener(this.getListSelectionListener());
            this.fileList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    A03AdvancedFileChooserUI.this.processMouseEvent(A03AdvancedFileChooserUI.this.fileList, e);
                }
            });
            new DnDListHandler(this.fileList);
        }
        return this.fileList;
    }

    public FileTableModel getFileTableModel() {
        if (this.fileTableModel == null) {
            this.fileTableModel = new FileTableModel();
        }
        return this.fileTableModel;
    }

    private static NavigationHistoryComboBoxModel getNavigationHistoryComboBoxModel() {
        if (navigationHistoryListModel == null) {
            navigationHistoryListModel = new NavigationHistoryComboBoxModel();
        }
        return navigationHistoryListModel;
    }

    private JComboBox getNavigationHistoryComboBox() {
        if (this.navigationHistoryList == null) {
            this.navigationHistoryList = new JComboBox(A03AdvancedFileChooserUI.getNavigationHistoryComboBoxModel());
            this.navigationHistoryList.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    int selectedIndex;
                    if (e.getStateChange() == 1 && (selectedIndex = A03AdvancedFileChooserUI.this.navigationHistoryList.getSelectedIndex()) != -1) {
                        File dir = (File)A03AdvancedFileChooserUI.getNavigationHistoryComboBoxModel().getElementAt(selectedIndex);
                        A03AdvancedFileChooserUI.this.getFileChooser().setCurrentDirectory(dir);
                    }
                }
            });
        }
        return this.navigationHistoryList;
    }

    public JTable getFileTable() {
        if (this.fileTable == null) {
            this.fileTable = A03Constants.IS_JAVA_5 ? new JTable(){
                private static final long serialVersionUID = 5752322695969028953L;

                public boolean getScrollableTracksViewportHeight() {
                    return this.getParent() instanceof JViewport && this.getPreferredSize().height < this.getParent().getHeight();
                }
            } : new JTable();
            new DnDTableHandler(this.fileTable);
            this.sorter = new TableSorter(this.getFileTableModel());
            this.fileTable.setModel(this.sorter);
            this.fileTable.getSelectionModel().addListSelectionListener(this.getListSelectionListener());
            this.fileTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    A03AdvancedFileChooserUI.this.processMouseEvent(A03AdvancedFileChooserUI.this.fileTable, e);
                }
            });
            this.fileTable.setShowHorizontalLines(false);
            this.fileTable.setShowVerticalLines(false);
            this.fileTable.setAutoResizeMode(2);
            this.fileTable.setRowHeight(19);
            FileTableCellRenderer renderer = new FileTableCellRenderer();
            SortTableCellRenderer headerRenderer = new SortTableCellRenderer(this.fileTable);
            this.fileTable.getTableHeader().setReorderingAllowed(false);
            TableColumnModel tcm = this.fileTable.getColumnModel();
            TableColumn tc = tcm.getColumn(0);
            tc.setHeaderRenderer(headerRenderer);
            tc.setCellRenderer(renderer);
            tc.setPreferredWidth(240);
            tc = tcm.getColumn(1);
            tc.setHeaderRenderer(headerRenderer);
            tc.setCellRenderer(renderer);
            tc.setPreferredWidth(120);
            tc = tcm.getColumn(2);
            tc.setHeaderRenderer(headerRenderer);
            tc.setPreferredWidth(140);
            tc = tcm.getColumn(3);
            tc.setHeaderRenderer(headerRenderer);
            tc.setCellRenderer(renderer);
            tc.setPreferredWidth(120);
        }
        return this.fileTable;
    }

    private File[] getSelectedFiles(Object source) {
        File[] files = null;
        if (source == this.getFileList()) {
            int[] indices = this.getFileList().getSelectedIndices();
            files = new File[indices.length];
            int i = 0;
            while (i < indices.length) {
                files[i] = (File)this.getFileListModel().getElementAt(indices[i]);
                ++i;
            }
        } else if (source == this.getFileTable()) {
            int[] rows = this.getFileTable().getSelectedRows();
            files = new File[rows.length];
            int i = 0;
            while (i < rows.length) {
                files[i] = this.getFileTableModel().getFileAt(this.sorter.getIndexAt(rows[i]));
                ++i;
            }
        } else if (source == this.getDirectoryTree()) {
            files = new File[]{this.currentNode.getFile()};
        }
        return files;
    }

    private void processMouseEvent(Component target, MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            if (target == this.getFileList()) {
                boolean enabled;
                int[] indices = this.getFileList().getSelectedIndices();
                if (indices.length == 1 && indices[0] == this.getFileList().locationToIndex(e.getPoint())) {
                    File file = (File)this.getFileList().getSelectedValue();
                    enabled = this.isFileModifiable(file);
                } else {
                    enabled = false;
                }
                this.deleteItem.setEnabled(enabled);
                this.renameItem.setEnabled(enabled);
                this.filePopupMenu.show(target, e.getX(), e.getY());
            } else if (target == this.getFileTable()) {
                boolean enabled;
                int[] rows = this.getFileTable().getSelectedRows();
                if (rows.length == 1) {
                    File file = this.getFileTableModel().getFileAt(this.sorter.getIndexAt(rows[0]));
                    enabled = this.isFileModifiable(file);
                } else {
                    enabled = false;
                }
                this.deleteItem.setEnabled(enabled);
                this.renameItem.setEnabled(enabled);
                this.filePopupMenu.show(target, e.getX(), e.getY());
            } else {
                boolean enabled;
                int row = this.getDirectoryTree().getRowForLocation(e.getX(), e.getY());
                if (this.getDirectoryTree().isRowSelected(row)) {
                    TreePath treePath = this.getDirectoryTree().getPathForRow(row);
                    DirectoryTreeNode node = (DirectoryTreeNode)treePath.getLastPathComponent();
                    File file = node.getFile();
                    enabled = this.isFileModifiable(file);
                } else {
                    enabled = false;
                }
                this.deleteItem.setEnabled(enabled);
                this.renameItem.setEnabled(enabled);
                this.filePopupMenu.show(target, e.getX(), e.getY());
            }
        } else if (e.getClickCount() == 2) {
            File file = this.getSelectedFiles(target)[0];
            if (file.getName().equals("..")) {
                this.getChangeToParentDirectoryAction().actionPerformed(null);
            } else if (file.isDirectory()) {
                this.getFileChooser().setCursor(A03Constants.WAIT_CURSOR_INSTANCE);
                this.getFileChooser().setCurrentDirectory(file);
                this.getFileChooser().setCursor(A03Constants.DEFAULT_CURSOR_INSTANCE);
            }
        }
    }

    private boolean isFileModifiable(File file) {
        return !this.getFileChooser().getFileSystemView().isFileSystemRoot(file) && !this.getFileChooser().getFileSystemView().isRoot(file) && !this.getFileChooser().getFileSystemView().isDrive(file);
    }

    private JScrollPane getFileScrollPane() {
        if (this.fileScrollPane == null) {
            this.fileScrollPane = new JScrollPane(this.getFileTable());
            this.fileScrollPane.setVerticalScrollBarPolicy(22);
        }
        return this.fileScrollPane;
    }

    private void updateDetails() {
        this.getFileListModel().setCurrentNode(this.currentNode);
        this.getFileTableModel().setCurrentNode(this.currentNode);
    }

    public void setFileName(String filename) {
        this.fileTextField.setText(filename);
    }

    public String getFileName() {
        return this.fileTextField.getText();
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser fc) {
        return UIManager.getBoolean("FileChooser.useWildcardsFileFilter") ? this.wildcardsFileFilter : super.getAcceptAllFileFilter(fc);
    }

    class DirectoryNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -5338193231571179409L;

        public DirectoryNodeRenderer() {
            this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            DirectoryTreeNode node = (DirectoryTreeNode)value;
            this.setText(A03AdvancedFileChooserUI.this.getFileChooser().getName(node.getFile()));
            this.setIcon(A03AdvancedFileChooserUI.this.getSystemIcon(node.getFile()));
            return this;
        }
    }

    class DirectoryTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -1254389343396857828L;
        private File file;
        private File[] files;

        public DirectoryTreeNode(File file) {
            super(file);
            this.files = null;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isLeaf() {
            return !this.file.isDirectory();
        }

        public File[] getFiles() {
            if (this.files == null) {
                this.rescan();
            }
            return this.files;
        }

        public void rescan() {
            try {
                this.files = A03AdvancedFileChooserUI.this.getFileChooser().getFileSystemView().getFiles(this.file, A03AdvancedFileChooserUI.this.getFileChooser().isFileHidingEnabled());
                this.removeAllChildren();
                File[] fileArray = this.files;
                int n = this.files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        this.add(new DirectoryTreeNode(file));
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class DirectoryTreeWillExpandListener
    implements TreeWillExpandListener {
        DirectoryTreeWillExpandListener() {
        }

        public void treeWillExpand(TreeExpansionEvent e) {
            A03AdvancedFileChooserUI.this.getFileChooser().setCursor(A03Constants.WAIT_CURSOR_INSTANCE);
            TreePath path = e.getPath();
            DirectoryTreeNode node = (DirectoryTreeNode)path.getLastPathComponent();
            try {
                try {
                    if (!node.isLeaf() && !node.children().hasMoreElements()) {
                        node.rescan();
                    }
                    A03AdvancedFileChooserUI.this.currentNode = node;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    A03AdvancedFileChooserUI.this.getFileChooser().setCursor(A03Constants.DEFAULT_CURSOR_INSTANCE);
                }
            }
            finally {
                A03AdvancedFileChooserUI.this.getFileChooser().setCursor(A03Constants.DEFAULT_CURSOR_INSTANCE);
            }
        }

        public void treeWillCollapse(TreeExpansionEvent e) {
        }
    }

    class DnDListHandler
    extends DragSourceAdapter
    implements DragGestureListener,
    DropTargetListener {
        private DragSource dragSource;
        private JList list;

        public DnDListHandler(JList list) {
            this.list = list;
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(list, 2, this);
            new DropTarget(list, this);
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            StringBuilder sb = new StringBuilder();
            int[] indices = this.list.getSelectedIndices();
            if (indices.length > 0) {
                int[] nArray = indices;
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    File file = A03AdvancedFileChooserUI.this.getFileTableModel().getFileAt(index);
                    sb.append(file.getAbsolutePath());
                    sb.append(File.pathSeparatorChar);
                    ++n2;
                }
                StringSelection ss = new StringSelection(sb.toString());
                this.dragSource.startDrag(dge, DragSource.DefaultCopyDrop, ss, this);
            }
        }

        public void dragEnter(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dte) {
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void drop(DropTargetDropEvent dtde) {
            Transferable t;
            Point mousePoint = dtde.getLocation();
            if (mousePoint != null && (t = dtde.getTransferable()).isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrop(2);
                try {
                    String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                    String[] paths = str.split(File.pathSeparator);
                    int index = A03SwingUtilities.loc2IndexFileList(this.list, mousePoint);
                    File destFile = (File)A03AdvancedFileChooserUI.this.getFileListModel().getElementAt(index);
                    if (destFile.isDirectory()) {
                        String[] stringArray = paths;
                        int n = paths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String newPath;
                            String path = stringArray[n2];
                            File file = A03AdvancedFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(path);
                            boolean success = file.renameTo(new File(newPath = String.valueOf(destFile.getAbsolutePath()) + File.separatorChar + file.getName()));
                            if (!success) {
                                JOptionPane.showMessageDialog(A03AdvancedFileChooserUI.this.getFileChooser(), "Error", "Cannot move '" + path + "' file", 0);
                                break;
                            }
                            ++n2;
                        }
                        dtde.getDropTargetContext().dropComplete(true);
                        A03AdvancedFileChooserUI.this.getFileChooser().setCurrentDirectory(destFile);
                    } else {
                        dtde.getDropTargetContext().dropComplete(false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dtde.getDropTargetContext().dropComplete(false);
                }
            }
        }
    }

    class DnDTableHandler
    extends DragSourceAdapter
    implements DragGestureListener,
    DropTargetListener {
        private DragSource dragSource;
        private JTable table;

        public DnDTableHandler(JTable table) {
            this.table = table;
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(table, 2, this);
            new DropTarget(table, this);
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            StringBuilder sb = new StringBuilder();
            int[] rows = this.table.getSelectedRows();
            if (rows.length > 0) {
                int[] nArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = nArray[n2];
                    File file = A03AdvancedFileChooserUI.this.getFileTableModel().getFileAt(A03AdvancedFileChooserUI.this.sorter.getIndexAt(row));
                    sb.append(file.getAbsolutePath());
                    sb.append(File.pathSeparatorChar);
                    ++n2;
                }
                StringSelection ss = new StringSelection(sb.toString());
                this.dragSource.startDrag(dge, DragSource.DefaultCopyDrop, ss, this);
            }
        }

        public void dragEnter(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dte) {
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void drop(DropTargetDropEvent dtde) {
            Transferable t;
            Point mousePoint = dtde.getLocation();
            if (mousePoint != null && (t = dtde.getTransferable()).isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrop(2);
                try {
                    String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                    String[] paths = str.split(File.pathSeparator);
                    int row = this.table.rowAtPoint(mousePoint);
                    File destFile = A03AdvancedFileChooserUI.this.getFileTableModel().getFileAt(A03AdvancedFileChooserUI.this.sorter.getIndexAt(row));
                    if (destFile.isDirectory()) {
                        String[] stringArray = paths;
                        int n = paths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String newPath;
                            String path = stringArray[n2];
                            File file = A03AdvancedFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(path);
                            boolean success = file.renameTo(new File(newPath = String.valueOf(destFile.getAbsolutePath()) + File.separatorChar + file.getName()));
                            if (!success) {
                                JOptionPane.showMessageDialog(A03AdvancedFileChooserUI.this.getFileChooser(), "Error", "Cannot move '" + path + "' file", 0);
                                break;
                            }
                            ++n2;
                        }
                        dtde.getDropTargetContext().dropComplete(true);
                        A03AdvancedFileChooserUI.this.getFileChooser().setCurrentDirectory(destFile);
                    } else {
                        dtde.getDropTargetContext().dropComplete(false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dtde.getDropTargetContext().dropComplete(false);
                }
            }
        }
    }

    class DnDTreeHandler
    extends DropTarget {
        private static final long serialVersionUID = 5701314883967362981L;
        private JTree tree;

        public DnDTreeHandler(JTree tree) {
            this.tree = tree;
            new DropTarget(tree, this);
        }

        public void drop(DropTargetDropEvent dtde) {
            Point mousePoint = dtde.getLocation();
            if (mousePoint != null) {
                TreePath selPath = this.tree.getPathForLocation(mousePoint.x, mousePoint.y);
                if (selPath == null) {
                    return;
                }
                DirectoryTreeNode node = (DirectoryTreeNode)selPath.getLastPathComponent();
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dtde.acceptDrop(2);
                    try {
                        String[] paths;
                        String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                        String[] stringArray = paths = str.split(File.pathSeparator);
                        int n = paths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String newPath;
                            String path = stringArray[n2];
                            File file = A03AdvancedFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(path);
                            boolean success = file.renameTo(new File(newPath = String.valueOf(node.getFile().getAbsolutePath()) + File.separatorChar + file.getName()));
                            if (!success) {
                                JOptionPane.showMessageDialog(A03AdvancedFileChooserUI.this.getFileChooser(), "Error", "Cannot move '" + path + "' file", 0);
                                break;
                            }
                            ++n2;
                        }
                        dtde.getDropTargetContext().dropComplete(true);
                        A03AdvancedFileChooserUI.this.getFileChooser().setCurrentDirectory(node.getFile());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        dtde.getDropTargetContext().dropComplete(false);
                    }
                }
            }
        }
    }

    class EditableComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = -4397009979125052224L;

        EditableComboBoxModel() {
        }

        public void setList(List list) {
            this.removeAllElements();
            for (Object item : list) {
                this.addElement(item);
            }
        }

        public void addIfNecessary(Object item) {
            if (this.getIndexOf(item) == -1) {
                this.addElement(item);
            }
        }

        public void remove(Object item) {
            this.removeElement(item);
        }
    }

    class FileListCellRenderer
    extends A03ListCellRenderer {
        private static final long serialVersionUID = 6645127403610636307L;

        FileListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            this.setText(A03AdvancedFileChooserUI.this.getFileChooser().getName(file));
            this.setIcon(A03AdvancedFileChooserUI.this.getSystemIcon(file));
            return this;
        }
    }

    class FileListModel
    extends AbstractListModel
    implements DocumentListener {
        private static final long serialVersionUID = -6666398054236938755L;
        List<File> list = new ArrayList<File>();
        List<File> filteredList = new ArrayList<File>();
        FileFilter currentFilter;

        public void setFilter(FileFilter filter) {
            this.filteredList.clear();
            this.currentFilter = filter;
            for (File file : this.list) {
                if (this.currentFilter != null && !this.currentFilter.accept(file)) continue;
                this.filteredList.add(file);
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void setCurrentNode(DirectoryTreeNode currentNode) {
            File[] files;
            this.list.clear();
            this.filteredList.clear();
            if (!currentNode.isRoot()) {
                this.addElement(new File(".."));
            }
            if ((files = currentNode.getFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (A03AdvancedFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled()) {
                        if (file.isDirectory()) {
                            this.addElement(file);
                        }
                    } else {
                        this.addElement(file);
                    }
                    ++n2;
                }
            }
        }

        public void addElement(File element) {
            this.list.add(element);
            if (this.currentFilter != null && this.currentFilter.accept(element)) {
                this.filteredList.add(element);
            }
            this.fireContentsChanged(this, 0, this.filteredList.size() - 1);
        }

        public int getSize() {
            return this.filteredList.size();
        }

        public Object getElementAt(int index) {
            File returnValue = index < this.filteredList.size() ? this.filteredList.get(index) : null;
            return returnValue;
        }

        public void insertUpdate(DocumentEvent event) {
            Document doc = event.getDocument();
            this.updateFilter(doc);
        }

        public void removeUpdate(DocumentEvent event) {
            Document doc = event.getDocument();
            this.updateFilter(doc);
        }

        private void updateFilter(Document doc) {
            Object selectedItem = A03AdvancedFileChooserUI.this.filterComboBox.getSelectedItem();
            if (selectedItem instanceof String || selectedItem instanceof WildcardsFileFilter) {
                try {
                    String pattern = doc.getText(0, doc.getLength());
                    A03AdvancedFileChooserUI.this.wildcardsFileFilter.setPattern(pattern);
                    this.setFilter(A03AdvancedFileChooserUI.this.wildcardsFileFilter);
                }
                catch (BadLocationException ble) {
                    System.err.println("Bad location: " + ble);
                }
            }
        }

        public void changedUpdate(DocumentEvent event) {
        }

        public void selectIfPossible(File file) {
            int i = 0;
            while (i < this.filteredList.size()) {
                File filteredFile = this.filteredList.get(i);
                if (filteredFile.getAbsolutePath().equals(file.getAbsolutePath())) {
                    A03AdvancedFileChooserUI.this.getFileList().getSelectionModel().setSelectionInterval(i, i);
                    break;
                }
                ++i;
            }
        }
    }

    class FileTableCellRenderer
    extends A03TableCellRenderer {
        private static final long serialVersionUID = -2898644540191122620L;

        FileTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int index = A03AdvancedFileChooserUI.this.sorter.getIndexAt(row);
            File file = A03AdvancedFileChooserUI.this.getFileTableModel().getFileAt(index);
            Color foreground = table.getForeground();
            switch (column) {
                case 0: {
                    if (file.isDirectory()) {
                        this.setForeground(UIManager.getColor("FileChooser.directoryFileTextColor"));
                    } else if (file.isHidden()) {
                        this.setForeground(UIManager.getColor("FileChooser.hiddenFileTextColor"));
                    } else if (!file.canWrite()) {
                        this.setForeground(UIManager.getColor("FileChooser.readOnlyFileTextColor"));
                    }
                    this.setText(A03AdvancedFileChooserUI.this.getFileChooser().getName(file));
                    this.setIcon(A03AdvancedFileChooserUI.this.getSystemIcon(file));
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 1: {
                    this.setForeground(foreground);
                    this.setIcon(null);
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 3: {
                    Date date = (Date)value;
                    String text = date != null ? simpleDateTimeFormat.format(date) : "";
                    this.setText(text);
                    this.setIcon(null);
                    this.setHorizontalAlignment(0);
                    break;
                }
                default: {
                    this.setIcon(null);
                    this.setHorizontalAlignment(2);
                }
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileTableModel
    extends AbstractTableModel
    implements DocumentListener {
        private static final long serialVersionUID = -5842775978156316657L;
        String[] columnNames;
        List<File> list;
        List<File> filteredList;
        FileFilter currentFilter;

        public FileTableModel() {
            this.columnNames = new String[]{UIManager.getString((Object)"FileChooser.fileNameHeaderText", A03AdvancedFileChooserUI.this.locale), UIManager.getString((Object)"FileChooser.fileSizeHeaderText", A03AdvancedFileChooserUI.this.locale), UIManager.getString((Object)"FileChooser.fileTypeHeaderText", A03AdvancedFileChooserUI.this.locale), UIManager.getString((Object)"FileChooser.fileDateHeaderText", A03AdvancedFileChooserUI.this.locale)};
            this.list = new ArrayList<File>();
            this.filteredList = new ArrayList<File>();
        }

        public void setFilter(FileFilter filter) {
            this.currentFilter = filter;
            this.filteredList.clear();
            for (File file : this.list) {
                if (this.currentFilter != null && !this.currentFilter.accept(file)) continue;
                this.filteredList.add(file);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int row, int col) {
            File file = this.filteredList.get(row);
            switch (col) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    String size = file.isDirectory() ? "" : Long.toString(file.length());
                    return size;
                }
                case 2: {
                    return A03AdvancedFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(file);
                }
                case 3: {
                    return new Date(file.lastModified());
                }
            }
            return null;
        }

        public void setCurrentNode(DirectoryTreeNode currentNode) {
            File[] files;
            this.list.clear();
            this.filteredList.clear();
            if (!currentNode.isRoot()) {
                this.addElement(new File(".."));
            }
            if ((files = currentNode.getFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (A03AdvancedFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled()) {
                        if (file.isDirectory()) {
                            this.addElement(file);
                        }
                    } else {
                        this.addElement(file);
                    }
                    ++n2;
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.filteredList.size();
        }

        public void addElement(File element) {
            this.list.add(element);
            if (this.currentFilter == null || this.currentFilter.accept(element)) {
                this.filteredList.add(element);
            }
        }

        public File getFileAt(int index) {
            return this.filteredList.get(index);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            Document doc = event.getDocument();
            this.updateFilter(doc);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            Document doc = event.getDocument();
            this.updateFilter(doc);
        }

        private void updateFilter(Document doc) {
            Object selectedItem = A03AdvancedFileChooserUI.this.filterComboBox.getSelectedItem();
            if (selectedItem instanceof String || selectedItem instanceof WildcardsFileFilter) {
                try {
                    String pattern = doc.getText(0, doc.getLength());
                    A03AdvancedFileChooserUI.this.wildcardsFileFilter.setPattern(pattern);
                    this.setFilter(A03AdvancedFileChooserUI.this.wildcardsFileFilter);
                }
                catch (BadLocationException ble) {
                    System.err.println("Bad location: " + ble);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 3: {
                    return Date.class;
                }
            }
            return String.class;
        }

        public void selectIfPossible(File file) {
            int i = 0;
            while (i < this.filteredList.size()) {
                File filteredFile = this.filteredList.get(A03AdvancedFileChooserUI.this.sorter.getIndexAt(i));
                if (filteredFile.getAbsolutePath().equals(file.getAbsolutePath())) {
                    JTable table = A03AdvancedFileChooserUI.this.getFileTable();
                    table.getSelectionModel().setSelectionInterval(i, i);
                    break;
                }
                ++i;
            }
        }
    }

    class FilterCellRenderer
    extends A03ListCellRenderer {
        private static final long serialVersionUID = -1565894849528339182L;

        FilterCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                FileFilter filter = (FileFilter)value;
                this.setText(filter.getDescription());
            }
            return this;
        }
    }

    class ListSelectionListenerImpl
    implements ListSelectionListener {
        ListSelectionListenerImpl() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && !A03AdvancedFileChooserUI.this.fileSelectionsIsAdjusting) {
                DefaultListSelectionModel source = (DefaultListSelectionModel)e.getSource();
                JComponent target = null;
                target = A03AdvancedFileChooserUI.this.getFileList().getSelectionModel().equals(source) ? A03AdvancedFileChooserUI.this.getFileList() : A03AdvancedFileChooserUI.this.getFileTable();
                File[] selectedFiles = A03AdvancedFileChooserUI.this.getSelectedFiles(target);
                if (selectedFiles.length > 0) {
                    ArrayList<File> files = new ArrayList<File>();
                    File[] fileArray = selectedFiles;
                    int n = selectedFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File selectedFile = fileArray[n2];
                        if (A03AdvancedFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled() && selectedFile.isDirectory() || !A03AdvancedFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled() && !selectedFile.isDirectory()) {
                            files.add(selectedFile);
                            String newPath = selectedFile.getAbsolutePath();
                            A03AdvancedFileChooserUI.this.historyComboBoxModel.addIfNecessary(newPath);
                        }
                        ++n2;
                    }
                    if (files.isEmpty()) {
                        if (A03AdvancedFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                            A03AdvancedFileChooserUI.this.getFileChooser().setSelectedFiles(new File[0]);
                        } else {
                            A03AdvancedFileChooserUI.this.getFileChooser().setSelectedFile(null);
                        }
                    } else if (files.size() == 1) {
                        if (A03AdvancedFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                            A03AdvancedFileChooserUI.this.getFileChooser().setSelectedFiles(files.toArray(new File[1]));
                        } else {
                            A03AdvancedFileChooserUI.this.getFileChooser().setSelectedFile((File)files.get(0));
                        }
                    } else if (files.size() > 1) {
                        A03AdvancedFileChooserUI.this.getFileChooser().setSelectedFiles(files.toArray(new File[files.size()]));
                    }
                } else if (!A03AdvancedFileChooserUI.this.filePathSelectionIsAdjusting) {
                    A03AdvancedFileChooserUI.this.getFileChooser().setSelectedFile(null);
                }
                A03AdvancedFileChooserUI.this.approveButton.setEnabled(!A03AdvancedFileChooserUI.this.fileTextField.getText().equals(""));
            }
        }
    }

    class NavigationHistoryCellRenderer
    extends A03ListCellRenderer {
        private static final long serialVersionUID = -1565894849528339182L;

        NavigationHistoryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            this.setText(file.getAbsolutePath());
            return this;
        }
    }

    static class NavigationHistoryComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 5897879783481281983L;

        public void addIfNecessary(Object item) {
            if (item != null && this.getIndexOf(item) == -1) {
                this.addElement(item);
                this.fireContentsChanged(this, 0, this.getSize() - 1);
                this.setSelectedItem(item);
            }
        }
    }

    class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        PropertyChangeListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("directoryChanged")) {
                File currentDirectory = (File)e.getNewValue();
                A03AdvancedFileChooserUI.this.currentNode = A03AdvancedFileChooserUI.this.getDirectoryTreeNode(currentDirectory);
                TreePath path = new TreePath(A03AdvancedFileChooserUI.this.currentNode.getPath());
                A03AdvancedFileChooserUI.this.getDirectoryTree().expandPath(path);
                if (!A03AdvancedFileChooserUI.this.directoryTreeSelectionIsAdjusting) {
                    A03AdvancedFileChooserUI.this.getDirectoryTree().setSelectionPath(path);
                }
                A03AdvancedFileChooserUI.this.updateDetails();
            } else if (name.equals("AccessoryChangedProperty")) {
                A03AdvancedFileChooserUI.this.accessoryContainer.removeAll();
                JComponent accessory = (JComponent)e.getNewValue();
                A03AdvancedFileChooserUI.this.accessoryContainer.add((Component)accessory, "Center");
            } else if (name.equals("SelectedFileChangedProperty")) {
                A03AdvancedFileChooserUI.this.fileSelectionsIsAdjusting = true;
                File file = (File)e.getNewValue();
                if (file != null) {
                    File parentFile = file.getParentFile();
                    A03AdvancedFileChooserUI.getNavigationHistoryComboBoxModel().addIfNecessary(parentFile);
                    A03AdvancedFileChooserUI.this.getFileTableModel().selectIfPossible(file);
                    A03AdvancedFileChooserUI.this.getFileListModel().selectIfPossible(file);
                }
                String filename = file != null ? file.getAbsolutePath() : null;
                A03AdvancedFileChooserUI.this.setFileName(filename);
                A03AdvancedFileChooserUI.this.fileSelectionsIsAdjusting = false;
            } else if (name.equals("SelectedFilesChangedProperty")) {
                A03AdvancedFileChooserUI.this.fileSelectionsIsAdjusting = true;
                StringBuffer sb = new StringBuffer();
                File[] files = (File[])e.getNewValue();
                if (files.length > 0) {
                    A03AdvancedFileChooserUI.getNavigationHistoryComboBoxModel().addIfNecessary(files[0].getParentFile());
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (sb.length() > 0) {
                            sb.append(File.pathSeparatorChar);
                        }
                        sb.append(file.getAbsolutePath());
                        A03AdvancedFileChooserUI.this.getFileTableModel().selectIfPossible(file);
                        A03AdvancedFileChooserUI.this.getFileListModel().selectIfPossible(file);
                        ++n2;
                    }
                }
                A03AdvancedFileChooserUI.this.setFileName(sb.toString());
                A03AdvancedFileChooserUI.this.fileSelectionsIsAdjusting = false;
            } else if (name.equals("acceptAllFileFilterUsedChanged")) {
                boolean acceptAllFileFilterUsed = (Boolean)e.getNewValue();
                if (acceptAllFileFilterUsed) {
                    A03AdvancedFileChooserUI.this.filterComboBoxModel.addIfNecessary(A03AdvancedFileChooserUI.this.getAcceptAllFileFilter(A03AdvancedFileChooserUI.this.getFileChooser()));
                } else {
                    A03AdvancedFileChooserUI.this.filterComboBoxModel.remove(A03AdvancedFileChooserUI.this.getAcceptAllFileFilter(A03AdvancedFileChooserUI.this.getFileChooser()));
                }
                SwingUtilities.updateComponentTreeUI(A03AdvancedFileChooserUI.this.filterComboBox.getParent());
            } else if (name.equals("fileFilterChanged")) {
                FileFilter filter = (FileFilter)e.getNewValue();
                A03AdvancedFileChooserUI.this.filterComboBoxModel.addIfNecessary(filter);
                A03AdvancedFileChooserUI.this.filterComboBox.setSelectedItem(filter);
                A03AdvancedFileChooserUI.this.filterComboBox.getParent().doLayout();
            } else if (name.equals("ChoosableFileFilterChangedProperty")) {
                FileFilter[] filters;
                FileFilter[] fileFilterArray = filters = (FileFilter[])e.getNewValue();
                int n = filters.length;
                int n3 = 0;
                while (n3 < n) {
                    FileFilter filter = fileFilterArray[n3];
                    A03AdvancedFileChooserUI.this.filterComboBoxModel.addIfNecessary(filter);
                    ++n3;
                }
                A03AdvancedFileChooserUI.this.filterComboBox.getParent().doLayout();
            } else if (name.equals("fileSelectionChanged")) {
                int selectionMode = (Integer)e.getNewValue();
                A03AdvancedFileChooserUI.this.getFileTable().getSelectionModel().setSelectionMode(selectionMode);
                A03AdvancedFileChooserUI.this.getFileList().getSelectionModel().setSelectionMode(selectionMode);
            } else if (name.equals("ApproveButtonTextChangedProperty")) {
                A03AdvancedFileChooserUI.this.approveButton.setText((String)e.getNewValue());
            } else if (name.equals("ApproveButtonToolTipTextChangedProperty")) {
                A03AdvancedFileChooserUI.this.approveButton.setToolTipText((String)e.getNewValue());
            } else if (name.equals("DialogTypeChangedProperty")) {
                if (e.getNewValue().equals(1)) {
                    A03AdvancedFileChooserUI.this.historyComboBoxModel.setList(directoryHistory);
                } else {
                    A03AdvancedFileChooserUI.this.historyComboBoxModel.setList(fileHistory);
                }
                A03AdvancedFileChooserUI.this.approveButton.setText(A03AdvancedFileChooserUI.this.getApproveButtonText(A03AdvancedFileChooserUI.this.getFileChooser()));
                A03AdvancedFileChooserUI.this.approveButton.setToolTipText(A03AdvancedFileChooserUI.this.getApproveButtonToolTipText(A03AdvancedFileChooserUI.this.getFileChooser()));
            } else if (!name.equals("ApproveButtonMnemonicChangedProperty")) {
                if (name.equals("ControlButtonsAreShownChangedProperty")) {
                    boolean shown = (Boolean)e.getNewValue();
                    A03AdvancedFileChooserUI.this.approveButton.setVisible(shown);
                    A03AdvancedFileChooserUI.this.cancelButton.setVisible(false);
                } else if (name.equals("componentOrientation")) {
                    ComponentOrientation orientation = (ComponentOrientation)e.getNewValue();
                    if (orientation != (ComponentOrientation)e.getOldValue()) {
                        A03AdvancedFileChooserUI.this.getFileChooser().applyComponentOrientation(orientation);
                    }
                } else if (name.equals("ancestor")) {
                    A03AdvancedFileChooserUI.this.getDirectoryTreeModel().reload();
                }
            }
        }
    }

    class WildcardsFileFilter
    extends FileFilter {
        String pattern;
        Matcher matcher;

        public WildcardsFileFilter() {
            this.setPattern("*");
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
            Pattern regex = Pattern.compile(A03AdvancedFileChooserUI.getRegexPattern(pattern));
            this.matcher = regex.matcher("");
        }

        public boolean accept(File f) {
            this.matcher.reset(f.getName());
            return this.matcher.find();
        }

        public String getDescription() {
            return "Wildcards Filter (" + this.pattern + ")";
        }

        public String toString() {
            return this.pattern;
        }
    }
}

