/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.biz.lulanet.swing;

import java.util.Date;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import thirdparty.biz.lulanet.swing.TableMap;

public class TableSorter
extends TableMap {
    static final long serialVersionUID = 0L;
    int[] indexes;
    int[] columns;
    Vector<Integer> sortingColumns = new Vector();
    boolean ascending = false;
    AbstractTableModel sortedModel = null;
    static boolean debug = false;
    int compares;

    public TableSorter() {
        this.indexes = new int[0];
        this.columns = new int[0];
    }

    public TableSorter(AbstractTableModel model) {
        this.setModel(model);
        this.sortedModel = model;
    }

    public static void setDebug(boolean dbg) {
        debug = dbg;
    }

    public void setModel(AbstractTableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
        this.reallocateColumns();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public AbstractTableModel getModel() {
        return this.sortedModel;
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        Class<?> type = this.model.getColumnClass(column);
        AbstractTableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)data.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)data.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s22;
            String s1 = (String)data.getValueAt(row1, column);
            int result = s1.compareTo(s22 = (String)data.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)data.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)data.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = data.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = data.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        int level = 0;
        while (level < this.sortingColumns.size()) {
            Integer column = this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result != 0) {
                return this.ascending ? result : -result;
            }
            ++level;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        int row = 0;
        while (row < rowCount) {
            this.indexes[row] = row;
            ++row;
        }
    }

    public void reallocateColumns() {
        int columnCount = this.model.getColumnCount();
        if (debug) {
            System.out.println("Count columns: " + columnCount);
        }
        this.columns = new int[columnCount];
        int column = 0;
        while (column < columnCount) {
            this.columns[column] = column;
            ++column;
        }
    }

    public void orderColumns(int from, int to) {
        block11: {
            int i;
            int temp;
            int j;
            if (debug) {
                System.out.println("Move column from: " + from + " to: " + to);
            }
            if (from < to) {
                j = from;
                while (j < to) {
                    temp = this.columns[j];
                    this.columns[j] = this.columns[j + 1];
                    this.columns[j + 1] = temp;
                    if (debug) {
                        System.out.println("Index: " + j);
                    }
                    ++j;
                }
            } else {
                j = from;
                while (j > to) {
                    temp = this.columns[j];
                    this.columns[j] = this.columns[j - 1];
                    this.columns[j - 1] = temp;
                    if (debug) {
                        System.out.println("Index: " + j);
                    }
                    --j;
                }
            }
            if (!debug) break block11;
            if (from < to) {
                i = from;
                while (i <= to) {
                    System.out.println("Index at: " + i + "=" + this.columns[i]);
                    ++i;
                }
            } else {
                i = to;
                while (i <= from) {
                    System.out.println("Index at: " + i + "=" + this.columns[i]);
                    ++i;
                }
            }
        }
    }

    public int getColumn(int index) {
        return this.columns[index];
    }

    public int getColumnIndex(String col) {
        int i = 0;
        i = 0;
        while (i < this.sortedModel.getColumnCount()) {
            if (col.equalsIgnoreCase(this.sortedModel.getColumnName(i))) {
                return this.columns[i];
            }
            ++i;
        }
        return -1;
    }

    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        this.reallocateColumns();
        super.tableChanged(e);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
        }
    }

    public void sort(Object sender) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        int i = 0;
        while (i < this.getRowCount()) {
            int j = i + 1;
            while (j < this.getRowCount()) {
                if (this.compare(this.indexes[i], this.indexes[j]) == -1) {
                    this.swap(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            int i = low;
            while (i < high) {
                to[i] = from[i];
                ++i;
            }
            return;
        }
        int i = low;
        while (i < high) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
            ++i;
        }
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public void sortByColumn(int column) {
        this.sortByColumn(this.getColumn(column), true);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(this.getColumn(column)));
        this.sort(this);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public int getIndexAt(int ind) {
        return this.indexes[ind];
    }

    public Vector getRow(int row) {
        Vector<Object> temp = new Vector<Object>();
        int i = 1;
        while (i < this.getColumnCount()) {
            temp.addElement(this.getValueAt(row, i));
            ++i;
        }
        return temp;
    }
}

