/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.widget;

import a03.swing.plaf.A03BorderFactory;
import a03.swing.widget.A03ScrollPaneViewNavigatorDelegate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class A03ScrollPaneViewNavigator
extends JButton {
    private static final long serialVersionUID = -8930217838544596109L;
    private JScrollPane scrollpane;
    private Color selectionBorder;
    private A03ScrollPaneViewNavigatorDelegate delegate;
    private Border border;

    public A03ScrollPaneViewNavigator(JScrollPane scrollpane) {
        this.scrollpane = scrollpane;
        final JViewNavigator viewNavigator = new JViewNavigator();
        this.setFocusPainted(false);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                viewNavigator.display();
            }
        });
        this.delegate = (A03ScrollPaneViewNavigatorDelegate)UIManager.get("ScrollPaneViewNavigator.delegate");
        this.setIcon(new ScrollPaneViewNavigatorIcon());
        this.border = A03BorderFactory.createDelegatedBorder(this.delegate);
    }

    public Border getBorder() {
        return this.border;
    }

    public void setSelectionBorderColor(Color selectionBorder) {
        this.selectionBorder = selectionBorder;
    }

    class JViewNavigator
    extends JComponent {
        private static final long serialVersionUID = 1410541105235186390L;
        private JComponent theComponent;
        private JPopupMenu thePopupMenu;
        private BufferedImage theImage;
        private Rectangle theStartRectangle;
        private Rectangle theRectangle;
        private Point theStartPoint;
        private double theScale;

        public JViewNavigator() {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.theImage = null;
            this.theStartRectangle = null;
            this.theRectangle = null;
            this.theStartPoint = null;
            this.theScale = 0.0;
            this.setCursor(Cursor.getPredefinedCursor(13));
            MouseInputAdapter mil = new MouseInputAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (JViewNavigator.this.theStartPoint != null) {
                        Point newPoint = e.getPoint();
                        int deltaX = (int)((double)(newPoint.x - ((JViewNavigator)JViewNavigator.this).theStartPoint.x) / JViewNavigator.this.theScale);
                        int deltaY = (int)((double)(newPoint.y - ((JViewNavigator)JViewNavigator.this).theStartPoint.y) / JViewNavigator.this.theScale);
                        JViewNavigator.this.scroll(deltaX, deltaY);
                    }
                    JViewNavigator.this.theStartPoint = null;
                    JViewNavigator.this.theStartRectangle = JViewNavigator.this.theRectangle;
                }

                public void mouseMoved(MouseEvent e) {
                    if (JViewNavigator.this.theStartPoint == null) {
                        JViewNavigator.this.theStartPoint = new Point(((JViewNavigator)JViewNavigator.this).theRectangle.x + ((JViewNavigator)JViewNavigator.this).theRectangle.width / 2, ((JViewNavigator)JViewNavigator.this).theRectangle.y + ((JViewNavigator)JViewNavigator.this).theRectangle.height / 2);
                    }
                    Point newPoint = e.getPoint();
                    JViewNavigator.this.moveRectangle(newPoint.x - ((JViewNavigator)JViewNavigator.this).theStartPoint.x, newPoint.y - ((JViewNavigator)JViewNavigator.this).theStartPoint.y);
                }
            };
            this.addMouseListener(mil);
            this.addMouseMotionListener(mil);
            this.thePopupMenu = new JPopupMenu();
            this.thePopupMenu.setLayout(new BorderLayout());
            this.thePopupMenu.add((Component)this, "Center");
        }

        protected void paintComponent(Graphics g) {
            if (this.theImage == null || this.theRectangle == null) {
                return;
            }
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Insets insets = this.getInsets();
            int xOffset = insets.left;
            int yOffset = insets.top;
            graphics.setColor(UIManager.getColor("control"));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage((Image)this.theImage, xOffset, yOffset, null);
            int availableWidth = this.getWidth() - insets.left - insets.right;
            int availableHeight = this.getHeight() - insets.top - insets.bottom;
            Area area = new Area(new Rectangle(xOffset, yOffset, availableWidth, availableHeight));
            area.subtract(new Area(this.theRectangle));
            graphics.setColor(new Color(0, 0, 0, 128));
            graphics.fill(area);
            graphics.setColor(A03ScrollPaneViewNavigator.this.selectionBorder);
            graphics.drawRect(this.theRectangle.x, this.theRectangle.y, this.theRectangle.width - 1, this.theRectangle.height - 1);
            graphics.dispose();
        }

        public Dimension getPreferredSize() {
            if (this.theImage == null || this.theRectangle == null) {
                return new Dimension();
            }
            Insets insets = this.getInsets();
            return new Dimension(this.theImage.getWidth(null) + insets.left + insets.right, this.theImage.getHeight(null) + insets.top + insets.bottom);
        }

        public void display() {
            this.theComponent = (JComponent)A03ScrollPaneViewNavigator.this.scrollpane.getViewport().getView();
            if (this.theComponent == null) {
                return;
            }
            double compWidth = this.theComponent.getWidth();
            double compHeight = this.theComponent.getHeight();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int maxSize = Math.min(screenSize.width - 100, screenSize.height - 100);
            double scaleX = (double)maxSize / compWidth;
            double scaleY = (double)maxSize / compHeight;
            this.theScale = Math.min(Math.min(scaleX, scaleY), 1.0);
            this.theImage = new BufferedImage((int)(compWidth * this.theScale), (int)(compHeight * this.theScale), 1);
            Graphics2D offscreenGraphics = this.theImage.createGraphics();
            offscreenGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            offscreenGraphics.setColor(UIManager.getColor("control"));
            offscreenGraphics.fillRect(0, 0, this.theImage.getWidth(), this.theImage.getHeight());
            offscreenGraphics.scale(this.theScale, this.theScale);
            try {
                this.theComponent.paint(offscreenGraphics);
            }
            finally {
                offscreenGraphics.dispose();
            }
            this.theStartRectangle = A03ScrollPaneViewNavigator.this.scrollpane.getViewport().getViewRect();
            Graphics originalGraphic = this.theComponent.getGraphics();
            this.theComponent.paint(originalGraphic);
            this.theStartRectangle = this.theComponent.getVisibleRect();
            Insets insets = this.getInsets();
            this.theStartRectangle.x = (int)(this.theScale * (double)this.theStartRectangle.x + (double)insets.left);
            this.theStartRectangle.y = (int)(this.theScale * (double)this.theStartRectangle.y + (double)insets.right);
            this.theStartRectangle.width = (int)((double)this.theStartRectangle.width * this.theScale);
            this.theStartRectangle.height = (int)((double)this.theStartRectangle.height * this.theScale);
            this.theRectangle = this.theStartRectangle;
            Point centerPoint = new Point(this.theRectangle.x + this.theRectangle.width / 2, this.theRectangle.y + this.theRectangle.height / 2);
            this.thePopupMenu.show(A03ScrollPaneViewNavigator.this, -centerPoint.x, -centerPoint.y);
        }

        private void moveRectangle(int aDeltaX, int aDeltaY) {
            if (this.theStartRectangle == null) {
                return;
            }
            Insets insets = this.getInsets();
            Rectangle newRect = new Rectangle(this.theStartRectangle);
            newRect.x += aDeltaX;
            newRect.y += aDeltaY;
            newRect.x = Math.min(Math.max(newRect.x, insets.left), this.getWidth() - insets.right - newRect.width);
            newRect.y = Math.min(Math.max(newRect.y, insets.right), this.getHeight() - insets.bottom - newRect.height);
            Rectangle clip = new Rectangle();
            Rectangle.union(this.theRectangle, newRect, clip);
            clip.grow(2, 2);
            this.theRectangle = newRect;
            this.paintImmediately(clip);
        }

        private void scroll(int aDeltaX, int aDeltaY) {
            JComponent component = (JComponent)A03ScrollPaneViewNavigator.this.scrollpane.getViewport().getView();
            Rectangle rect = component.getVisibleRect();
            rect.x += aDeltaX;
            rect.y += aDeltaY;
            component.scrollRectToVisible(rect);
            this.thePopupMenu.setVisible(false);
        }
    }

    class ScrollPaneViewNavigatorIcon
    implements Icon {
        ScrollPaneViewNavigatorIcon() {
        }

        public int getIconHeight() {
            return A03ScrollPaneViewNavigator.this.delegate.getIconHeight();
        }

        public int getIconWidth() {
            return A03ScrollPaneViewNavigator.this.delegate.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (A03ScrollPaneViewNavigator.this.delegate != null) {
                A03ScrollPaneViewNavigator.this.delegate.paintIcon(c, g, x, y);
            }
        }
    }
}

