/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.widget;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class A03ColorPicker
extends JToggleButton {
    private static final long serialVersionUID = -2537353930655235255L;
    private static Robot robot;
    private BufferedImage screenshotAreaImage;
    private Timer timer;
    private JColorChooser chooser;

    static {
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public A03ColorPicker(JColorChooser chooser) {
        this.chooser = chooser;
        this.takeScreenshot(new Point());
        this.setIcon(new ScreenshotAreaIcon());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setContentAreaFilled(false);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (A03ColorPicker.this.isSelected()) {
                    A03ColorPicker.this.timer = new Timer(70, new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            PointerInfo info;
                            Point locationOnScreen;
                            Rectangle bounds;
                            if (A03ColorPicker.this.isShowing() && !(bounds = new Rectangle(A03ColorPicker.this.getLocationOnScreen(), A03ColorPicker.this.getSize())).contains(locationOnScreen = (info = MouseInfo.getPointerInfo()).getLocation())) {
                                A03ColorPicker.this.takeScreenshot(locationOnScreen);
                                A03ColorPicker.this.repaint();
                            }
                        }
                    });
                    A03ColorPicker.this.timer.start();
                    Window window = SwingUtilities.getWindowAncestor(A03ColorPicker.this.chooser);
                    window.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            if (A03ColorPicker.this.timer != null) {
                                A03ColorPicker.this.timer.stop();
                            }
                        }
                    });
                } else {
                    A03ColorPicker.this.timer.stop();
                    A03ColorPicker.this.timer = null;
                }
            }
        });
    }

    private void takeScreenshot(Point locationOnScreen) {
        Color pickedColor = robot.getPixelColor(locationOnScreen.x, locationOnScreen.y);
        this.chooser.setColor(pickedColor);
        locationOnScreen.x -= 5;
        locationOnScreen.y -= 5;
        this.screenshotAreaImage = robot.createScreenCapture(new Rectangle(locationOnScreen, new Dimension(11, 11)));
    }

    class ScreenshotAreaIcon
    implements Icon {
        ScreenshotAreaIcon() {
        }

        public int getIconHeight() {
            return 66;
        }

        public int getIconWidth() {
            return 66;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (A03ColorPicker.this.screenshotAreaImage != null) {
                g.drawImage(A03ColorPicker.this.screenshotAreaImage, x, y, 66, 66, c);
                g.setColor(Color.RED);
                g.drawRect(x + 30, y + 30, 5, 5);
                g.dispose();
            }
        }
    }
}

