/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plugin;

import a03.swing.plugin.A03Plugin;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public class A03ToolTipManagerPlugin
extends MouseAdapter
implements MouseMotionListener,
A03Plugin {
    private TableToolTipListener tableToolTipListener = new TableToolTipListener();
    private TreeToolTipListener treeToolTipListener = new TreeToolTipListener();
    private ListToolTipListener listToolTipListener = new ListToolTipListener();

    public void registerComponent(Component component) {
        if (component instanceof JTable) {
            component.addMouseMotionListener(this.tableToolTipListener);
        } else if (component instanceof JTree) {
            component.addMouseMotionListener(this.treeToolTipListener);
        } else if (component instanceof JList) {
            component.addMouseMotionListener(this.listToolTipListener);
        }
    }

    public void unregisterComponent(Component component) {
        if (component instanceof JTable) {
            component.removeMouseMotionListener(this.tableToolTipListener);
        } else if (component instanceof JTree) {
            component.removeMouseMotionListener(this.treeToolTipListener);
        } else if (component instanceof JList) {
            component.removeMouseMotionListener(this.listToolTipListener);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void installDefaults(UIDefaults table) {
    }

    static class ListToolTipListener
    extends MouseMotionAdapter {
        ListToolTipListener() {
        }

        public void mouseMoved(MouseEvent e) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            Rectangle visibleRect = list.getVisibleRect();
            Rectangle cellBounds = list.getCellBounds(index, index);
            if (cellBounds != null && !visibleRect.contains(cellBounds)) {
                Object item = list.getModel().getElementAt(index);
                if (item != null) {
                    String str = item.toString();
                    if (str != null && !str.equals("")) {
                        list.setToolTipText(str);
                    } else {
                        list.setToolTipText(null);
                    }
                }
            } else {
                list.setToolTipText(null);
            }
        }
    }

    static class TableToolTipListener
    extends MouseMotionAdapter {
        TableToolTipListener() {
        }

        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(e.getPoint());
            int column = table.columnAtPoint(e.getPoint());
            if (row == -1 || column == -1) {
                return;
            }
            TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
            Object value = table.getValueAt(row, column);
            if (value != null) {
                String str = value.toString();
                if (!str.equals("")) {
                    Icon icon;
                    boolean isSelected = true;
                    boolean hasFocus = false;
                    Component component = cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    char[] chars = str.toCharArray();
                    FontMetrics fm = component.getFontMetrics(component.getFont());
                    int width = fm.charsWidth(chars, 0, chars.length);
                    int height = fm.getHeight();
                    if (component instanceof JLabel && (icon = ((JLabel)component).getIcon()) != null) {
                        width += icon.getIconWidth() + ((JLabel)component).getIconTextGap();
                        height = Math.max(height, icon.getIconHeight());
                    }
                    if (table.getColumnModel().getColumn(column).getWidth() < width || table.getRowHeight(row) < height) {
                        table.setToolTipText(str);
                    } else {
                        table.setToolTipText(null);
                    }
                } else {
                    table.setToolTipText(null);
                }
            }
        }
    }

    static class TreeToolTipListener
    extends MouseMotionAdapter {
        TreeToolTipListener() {
        }

        public void mouseMoved(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            TreePath path = tree.getPathForLocation(e.getX(), e.getY());
            Rectangle pathBounds = tree.getPathBounds(path);
            Rectangle visibleRect = tree.getVisibleRect();
            if (pathBounds != null && !visibleRect.contains(pathBounds)) {
                Object value = path.getLastPathComponent();
                if (value != null) {
                    String str = value.toString();
                    if (str != null && !str.equals("")) {
                        tree.setToolTipText(str);
                    } else {
                        tree.setToolTipText(null);
                    }
                }
            } else {
                tree.setToolTipText(null);
            }
        }
    }
}

