/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plugin;

import a03.swing.plugin.A03Plugin;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.text.JTextComponent;

public class A03FocusTrackerPlugin
implements A03Plugin {
    FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            JComponent jcomponent = (JComponent)e.getSource();
            if (jcomponent instanceof JTextComponent && !((JTextComponent)jcomponent).isEditable()) {
                return;
            }
            this.repaint(jcomponent);
        }

        public void focusLost(FocusEvent e) {
            JComponent jcomponent = (JComponent)e.getSource();
            if (jcomponent instanceof JTextComponent && !((JTextComponent)jcomponent).isEditable()) {
                return;
            }
            this.repaint(jcomponent);
        }

        private void repaint(JComponent jcomponent) {
            Container ancestor = SwingUtilities.getAncestorOfClass(JSpinner.class, jcomponent);
            if (ancestor != null) {
                ancestor.repaint();
            } else {
                ancestor = SwingUtilities.getAncestorOfClass(JComboBox.class, jcomponent);
                if (ancestor != null) {
                    ancestor.repaint();
                }
            }
            jcomponent.repaint();
        }
    };

    public void registerComponent(Component component) {
        if (component instanceof JTextComponent || component instanceof JComboBox || component instanceof JSpinner) {
            JComponent jcomponent = (JComponent)component;
            jcomponent.addFocusListener(this.focusListener);
        }
    }

    public void unregisterComponent(Component component) {
        if (component instanceof JTextComponent || component instanceof JComboBox || component instanceof JSpinner) {
            JComponent jcomponent = (JComponent)component;
            jcomponent.addFocusListener(this.focusListener);
        }
    }

    public void installDefaults(UIDefaults table) {
    }
}

