/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03TreeDelegate;
import a03.swing.plaf.style.A03StyleConstants;
import a03.swing.plaf.style.A03StyledSwingUtilities;
import a03.swing.plaf.style.A03TreeStyle;
import a03.swing.plugin.A03FadeTrackerPlugin;
import a03.swing.plugin.A03PluginManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class A03StyledTreeDelegate
implements A03TreeDelegate,
A03StyleConstants {
    private A03TreeStyle style;

    public A03StyledTreeDelegate(A03TreeStyle style) {
        this.style = style;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        return insets;
    }

    public int getRowHeight() {
        return 16;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public FontUIResource getFont() {
        return new FontUIResource(this.style.getFont());
    }

    public Color getForeground(JTree tree, int row) {
        int state = A03StyledSwingUtilities.getState(tree);
        double fadeLevel = A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(tree, row);
        if (fadeLevel > 0.0) {
            state |= 4;
        }
        return this.style.getForegroundColor(state, row);
    }

    public Color getBackground(JTree tree, int row) {
        int state = A03StyledSwingUtilities.getState(tree);
        double fadeLevel = A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(tree, row);
        if (fadeLevel > 0.0) {
            state |= 4;
        }
        return this.style.getBackgroundColor(state, row);
    }

    public ColorUIResource getSelectionForeground() {
        return new ColorUIResource(this.style.getSelectionForegroundColor());
    }

    public ColorUIResource getSelectionBackground() {
        return new ColorUIResource(this.style.getSelectionBackgroundColor());
    }

    public ColorUIResource getBackground() {
        return new ColorUIResource(this.style.getBackgroundColor());
    }

    public int getTreeOpenIconHeight() {
        return 0;
    }

    public int getTreeOpenIconWidth() {
        return 0;
    }

    public void paintTreeOpenIcon(Component c, Graphics g, int x, int y) {
    }

    public int getTreeClosedIconHeight() {
        return 0;
    }

    public int getTreeClosedIconWidth() {
        return 0;
    }

    public int getTreeCollapsedIconHeight() {
        return 14;
    }

    public int getTreeCollapsedIconWidth() {
        return 14;
    }

    public int getTreeExpandedIconHeight() {
        return 14;
    }

    public int getTreeExpandedIconWidth() {
        return 14;
    }

    public int getTreeLeafIconHeight() {
        return 0;
    }

    public int getTreeLeafIconWidth() {
        return 0;
    }

    public void paintTreeClosedIcon(Component c, Graphics g, int x, int y) {
    }

    public void paintTreeExpandedIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.translate(x, y);
        graphics.setColor(this.style.getBackgroundColor());
        graphics.fillRect(2, 3, 8, 8);
        graphics.setColor(UIManager.getColor("controlDkShadow"));
        graphics.drawRect(2, 3, 8, 8);
        graphics.drawLine(4, 7, 8, 7);
        graphics.dispose();
    }

    public void paintTreeCollapsedIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.translate(x, y);
        graphics.setColor(this.style.getBackgroundColor());
        graphics.fillRect(2, 3, 8, 8);
        graphics.setColor(UIManager.getColor("controlDkShadow"));
        graphics.drawRect(2, 3, 8, 8);
        graphics.drawLine(4, 7, 8, 7);
        graphics.drawLine(6, 5, 6, 9);
        graphics.dispose();
    }

    public void paintTreeLeafIcon(Component c, Graphics g, int x, int y) {
    }
}

