/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plaf.A03ToolBarDelegate;
import a03.swing.plaf.A03ToolBarUI;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import a03.swing.plaf.style.A03ToolBarStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ToolBarUI;

public class A03StyledToolBarDelegate
implements A03ToolBarDelegate {
    private A03ToolBarStyle style;

    public A03StyledToolBarDelegate(A03ToolBarStyle style) {
        this.style = style;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        JToolBar toolBar = (JToolBar)c;
        ToolBarUI ui = toolBar.getUI();
        if (ui instanceof A03ToolBarUI && ((A03ToolBarUI)ui).isFloating()) {
            insets.top = 1;
            insets.left = 1;
            insets.bottom = 1;
            insets.right = 1;
            return insets;
        }
        if (toolBar.getOrientation() == 0) {
            insets.top = 1;
            insets.bottom = 1;
            boolean leftToRight = A03SwingUtilities.isLeftToRight(c);
            if (leftToRight) {
                insets.left = toolBar.isFloatable() ? 12 : 1;
                insets.right = 1;
            } else {
                insets.left = 1;
                insets.right = toolBar.isFloatable() ? 12 : 1;
            }
            return insets;
        }
        insets.top = toolBar.isFloatable() ? 12 : 1;
        insets.left = 1;
        insets.bottom = 1;
        insets.right = 1;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JToolBar toolBar = (JToolBar)c;
        if (!((A03ToolBarUI)toolBar.getUI()).isFloating() && toolBar.isFloatable()) {
            Shape shape;
            int y1;
            int x1;
            int length;
            Graphics2D graphics = (Graphics2D)g;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Insets insets = this.getBorderInsets(c, new Insets(0, 0, 0, 0));
            int gripSize = this.style.getGripSize();
            gripSize = (gripSize + 1) / 2 * 2 - 1;
            int orientation = toolBar.getOrientation();
            if (orientation == 0) {
                length = Math.min(height - insets.top - insets.bottom, 24);
                boolean leftToRight = A03SwingUtilities.isLeftToRight(c);
                x1 = leftToRight ? (insets.left - gripSize) / 2 : width - insets.right + gripSize / 2;
                y1 = (height - length) / 2;
                shape = A03GraphicsUtilities.createRoundRectangle(x1, y1, gripSize - 1, length - 1, 3.0f);
            } else {
                length = Math.min(width - insets.left - insets.right, 24);
                x1 = (width - length) / 2;
                y1 = (insets.top - gripSize) / 2;
                shape = A03GraphicsUtilities.createRoundRectangle(x1, y1, length - 1, gripSize - 1, 3.0f);
            }
            Paint background = this.style.getGripBackgroundPaint(1, orientation, x1, y1, length, length);
            graphics.setPaint(background);
            graphics.fill(shape);
            Color border = this.style.getGripBorderPaint(1, orientation, x1, y1, length, length);
            graphics.setPaint(border);
            graphics.draw(shape);
        }
    }

    public void paintSeparator(Component c, Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        JSeparator separator = (JSeparator)c;
        Color background = UIManager.getColor("control");
        Color foreground = UIManager.getColor("controlDkShadow");
        if (separator.getOrientation() == 0) {
            int y = c.getHeight() / 2;
            A03StyledGraphicsUtilities.paintHVDepressedLine(graphics, 4, y, c.getWidth() - 4, y, 8, background, foreground);
        } else {
            int x = c.getWidth() / 2;
            A03StyledGraphicsUtilities.paintHVDepressedLine(graphics, x, 4, x, c.getHeight() - 4, 8, background, foreground);
        }
        graphics.dispose();
    }

    public Insets getMargin() {
        return new Insets(0, 2, 0, 2);
    }

    public ColorUIResource getBackground() {
        return new ColorUIResource(this.style.getBackgroundColor());
    }
}

