/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03TableDelegate;
import a03.swing.plaf.style.A03StyleConstants;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import a03.swing.plaf.style.A03StyledSwingUtilities;
import a03.swing.plaf.style.A03TableStyle;
import a03.swing.plugin.A03FadeTrackerPlugin;
import a03.swing.plugin.A03PluginManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JTable;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class A03StyledTableDelegate
implements A03TableDelegate,
A03StyleConstants {
    private A03TableStyle style;

    public A03StyledTableDelegate(A03TableStyle style) {
        this.style = style;
    }

    public Insets getScrollPaneBorderInsets(Component c, Insets insets) {
        return insets;
    }

    public void paintScrollPaneBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public Color getForeground(JTable table, int row, int column) {
        int state = A03StyledSwingUtilities.getState(table);
        double fadeLevel = A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(table, row, column);
        if (fadeLevel > 0.0) {
            state |= 4;
        }
        return this.style.getForegroundColor(state, row, column);
    }

    public ColorUIResource getSelectionForeground() {
        return new ColorUIResource(this.style.getSelectionForegroundColor());
    }

    public Color getBackground(JTable table, int row, int column) {
        int state = A03StyledSwingUtilities.getState(table);
        double fadeLevel = A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(table, row, column);
        if (fadeLevel > 0.0) {
            state |= 4;
        }
        return this.style.getBackgroundColor(state, row, column);
    }

    public ColorUIResource getSelectionBackground() {
        return new ColorUIResource(this.style.getSelectionBackgroundColor());
    }

    public FontUIResource getFont() {
        return new FontUIResource(this.style.getFont());
    }

    public ColorUIResource getGridColor() {
        return new ColorUIResource(this.style.getGridColor());
    }

    public Stroke getGridStroke() {
        return this.style.getGridStroke();
    }

    public int getAscendingSortIconHeight() {
        return 14;
    }

    public int getAscendingSortIconWidth() {
        return 14;
    }

    public int getDescendingSortIconHeight() {
        return 14;
    }

    public int getDescendingSortIconWidth() {
        return 14;
    }

    public Color getDisabledSelectionBackground() {
        return this.style.getDisabledSelectionBackgroundColor();
    }

    public Color getDisabledSelectionForeground() {
        return this.style.getDisabledSelectionForegroundColor();
    }

    public void paintAscendingSortIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g;
        int size = 8;
        A03StyledGraphicsUtilities.paintArrow(graphics, x += 3, y += 3, size, size, 1, this.style.getArrowPaint(1, 5, x, y, 0, size));
    }

    public void paintDescendingSortIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int size = 8;
        A03StyledGraphicsUtilities.paintArrow(graphics, x += 3, y += 3, size, size, 5, this.style.getArrowPaint(1, 1, x, y, 0, size));
    }

    public String getDateFormat() {
        return this.style.getDateFormat();
    }
}

