/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03TabbedPaneDelegate;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import a03.swing.plaf.style.A03StyledSwingUtilities;
import a03.swing.plaf.style.A03TabbedPaneStyle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JTabbedPane;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class A03StyledTabbedPaneDelegate
implements A03TabbedPaneDelegate {
    private static InsetsUIResource tabAreaInsets = new InsetsUIResource(4, 4, 0, 4);
    private static InsetsUIResource tabInsets = new InsetsUIResource(3, 7, 3, 7);
    private static InsetsUIResource contentInsets = new InsetsUIResource(3, 3, 3, 3);
    private A03TabbedPaneStyle style;

    public A03StyledTabbedPaneDelegate(A03TabbedPaneStyle style) {
        this.style = style;
    }

    public InsetsUIResource getTabAreaInsets() {
        return tabAreaInsets;
    }

    public InsetsUIResource getTabInsets() {
        return tabInsets;
    }

    public InsetsUIResource getContentInsets() {
        return contentInsets;
    }

    public void paintTabText(Graphics g, JTabbedPane tabPane, int tabPlacement, int tabIndex, String title, int x, int y, boolean isSelected) {
        int state = 0;
        if (tabPane.isEnabled() && tabPane.isEnabledAt(tabIndex)) {
            state |= 1;
            if (isSelected) {
                state |= 2;
            }
        }
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(this.style.getForegroundColor(state));
        int mnemIndex = tabPane.getDisplayedMnemonicIndexAt(tabIndex);
        A03GraphicsUtilities.drawStringUnderlineCharAt(tabPane, graphics, title, mnemIndex, x, y);
    }

    public void paintTabBackground(Graphics g, JTabbedPane tabbedPane, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int state = 0;
        if (tabbedPane.isEnabled() && tabbedPane.isEnabledAt(tabIndex)) {
            state |= 1;
            if (isSelected) {
                state |= 2;
            }
        }
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setPaint(this.style.getTabBackgroundPaint(state, tabPlacement, x, y, w, h));
        if (tabPlacement == 1) {
            graphics.fillRect(x + 1, y + 1, w - 3, h - 1);
        } else if (tabPlacement == 3) {
            graphics.fillRect(x + 1, y, w - 3, h - 1);
        } else if (tabPlacement == 4) {
            graphics.fillRect(x + 1, y + 1, w - 3, h - 1);
        } else {
            graphics.fillRect(x + 1, y + 1, w - 3, h - 1);
        }
    }

    protected Shape createTabShape(int tabPlacement, int x, int y, int w, int h) {
        Shape shape = tabPlacement == 1 ? A03GraphicsUtilities.createRoundRectangle(x, y, w - 2, h + 1, 3.0f) : (tabPlacement == 3 ? A03GraphicsUtilities.createRoundRectangle(x, y - 2, w - 2, h + 1, 3.0f) : (tabPlacement == 4 ? A03GraphicsUtilities.createRoundRectangle(x, y + 1, w - 2, h + 1, 3.0f) : A03GraphicsUtilities.createRoundRectangle(x + 1, y, w - 2, h + 1, 3.0f)));
        return shape;
    }

    public void paintTabBorder(Graphics g, JTabbedPane tabbedPane, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int state = 0;
        if (tabbedPane.isEnabled() && tabbedPane.isEnabledAt(tabIndex)) {
            state |= 1;
            if (isSelected) {
                state |= 2;
            }
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(this.style.getTabBorderPaint(state, tabPlacement, x, y, w, h));
        Shape shape = this.createTabShape(tabPlacement, x, y, w, h);
        graphics.clipRect(x, y, w - 1, h);
        graphics.draw(shape);
        graphics.dispose();
    }

    public void paintTabFocusIndicator(Graphics g, JTabbedPane tabbedPane, int tabPlacement, Rectangle[] rects, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    public void paintTabAreaBackground(Graphics g, JTabbedPane tabbedPane, int tabAreaWidth, int tabAreaHeight) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(this.style.getTabAreaBackgroundPaint(tabAreaWidth, tabAreaHeight));
        graphics.fillRect(0, 0, tabAreaWidth, tabAreaHeight);
        graphics.dispose();
    }

    public void paintTabbedPaneContentBorder(Graphics g, JTabbedPane tabPane, int tabPlacement, int selectedIndex, int x, int y, int w, int h, Rectangle selRect) {
        Graphics2D graphics = (Graphics2D)g;
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            path.lineTo(x, y + h - 1);
        } else {
            path.lineTo(x, selRect.y + 1);
            if (selRect.y + selRect.height < y + h - 2) {
                path.moveTo(x, selRect.y + selRect.height - 1);
                path.lineTo(x, y + h - 1);
            }
        }
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
            path.lineTo(x + w - 1, y + h - 1);
        } else {
            path.lineTo(selRect.x, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                path.moveTo(selRect.x + selRect.width - 2, y + h - 1);
                path.lineTo(x + w - 1, y + h - 1);
            }
        }
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
            path.lineTo(x + w - 1, y);
        } else {
            path.lineTo(x + w - 1, selRect.y + selRect.height - 2);
            if (selRect.y + selRect.height < y + h - 2) {
                path.moveTo(x + w - 1, selRect.y);
                path.lineTo(x + w - 1, y);
            }
        }
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            path.lineTo(x, y);
        } else {
            path.lineTo(selRect.x + selRect.width - 2, y);
            if (selRect.x + selRect.width < x + w - 2) {
                path.moveTo(selRect.x, y);
                path.lineTo(x + 1, y);
            }
        }
        graphics.setPaint(this.style.getContentBorderPaint(A03StyledSwingUtilities.getState(tabPane), tabPlacement, x, y, w, h));
        graphics.draw(path);
    }

    public Insets getArrowBorderInsets(Component c, Insets insets) {
        return null;
    }

    public InsetsUIResource getArrowMargin() {
        return null;
    }

    public FontUIResource getFont() {
        return new FontUIResource(this.style.getFont());
    }

    public ColorUIResource getContentAreaColor() {
        return new ColorUIResource(this.style.getContentAreaColor());
    }

    public void paintArrow(Component c, Graphics g, int direction) {
        int size;
        int width = c.getWidth();
        int height = c.getHeight();
        if (height < (size = Math.max(width, height) / 3 + 1) || width < size) {
            return;
        }
        int x = (width - size) / 2;
        int y = (height - size) / 2;
        A03StyledGraphicsUtilities.paintArrow(g, x, y, size, size, direction, this.style.getArrowPaint(1, direction, x, y, size, size));
    }

    public void paintArrowBackground(Component c, Graphics g) {
    }

    public void paintArrowBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }
}

