/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.style.A03RadioButtonStyle;
import a03.swing.plaf.style.A03StyleConstants;
import a03.swing.plugin.A03FadeTrackerPlugin;
import a03.swing.plugin.A03PluginManager;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.UIResource;

public class A03StyledRadioButtonIcon
implements Icon,
UIResource,
A03StyleConstants {
    private Image image;
    private Image imageDisabled;
    private Image imageOver;
    private Image imageSelected;
    private Image imageSelectedDisabled;
    private A03RadioButtonStyle style;
    private int iconWidth;
    private int iconHeight;

    public A03StyledRadioButtonIcon(A03RadioButtonStyle style, int iconWidth, int iconHeight) {
        this.style = style;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.image = A03GraphicsUtilities.createImage(null, iconWidth, iconHeight);
        Graphics2D graphics = (Graphics2D)this.image.getGraphics();
        this.paintRadio(graphics, this.style.getRadioBackgroundPaint(1, 0, 0, 0, iconHeight), this.style.getRadioBorderPaint(1, 0, 0, 0, iconHeight));
        graphics.dispose();
        this.imageDisabled = A03GraphicsUtilities.createImage(null, iconWidth, iconHeight);
        graphics = (Graphics2D)this.imageDisabled.getGraphics();
        this.paintRadio(graphics, this.style.getRadioBackgroundPaint(0, 0, 0, 0, iconHeight), this.style.getRadioBorderPaint(0, 0, 0, 0, iconHeight));
        graphics.dispose();
        this.imageOver = A03GraphicsUtilities.createImage(null, iconWidth, iconHeight);
        graphics = (Graphics2D)this.imageOver.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintRadio(graphics, this.style.getRadioBackgroundPaint(5, 0, 0, 0, iconHeight), this.style.getRadioBorderPaint(5, 0, 0, 0, iconHeight));
        graphics.dispose();
        this.imageSelected = A03GraphicsUtilities.createImage(null, iconWidth, iconHeight);
        graphics = (Graphics2D)this.imageSelected.getGraphics();
        graphics.drawImage(this.imageOver, 0, 0, null);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintRadioSelected(graphics, this.style.getRadioCheckPaint(3, 0, 0, 0, iconHeight - iconHeight / 4));
        graphics.dispose();
        this.imageSelectedDisabled = A03GraphicsUtilities.createImage(null, iconWidth, iconHeight);
        graphics = (Graphics2D)this.imageSelectedDisabled.getGraphics();
        this.paintRadio(graphics, this.style.getRadioBackgroundPaint(2, 0, 0, 0, iconHeight), this.style.getRadioBorderPaint(2, 0, 0, 0, iconHeight));
        this.paintRadioSelected(graphics, this.style.getRadioCheckPaint(2, 0, 0, 0, iconHeight - iconHeight / 4));
        graphics.dispose();
    }

    protected void paintRadio(Graphics2D graphics, Paint background, Paint border) {
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(background);
        graphics.fillOval(2, 2, width - 5, height - 5);
        graphics.setPaint(border);
        graphics.drawOval(1, 1, width - 4, height - 4);
    }

    protected void paintRadioSelected(Graphics2D graphics, Paint foreground) {
        Graphics2D graphics0 = (Graphics2D)graphics.create();
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        graphics0.translate((width - 6) / 2, (height - 6) / 2);
        graphics0.setPaint(foreground);
        graphics0.fillOval(0, 0, 5, 5);
        graphics0.dispose();
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y + 1);
        if (model.isEnabled()) {
            if (model.isSelected()) {
                graphics.drawImage(this.imageSelected, 0, 0, c);
            } else if (model.isArmed()) {
                graphics.drawImage(this.imageOver, 0, 0, c);
            } else if (c instanceof JRadioButtonMenuItem) {
                graphics.drawImage(this.image, 0, 0, c);
            } else {
                double fadeLevel = A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(c);
                if (fadeLevel > 0.0) {
                    if (fadeLevel < 1.0) {
                        graphics.drawImage(this.image, 0, 0, c);
                    }
                    graphics.setComposite(AlphaComposite.getInstance(3, (float)fadeLevel));
                    graphics.drawImage(this.imageOver, 0, 0, c);
                } else {
                    graphics.drawImage(this.image, 0, 0, c);
                }
            }
        } else if (model.isSelected()) {
            graphics.drawImage(this.imageSelectedDisabled, 0, 0, c);
        } else {
            graphics.drawImage(this.imageDisabled, 0, 0, c);
        }
        graphics.dispose();
    }
}

