/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03ListDelegate;
import a03.swing.plaf.style.A03ListStyle;
import a03.swing.plaf.style.A03StyleConstants;
import a03.swing.plaf.style.A03StyledSwingUtilities;
import a03.swing.plugin.A03FadeTrackerPlugin;
import a03.swing.plugin.A03PluginManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JList;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class A03StyledListDelegate
implements A03ListDelegate,
A03StyleConstants {
    private A03ListStyle style;

    public A03StyledListDelegate(A03ListStyle style) {
        this.style = style;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        return null;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public ColorUIResource getBackground() {
        return new ColorUIResource(this.style.getBackgroundColor());
    }

    public Color getForeground(JList list, int layoutOrientation, int row) {
        int state = A03StyledSwingUtilities.getState(list);
        double fadeLevel = A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(list, row);
        if (fadeLevel > 0.0) {
            state |= 4;
        }
        if (layoutOrientation == 0) {
            return this.style.getForegroundColor(state, row);
        }
        if ((state & 4) != 0) {
            return this.style.getSelectionForegroundColor();
        }
        return this.style.getForegroundColor();
    }

    public Color getBackground(JList list, int layoutOrientation, int row) {
        int state = A03StyledSwingUtilities.getState(list);
        double fadeLevel = A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(list, row);
        if (fadeLevel > 0.0) {
            state |= 4;
        }
        if (layoutOrientation == 0) {
            return this.style.getBackgroundColor(state, row);
        }
        if ((state & 4) != 0) {
            return this.style.getSelectionBackgroundColor();
        }
        return this.style.getBackgroundColor();
    }

    public ColorUIResource getSelectionForeground() {
        return new ColorUIResource(this.style.getSelectionForegroundColor());
    }

    public ColorUIResource getDisabledSelectionForeground() {
        return new ColorUIResource(this.style.getDisabledSelectionForegroundColor());
    }

    public ColorUIResource getSelectionBackground() {
        return new ColorUIResource(this.style.getSelectionBackgroundColor());
    }

    public ColorUIResource getDisabledSelectionBackground() {
        return new ColorUIResource(this.style.getDisabledSelectionBackgroundColor());
    }

    public FontUIResource getFont() {
        return new FontUIResource(this.style.getFont());
    }
}

