/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.style.A03StyleConstants;
import a03.swing.plaf.style.A03TitlePaneStyle;
import a03.swing.plugin.A03FadeTrackerPlugin;
import a03.swing.plugin.A03PluginManager;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public class A03StyledCloseIcon
implements Icon,
UIResource,
A03StyleConstants {
    static final Stroke STROKE = new BasicStroke(2.0f, 2, 1, 0.0f);
    private A03TitlePaneStyle style;

    public A03StyledCloseIcon(A03TitlePaneStyle style) {
        this.style = style;
    }

    public int getIconHeight() {
        return 16;
    }

    public int getIconWidth() {
        return 16;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        float fadeLevel;
        Image image = A03GraphicsUtilities.createImage(c, this.getIconWidth(), this.getIconHeight());
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int state = c.isEnabled() ? 1 : 0;
        graphics.setColor(this.style.getCloseForegroundColor(state));
        this.drawCross(graphics);
        if ((state & 1) != 0 && (fadeLevel = (float)A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(c)) > 0.0f) {
            graphics.setColor(this.style.getCloseForegroundColor(5));
            graphics.setComposite(AlphaComposite.getInstance(3, fadeLevel));
            this.drawCross(graphics);
        }
        graphics.dispose();
        g.drawImage(image, x, y, c);
    }

    private void drawCross(Graphics2D graphics) {
        int x1 = 3;
        int y1 = 3;
        int x2 = x1 + 7;
        int y2 = y1 + 7;
        int x3 = x1;
        int y3 = y1 + 7;
        int x4 = x1 + 7;
        int y4 = y1;
        graphics.drawLine(x1, y1, x2, y2);
        graphics.drawLine(x3, y3, x4, y4);
    }
}

