/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03CheckBoxDelegate;
import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.style.A03CheckBoxStyle;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import a03.swing.plugin.A03FadeTrackerPlugin;
import a03.swing.plugin.A03PluginManager;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.plaf.FontUIResource;

public class A03StyledCheckBoxDelegate
implements A03CheckBoxDelegate {
    private Image image;
    private Image imageDisabled;
    private Image imageOver;
    private Image imageSelected;
    private Image imageSelectedDisabled;
    private Image tmpImage;
    private A03CheckBoxStyle style;

    public A03StyledCheckBoxDelegate(A03CheckBoxStyle style) {
        this.style = style;
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        this.tmpImage = A03GraphicsUtilities.createImage(null, width, height);
        this.image = A03GraphicsUtilities.createImage(null, width, height);
        Graphics2D graphics = (Graphics2D)this.image.getGraphics();
        this.paintBox(1, graphics);
        graphics.dispose();
        this.imageDisabled = A03GraphicsUtilities.createImage(null, width, height);
        graphics = (Graphics2D)this.imageDisabled.getGraphics();
        this.paintBox(0, graphics);
        graphics.dispose();
        this.imageOver = A03GraphicsUtilities.createImage(null, width, height);
        graphics = (Graphics2D)this.imageOver.getGraphics();
        this.paintBox(3, graphics);
        graphics.dispose();
        this.imageSelected = A03GraphicsUtilities.createImage(null, width, height);
        graphics = (Graphics2D)this.imageSelected.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(this.imageOver, 0, 0, null);
        A03StyledGraphicsUtilities.paintCheck(graphics, style.getCheckBoxCheckPaint(3, 0, 0, width, height), 3, 3, width - 3, height - 3);
        graphics.dispose();
        this.imageSelectedDisabled = A03GraphicsUtilities.createImage(null, width, height);
        graphics = (Graphics2D)this.imageSelectedDisabled.getGraphics();
        this.paintBox(2, graphics);
        A03StyledGraphicsUtilities.paintCheck(graphics, style.getCheckBoxCheckPaint(0, 0, 0, width, height), 3, 3, width - 3, height - 3);
        graphics.dispose();
    }

    private void paintBox(int state, Graphics2D graphics) {
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(this.style.getCheckBoxBackgroundPaint(state, 2, 2, width - 4, height - 4));
        graphics.fillRect(2, 2, width - 4, height - 4);
        graphics.setPaint(this.style.getCheckBoxBorderPaint(state, 1, 1, width - 3, height - 3));
        graphics.drawRect(1, 1, width - 3, height - 3);
    }

    public FontUIResource getFont() {
        return new FontUIResource(this.style.getFont());
    }

    public int getIconHeight() {
        return 14;
    }

    public int getIconWidth() {
        return 14;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        if (model.isEnabled()) {
            if (model.isPressed() || model.isSelected()) {
                g.drawImage(this.imageSelected, x, y, c);
            } else {
                Graphics2D graphics = (Graphics2D)this.tmpImage.getGraphics();
                double fadeLevel = A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(c);
                if (fadeLevel > 0.0) {
                    if (fadeLevel < 1.0) {
                        graphics.drawImage(this.image, 0, 0, c);
                    }
                    graphics.setComposite(AlphaComposite.getInstance(3, (float)fadeLevel));
                    graphics.drawImage(this.imageOver, 0, 0, c);
                } else {
                    graphics.drawImage(this.image, 0, 0, c);
                }
                graphics.dispose();
                g.drawImage(this.tmpImage, x, y, c);
            }
        } else if (model.isSelected()) {
            g.drawImage(this.imageSelectedDisabled, x, y, c);
        } else {
            g.drawImage(this.imageDisabled, x, y, c);
        }
    }

    public void paintText(Component c, Graphics g, String text, int x, int y) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        int state = 0;
        if (model.isEnabled()) {
            state = 1;
        }
        g.setColor(this.style.getForegroundColor(state));
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        A03GraphicsUtilities.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, x, y);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        return null;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }
}

