/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03Constants;
import a03.swing.plaf.A03TableCellRenderer;
import a03.swing.plaf.A03TableDelegate;
import a03.swing.plugin.A03PluginManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class A03TableUI
extends BasicTableUI {
    protected Map<Class<?>, TableCellRenderer> defaultRenderers;
    private A03TableDelegate delegate;

    public static ComponentUI createUI(JComponent c) {
        return new A03TableUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.delegate = (A03TableDelegate)UIManager.getDefaults().get("Table.delegate");
        super.installUI(c);
        A03PluginManager.getInstance().registerComponent(this.table);
    }

    @Override
    public void uninstallUI(JComponent c) {
        A03PluginManager.getInstance().unregisterComponent(this.table);
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.defaultRenderers = new HashMap();
        this.installRendererIfNecessary(Object.class, new A03TableCellRenderer());
        this.installRendererIfNecessary(Icon.class, new A03TableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(ImageIcon.class, new A03TableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(Number.class, new A03TableCellRenderer.NumberRenderer());
        this.installRendererIfNecessary(Float.class, new A03TableCellRenderer.NumberRenderer());
        this.installRendererIfNecessary(Double.class, new A03TableCellRenderer.NumberRenderer());
        this.installRendererIfNecessary(Date.class, new A03TableCellRenderer.DateRenderer());
        this.installRendererIfNecessary(Boolean.class, new A03TableCellRenderer.BooleanRenderer());
        if (A03Constants.IS_JAVA_6_OR_LATER) {
            this.table.setFillsViewportHeight(true);
        } else {
            this.table.addPropertyChangeListener("ancestor", this.createAncestorPropertyChangeListener());
        }
    }

    private PropertyChangeListener createAncestorPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                A03TableUI.this.parentDidChange();
            }
        };
    }

    private void parentDidChange() {
        if (this.table.getParent() instanceof JViewport && this.table.getParent().getParent() instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)this.table.getParent().getParent();
            scrollPane.getViewport().setLayout(new BugFixedViewportLayout());
        }
    }

    protected void installRendererIfNecessary(Class<?> clazz, TableCellRenderer renderer) {
        TableCellRenderer currRenderer = this.table.getDefaultRenderer(clazz);
        if (currRenderer != null) {
            boolean isCore;
            boolean bl = isCore = currRenderer instanceof DefaultTableCellRenderer.UIResource || currRenderer.getClass().getName().startsWith("javax.swing.JTable");
            if (!isCore) {
                return;
            }
        }
        this.table.setDefaultRenderer(clazz, renderer);
    }

    @Override
    protected void uninstallDefaults() {
        for (Map.Entry<Class<?>, TableCellRenderer> entry : this.defaultRenderers.entrySet()) {
            this.uninstallRendererIfNecessary(entry.getKey(), entry.getValue());
        }
        super.uninstallDefaults();
    }

    protected void uninstallRendererIfNecessary(Class<?> clazz, TableCellRenderer renderer) {
        TableCellRenderer currRenderer = this.table.getDefaultRenderer(clazz);
        if (currRenderer != null) {
            boolean isA03Renderer;
            boolean bl = isA03Renderer = currRenderer instanceof A03TableCellRenderer || currRenderer instanceof A03TableCellRenderer.BooleanRenderer;
            if (!isA03Renderer) {
                return;
            }
        }
        if (renderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
        }
        this.table.setDefaultRenderer(clazz, renderer);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        Point upperLeft = clip.getLocation();
        if (!ltr) {
            ++upperLeft.x;
        }
        Point lowerRight = new Point(clip.x + clip.width - (ltr ? 1 : 0), clip.y + clip.height);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint(ltr ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintCells(g, rMin, rMax, cMin, cMax);
        this.paintGrid(g, rMin, rMax, cMin, cMax);
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        Rectangle cellRect0;
        boolean columnSelected;
        int column;
        boolean rowSelected;
        int height;
        int y;
        int x;
        Rectangle cellRect;
        int row;
        TableColumn aColumn;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int width = 0;
        int column2 = cMin;
        while (column2 <= cMax) {
            aColumn = cm.getColumn(column2);
            width += aColumn.getWidth();
            ++column2;
        }
        boolean rowSelectionAllowed = this.table.getRowSelectionAllowed();
        boolean columnSelectionAllowed = this.table.getColumnSelectionAllowed();
        Color selectionBackground = this.table.getSelectionBackground();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            row = rMin;
            while (row <= rMax) {
                cellRect = this.table.getCellRect(row, cMin, true);
                x = cellRect.x;
                y = cellRect.y;
                height = cellRect.height;
                rowSelected = this.table.isRowSelected(row);
                if (rowSelected && rowSelectionAllowed && !columnSelectionAllowed) {
                    graphics.setColor(selectionBackground);
                } else {
                    graphics.setColor(this.delegate.getBackground(this.table, row, cMin));
                }
                graphics.fillRect(x, y, width, height);
                column = cMin;
                while (column <= cMax) {
                    cellRect = this.table.getCellRect(row, column, false);
                    if (columnSelectionAllowed) {
                        columnSelected = this.table.isColumnSelected(column);
                        if (rowSelectionAllowed) {
                            if (columnSelected && rowSelected) {
                                graphics.setColor(selectionBackground);
                            } else {
                                graphics.setColor(this.delegate.getBackground(this.table, row, column));
                            }
                        } else if (columnSelected) {
                            graphics.setColor(selectionBackground);
                        } else {
                            graphics.setColor(this.delegate.getBackground(this.table, row, column));
                        }
                        cellRect0 = this.table.getCellRect(row, column, true);
                        graphics.fillRect(cellRect0.x, cellRect0.y, cellRect0.width, cellRect0.height);
                    }
                    if ((aColumn = cm.getColumn(column)) != draggedColumn) {
                        this.paintCell(graphics, cellRect, row, column);
                    }
                    ++column;
                }
                ++row;
            }
        } else {
            row = rMin;
            while (row <= rMax) {
                cellRect = this.table.getCellRect(row, cMax, true);
                x = cellRect.x;
                y = cellRect.y;
                height = cellRect.height;
                rowSelected = this.table.isRowSelected(row);
                if (rowSelected && rowSelectionAllowed && !columnSelectionAllowed) {
                    graphics.setColor(selectionBackground);
                } else {
                    graphics.setColor(this.delegate.getBackground(this.table, row, cMin));
                }
                graphics.fillRect(x, y, width, height);
                column = cMin;
                while (column <= cMax) {
                    cellRect = this.table.getCellRect(row, column, false);
                    if (columnSelectionAllowed) {
                        columnSelected = this.table.isColumnSelected(column);
                        if (rowSelectionAllowed) {
                            if (columnSelected && rowSelected) {
                                graphics.setColor(selectionBackground);
                            } else {
                                graphics.setColor(this.delegate.getBackground(this.table, row, column));
                            }
                        } else if (columnSelected) {
                            graphics.setColor(selectionBackground);
                        } else {
                            graphics.setColor(this.delegate.getBackground(this.table, row, column));
                        }
                        cellRect0 = this.table.getCellRect(row, column, true);
                        graphics.fillRect(cellRect0.x, cellRect0.y, cellRect0.width, cellRect0.height);
                    }
                    if ((aColumn = cm.getColumn(column)) != draggedColumn) {
                        this.paintCell(graphics, cellRect, row, column);
                    }
                    ++column;
                }
                ++row;
            }
        }
        cellRect = this.table.getCellRect(rMax, cMin, true);
        int topY = cellRect.y + cellRect.height;
        int currentRow = rMax + 1;
        Rectangle clipBounds = graphics.getClipBounds();
        int y2 = topY;
        int rowHeight = this.table.getRowHeight();
        while (y2 < clipBounds.y + clipBounds.height) {
            graphics.setColor(this.delegate.getBackground(this.table, currentRow, -1));
            graphics.fillRect(clipBounds.x, y2, clipBounds.width, rowHeight);
            y2 += rowHeight;
            ++currentRow;
        }
        this.rendererPane.removeAll();
        graphics.dispose();
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            JComponent component = (JComponent)this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer;
            Component component;
            Graphics2D graphics = (Graphics2D)g.create();
            if (row == this.table.getSelectedRow() && column == this.table.getSelectedColumn() && !this.table.getRowSelectionAllowed() && !this.table.getColumnSelectionAllowed()) {
                System.err.println(cellRect);
            }
            if ((component = this.table.prepareRenderer(renderer = this.table.getCellRenderer(row, column), row, column)) instanceof A03TableCellRenderer || component instanceof A03TableCellRenderer.BooleanRenderer) {
                if (row == this.table.getSelectedRow() && this.table.getRowSelectionAllowed() && (!this.table.getColumnSelectionAllowed() || column == this.table.getSelectedColumn() && this.table.getColumnSelectionAllowed()) || !this.table.getRowSelectionAllowed() && column == this.table.getSelectedColumn() && this.table.getColumnSelectionAllowed()) {
                    boolean isEnabled = this.table.isEnabled();
                    component.setForeground(isEnabled ? this.delegate.getSelectionForeground() : this.delegate.getDisabledSelectionForeground());
                } else {
                    component.setForeground(this.delegate.getForeground(this.table, row, column));
                }
            }
            this.rendererPane.paintComponent(graphics, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            graphics.dispose();
        }
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        block8: {
            Graphics2D graphics = (Graphics2D)g;
            graphics.setColor(this.table.getGridColor());
            graphics.setStroke(this.delegate.getGridStroke());
            Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
            Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            int tableWidth = damagedArea.x + damagedArea.width;
            Rectangle clipBounds = g.getClipBounds();
            int tableHeight = clipBounds.y + clipBounds.height;
            Dimension intercellSpacing = this.table.getIntercellSpacing();
            if (intercellSpacing.height > 0 && this.table.getShowHorizontalLines()) {
                int y = damagedArea.y;
                int row = rMin;
                while (row < rMax) {
                    graphics.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
                    ++row;
                }
                int rowHeight = this.table.getRowHeight();
                while (y < tableHeight) {
                    graphics.drawLine(damagedArea.x, y - 1, tableWidth - 1, y - 1);
                    y += rowHeight;
                }
            }
            if (intercellSpacing.width <= 0) break block8;
            TableColumnModel cm = this.table.getColumnModel();
            if (this.table.getShowVerticalLines()) {
                int x;
                if (this.table.getComponentOrientation().isLeftToRight()) {
                    x = damagedArea.x;
                    int column = cMin;
                    while (column < cMax) {
                        int w = cm.getColumn(column).getWidth();
                        graphics.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                        ++column;
                    }
                } else {
                    x = damagedArea.x + damagedArea.width;
                    int column = cMin;
                    while (column < cMax) {
                        int w = cm.getColumn(column).getWidth();
                        graphics.drawLine((x -= w) - 1, 0, x - 1, tableHeight - 1);
                        ++column;
                    }
                }
            }
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (c.isOpaque()) {
            Rectangle2D rectangle = (Rectangle2D)g.getClip();
            graphics.setColor(c.getBackground());
            graphics.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        }
        this.paint(graphics, c);
        graphics.dispose();
    }

    private class BugFixedViewportLayout
    extends ViewportLayout {
        private static final long serialVersionUID = -5825893010963635676L;

        private BugFixedViewportLayout() {
        }

        public void layoutContainer(Container parent) {
            JViewport vp = (JViewport)parent;
            Component view = vp.getView();
            Scrollable scrollableView = null;
            if (view == null) {
                return;
            }
            if (view instanceof Scrollable) {
                scrollableView = (Scrollable)((Object)view);
            }
            Dimension viewPrefSize = view.getPreferredSize();
            Dimension vpSize = vp.getSize();
            Dimension extentSize = vp.toViewCoordinates(vpSize);
            Dimension viewSize = new Dimension(viewPrefSize);
            if (scrollableView != null) {
                if (scrollableView.getScrollableTracksViewportWidth()) {
                    viewSize.width = vpSize.width;
                }
                if (scrollableView.getScrollableTracksViewportHeight()) {
                    viewSize.height = vpSize.height;
                }
            }
            Point viewPosition = vp.getViewPosition();
            if (scrollableView == null || vp.getParent() == null || vp.getParent().getComponentOrientation().isLeftToRight()) {
                if (viewPosition.x + extentSize.width > viewSize.width) {
                    viewPosition.x = Math.max(0, viewSize.width - extentSize.width);
                }
            } else {
                viewPosition.x = extentSize.width > viewSize.width ? viewSize.width - extentSize.width : Math.max(0, Math.min(viewSize.width - extentSize.width, viewPosition.x));
            }
            if (viewPosition.y + extentSize.height > viewSize.height) {
                viewPosition.y = Math.max(0, viewSize.height - extentSize.height);
            }
            if (scrollableView == null) {
                if (viewPosition.x == 0 && vpSize.width > viewPrefSize.width) {
                    viewSize.width = vpSize.width;
                }
                if (viewPosition.y == 0 && vpSize.height > viewPrefSize.height) {
                    viewSize.height = vpSize.height;
                }
            }
            if (viewPosition.x == 0 && vpSize.width > viewPrefSize.width) {
                viewSize.width = vpSize.width;
            }
            if (viewPosition.y == 0 && vpSize.height > viewPrefSize.height) {
                viewSize.height = vpSize.height;
            }
            vp.setViewPosition(viewPosition);
            vp.setViewSize(viewSize);
        }
    }
}

