/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plaf.A03TableDelegate;
import a03.swing.plaf.A03TableHeaderDelegate;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class A03TableHeaderUI
extends BasicTableHeaderUI {
    private A03TableHeaderDelegate delegate;
    private int rolloverColumn = -1;
    private int selectedColumnIndex = 0;

    public static ComponentUI createUI(JComponent c) {
        return new A03TableHeaderUI();
    }

    public void installUI(JComponent c) {
        this.delegate = (A03TableHeaderDelegate)A03SwingUtilities.getDelegate(c, UIManager.get("TableHeader.delegate"));
        super.installUI(c);
    }

    public void update(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (c.isOpaque()) {
            graphics.setColor(c.getBackground());
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(graphics, c);
        graphics.dispose();
    }

    protected int getRolloverColumn() {
        return this.rolloverColumn;
    }

    protected void rolloverColumnUpdated(int oldColumn, int newColumn) {
    }

    private int getSelectedColumnIndex() {
        int numCols = this.header.getColumnModel().getColumnCount();
        if (this.selectedColumnIndex >= numCols && numCols > 0) {
            this.selectedColumnIndex = numCols - 1;
        }
        return this.selectedColumnIndex;
    }

    public void paint(Graphics g, JComponent c) {
        int column;
        Graphics2D graphics = (Graphics2D)g;
        this.delegate.paintBackground(this.header, graphics);
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = graphics.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            column = cMin;
            while (column <= cMax) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(graphics, cellRect, column);
                }
                cellRect.x += columnWidth;
                ++column;
            }
        } else {
            column = cMax;
            while (column >= cMin) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(graphics, cellRect, column);
                }
                cellRect.x += columnWidth;
                --column;
            }
        }
        if (draggedColumn != null) {
            graphics.setComposite(AlphaComposite.getInstance(3, 0.25f));
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(graphics, draggedCellRect, draggedColumnIndex);
        }
        this.rendererPane.removeAll();
        this.paintGrid(graphics, c);
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        boolean hasFocus = columnIndex == this.getSelectedColumnIndex() && this.header.hasFocus();
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, hasFocus, -1, columnIndex);
        A03TableDelegate delegate = (A03TableDelegate)UIManager.get("Table.delegate");
        JTable table = this.header.getTable();
        component.setForeground(delegate.getForeground(table, -1, -1));
        return component;
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        Component component = this.getHeaderRenderer(columnIndex);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    protected void paintGrid(Graphics g, JComponent c) {
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        left = new Point(left.x - 2, left.y);
        Point right = new Point(clip.x + clip.width + 2, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        Graphics2D graphics = (Graphics2D)g;
        Rectangle cellRect0 = this.header.getHeaderRect(cMin);
        int bottom = cellRect0.y + cellRect0.height - 1;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color gridColor = this.header.getTable().getGridColor();
        graphics.setColor(gridColor);
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        graphics.drawLine((int)left.getX(), cellRect0.y, (int)right.getX(), cellRect0.y);
        graphics.drawLine((int)left.getX(), bottom, (int)right.getX(), bottom);
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            int column = cMin;
            while (column <= cMax) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    graphics.drawLine(cellRect.x, cellRect.y, cellRect.x, bottom);
                }
                cellRect.x += columnWidth;
                ++column;
            }
            cellRect.x += cm.getColumnMargin();
            graphics.drawLine(cellRect.x, cellRect.y, cellRect.x, bottom);
        } else {
            int column = cMax;
            while (column >= cMin) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    graphics.drawLine(cellRect.x, cellRect.y, cellRect.x, bottom);
                }
                cellRect.x += columnWidth;
                --column;
            }
            cellRect.x += cm.getColumnMargin();
            graphics.drawLine(cellRect.x, cellRect.y, cellRect.x, bottom);
        }
    }
}

