/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import java.awt.Component;
import java.awt.Graphics;
import java.text.SimpleDateFormat;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class A03TableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 7799932802450118618L;
    private static final Border noFocusBorder = new EmptyBorder(2, 1, 1, 2);

    public A03TableCellRenderer() {
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setFont(table.getFont());
        this.setValue(value);
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = noFocusBorder;
            }
            this.setBorder(border);
        } else {
            this.setBorder(noFocusBorder);
        }
        return this;
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -4194424044961042536L;

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.setOpaque(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value != null && (Boolean)value != false);
            this.setEnabled(table.isEnabled());
            this.setBorder(noFocusBorder);
            return this;
        }

        public final void paint(Graphics g) {
            super.paint(g);
        }

        protected final void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }

    public static class DateRenderer
    extends A03TableCellRenderer {
        private static final long serialVersionUID = -7702255836498522701L;
        private static final SimpleDateFormat formatter = new SimpleDateFormat(UIManager.getString("Table.cellRendererDateFormat"));

        public void setValue(Object value) {
            this.setText(value == null ? "" : formatter.format(value));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    public static class IconRenderer
    extends A03TableCellRenderer {
        private static final long serialVersionUID = -5050808272348452615L;

        public IconRenderer() {
            this.setHorizontalAlignment(0);
            this.setText(null);
        }

        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
        }
    }

    public static class NumberRenderer
    extends A03TableCellRenderer {
        private static final long serialVersionUID = 3005802337956053117L;

        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }
}

