/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03Constants;
import a03.swing.plaf.A03TableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.awt.shell.ShellFolder;
import thirdparty.biz.lulanet.swing.SortTableCellRenderer;
import thirdparty.biz.lulanet.swing.TableSorter;

public class A03SimpleFileChooserUI
extends BasicFileChooserUI {
    private static final Hashtable<String, Icon> systemIcons = new Hashtable();
    private static SimpleDateFormat simpleDateTimeFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.US);
    private static FileFilter ALL_FILEFILTER = new AllFileFilter();
    private JTable fileTable;
    private FileTableModel fileTableModel;
    private TableSorter sorter = null;
    private JScrollPane tableScrollPane;
    private DefaultTreeModel directoryTreeModel;
    private DirectoryTreeNode currentNode;
    private JTree directoryTree;
    private ListSelectionListener listSelectionListener;
    private JButton approveButton;
    private JButton cancelButton;
    private Locale locale;
    private JPopupMenu filePopupMenu;
    private JMenuItem newFolderItem;
    private JMenuItem deleteItem;
    private JMenuItem renameItem;
    private JPanel accessoryContainer;
    private boolean filePathSelectionIsAdjusting;
    private boolean directoryTreeSelectionIsAdjusting;
    private boolean fileSelectionsIsAdjusting;
    private String filename;

    public A03SimpleFileChooserUI(JFileChooser fc) {
        super(fc);
        this.locale = fc.getLocale();
    }

    public static ComponentUI createUI(JComponent c) {
        return new A03SimpleFileChooserUI((JFileChooser)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.installComponents(this.getFileChooser());
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallComponents((JFileChooser)c);
    }

    private JPanel buildSouthPanel() {
        FlowLayout layout = new FlowLayout();
        layout.setHgap(0);
        layout.setVgap(0);
        layout.setAlignment(2);
        JPanel southPanel = new JPanel(layout);
        southPanel.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.approveButton = new JButton(this.getApproveButtonText(this.getFileChooser()));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.getFileChooser()));
        this.approveButton.setEnabled(false);
        southPanel.add(this.approveButton);
        southPanel.add(Box.createHorizontalStrut(4));
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        southPanel.add(this.cancelButton);
        return southPanel;
    }

    private void buildDetailsPopupMenu() {
        this.filePopupMenu = new JPopupMenu();
        this.filePopupMenu.setOpaque(false);
        this.filePopupMenu.setDoubleBuffered(true);
        this.filePopupMenu.setFocusable(false);
        JMenuItem homeItem = new JMenuItem();
        homeItem.setAction(this.getGoHomeAction());
        this.filePopupMenu.add(homeItem);
        this.filePopupMenu.addSeparator();
        this.newFolderItem = new JMenuItem("New Folder");
        this.newFolderItem.setAction(this.getNewFolderAction());
        this.filePopupMenu.add(this.newFolderItem);
        this.deleteItem = new JMenuItem("Delete");
        this.deleteItem.addActionListener(EventHandler.create(ActionListener.class, this, "doDelete"));
        this.filePopupMenu.add(this.deleteItem);
        this.renameItem = new JMenuItem("Rename");
        this.renameItem.addActionListener(EventHandler.create(ActionListener.class, this, "doRename"));
        this.filePopupMenu.add(this.renameItem);
    }

    public void doRename() {
        File newFile;
        File file = this.getSelectedFiles(this.filePopupMenu.getInvoker())[0];
        String newName = JOptionPane.showInputDialog(this.getFileChooser(), "To", file.getName());
        if (newName != null && file.renameTo(newFile = new File(file.getParentFile(), newName))) {
            this.getFileChooser().setCurrentDirectory(newFile.getParentFile());
            this.rescanCurrentDirectory(this.getFileChooser());
        }
    }

    public static boolean delete(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                boolean answer;
                File file = fileArray[n2];
                if (file.isDirectory() ? !(answer = A03SimpleFileChooserUI.delete(file)) : !file.delete()) {
                    return false;
                }
                ++n2;
            }
        }
        return directory.delete();
    }

    public void doDelete() {
        if (JOptionPane.showConfirmDialog(this.getFileChooser(), "Are you sure ?", "Confirm", 0) == 0) {
            Component source = this.filePopupMenu.getInvoker();
            File[] files = this.getSelectedFiles(source);
            if (source == this.getFileTable()) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    A03SimpleFileChooserUI.delete(file);
                    if (file.isDirectory()) {
                        DirectoryTreeNode node = this.getDirectoryTreeNode(file);
                        node.removeFromParent();
                    }
                    ++n2;
                }
                this.rescanCurrentDirectory(this.getFileChooser());
            } else {
                A03SimpleFileChooserUI.delete(this.currentNode.getFile());
                DirectoryTreeNode parent = (DirectoryTreeNode)this.currentNode.getParent();
                this.currentNode.removeFromParent();
                this.currentNode = parent;
                this.rescanCurrentDirectory(this.getFileChooser());
                this.getFileChooser().setCurrentDirectory(this.currentNode.getFile());
            }
        }
    }

    public void installComponents(JFileChooser fc) {
        fc.setBorder(new EmptyBorder(3, 3, 3, 3));
        fc.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(1);
        splitPane.setLeftComponent(new JScrollPane(this.getDirectoryTree()));
        splitPane.setDividerLocation(300);
        splitPane.setRightComponent(this.getFileTableScrollPane());
        splitPane.setPreferredSize(new Dimension(800, 300));
        fc.add((Component)splitPane, "Center");
        this.accessoryContainer = new JPanel();
        this.accessoryContainer.setLayout(new BorderLayout());
        fc.add((Component)this.accessoryContainer, "East");
        JPanel southPanel = this.buildSouthPanel();
        fc.add((Component)southPanel, "South");
        this.buildDetailsPopupMenu();
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
    }

    private Icon getSystemIcon(File f) {
        try {
            FileSystemView fsv = this.getFileChooser().getFileSystemView();
            ShellFolder sf = ShellFolder.getShellFolder(f);
            String folderType = sf.getFolderType();
            Icon icon = systemIcons.get(folderType);
            if (icon == null) {
                icon = fsv.getSystemIcon(f);
                systemIcons.put(folderType, icon);
            }
            return icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        JTable table = this.getFileTable();
        int index = table.getSelectedRow();
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(index, 0, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                A03SimpleFileChooserUI.this.currentNode.rescan();
                A03SimpleFileChooserUI.this.getDirectoryTreeModel().reload();
                TreePath path = new TreePath(A03SimpleFileChooserUI.this.currentNode.getPath());
                A03SimpleFileChooserUI.this.getDirectoryTree().expandPath(path);
                A03SimpleFileChooserUI.this.getDirectoryTree().setSelectionPath(path);
                A03SimpleFileChooserUI.this.updateDetails();
            }
        });
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListenerImpl();
    }

    private DefaultTreeModel getDirectoryTreeModel() {
        if (this.directoryTreeModel == null) {
            this.currentNode = new DirectoryTreeNode(this.getFileChooser().getFileSystemView().getRoots()[0]);
            this.directoryTreeModel = new DefaultTreeModel(this.currentNode);
        }
        return this.directoryTreeModel;
    }

    private JTree getDirectoryTree() {
        if (this.directoryTree == null) {
            this.directoryTree = new JTree(this.getDirectoryTreeModel());
            new DnDTreeHandler(this.directoryTree);
            this.directoryTree.addTreeWillExpandListener(new DirectoryTreeWillExpandListener());
            this.directoryTree.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    A03SimpleFileChooserUI.this.processMouseEvent(A03SimpleFileChooserUI.this.directoryTree, e);
                }
            });
            this.directoryTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
                    if (newLeadSelectionPath != null) {
                        A03SimpleFileChooserUI.this.currentNode = (DirectoryTreeNode)newLeadSelectionPath.getLastPathComponent();
                        if (A03SimpleFileChooserUI.this.currentNode != null) {
                            A03SimpleFileChooserUI.this.directoryTreeSelectionIsAdjusting = true;
                            A03SimpleFileChooserUI.this.getFileChooser().setCurrentDirectory(A03SimpleFileChooserUI.this.currentNode.getFile());
                            A03SimpleFileChooserUI.this.directoryTreeSelectionIsAdjusting = false;
                        }
                    }
                }
            });
            this.directoryTree.setCellRenderer(new DirectoryNodeRenderer());
            this.directoryTree.getSelectionModel().setSelectionMode(1);
            this.directoryTree.setShowsRootHandles(false);
        }
        return this.directoryTree;
    }

    private DirectoryTreeNode getDirectoryTreeNode(File target) {
        DirectoryTreeNode node = (DirectoryTreeNode)this.getDirectoryTree().getModel().getRoot();
        FileSystemView fsw = this.getFileChooser().getFileSystemView();
        if (fsw.getParentDirectory(target) == null) {
            return node;
        }
        ArrayList<File> children = new ArrayList<File>();
        File file = target;
        do {
            children.add(file);
        } while (fsw.getParentDirectory(file = fsw.getParentDirectory(file)) != null);
        int i = children.size();
        block1: while (--i >= 0) {
            file = (File)children.get(i);
            Enumeration<TreeNode> e = node.children();
            if (!node.isLeaf() && !e.hasMoreElements()) {
                node.rescan();
                e = node.children();
            }
            while (e.hasMoreElements()) {
                DirectoryTreeNode child = (DirectoryTreeNode)e.nextElement();
                File childFile = child.getFile();
                if (!childFile.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                node = child;
                continue block1;
            }
        }
        return node;
    }

    public ListSelectionListener getListSelectionListener() {
        if (this.listSelectionListener == null) {
            this.listSelectionListener = new ListSelectionListenerImpl();
        }
        return this.listSelectionListener;
    }

    public FileTableModel getFileTableModel() {
        if (this.fileTableModel == null) {
            this.fileTableModel = new FileTableModel();
        }
        return this.fileTableModel;
    }

    public JTable getFileTable() {
        if (this.fileTable == null) {
            this.fileTable = new JTable();
            new DnDTableHandler(this.fileTable);
            this.sorter = new TableSorter(this.getFileTableModel());
            this.fileTable.setModel(this.sorter);
            this.fileTable.getSelectionModel().addListSelectionListener(this.getListSelectionListener());
            this.fileTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    A03SimpleFileChooserUI.this.processMouseEvent(A03SimpleFileChooserUI.this.fileTable, e);
                }
            });
            this.fileTable.setShowHorizontalLines(false);
            this.fileTable.setShowVerticalLines(false);
            this.fileTable.setAutoResizeMode(2);
            this.fileTable.setRowHeight(19);
            FileTableCellRenderer renderer = new FileTableCellRenderer();
            SortTableCellRenderer headerRenderer = new SortTableCellRenderer(this.fileTable);
            this.fileTable.getTableHeader().setReorderingAllowed(false);
            TableColumnModel tcm = this.fileTable.getColumnModel();
            TableColumn tc = tcm.getColumn(0);
            tc.setHeaderRenderer(headerRenderer);
            tc.setCellRenderer(renderer);
            tc = tcm.getColumn(1);
            tc.setHeaderRenderer(headerRenderer);
            tc.setCellRenderer(renderer);
            tc.setMinWidth(120);
            tc.setMaxWidth(120);
        }
        return this.fileTable;
    }

    private File[] getSelectedFiles(Object source) {
        File[] files = null;
        if (source == this.getFileTable()) {
            int[] rows = this.getFileTable().getSelectedRows();
            files = new File[rows.length];
            int i = 0;
            while (i < rows.length) {
                files[i] = this.getFileTableModel().getFileAt(this.sorter.getIndexAt(rows[i]));
                ++i;
            }
        } else if (source == this.getDirectoryTree()) {
            files = new File[]{this.currentNode.getFile()};
        }
        return files;
    }

    private void processMouseEvent(Component target, MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            if (target == this.getFileTable()) {
                boolean enabled;
                int[] rows = this.getFileTable().getSelectedRows();
                if (rows.length == 1) {
                    File file = this.getFileTableModel().getFileAt(this.sorter.getIndexAt(rows[0]));
                    enabled = this.isFileModifiable(file);
                } else {
                    enabled = false;
                }
                this.deleteItem.setEnabled(enabled);
                this.renameItem.setEnabled(enabled);
                this.filePopupMenu.show(target, e.getX(), e.getY());
            } else {
                boolean enabled;
                int row = this.getDirectoryTree().getRowForLocation(e.getX(), e.getY());
                if (this.getDirectoryTree().isRowSelected(row)) {
                    TreePath treePath = this.getDirectoryTree().getPathForRow(row);
                    DirectoryTreeNode node = (DirectoryTreeNode)treePath.getLastPathComponent();
                    File file = node.getFile();
                    enabled = this.isFileModifiable(file);
                } else {
                    enabled = false;
                }
                this.deleteItem.setEnabled(enabled);
                this.renameItem.setEnabled(enabled);
                this.filePopupMenu.show(target, e.getX(), e.getY());
            }
        } else if (e.getClickCount() == 2) {
            File file = this.getSelectedFiles(target)[0];
            if (file.getName().equals("..")) {
                this.getChangeToParentDirectoryAction().actionPerformed(null);
            } else if (file.isDirectory()) {
                this.getFileChooser().setCursor(A03Constants.WAIT_CURSOR_INSTANCE);
                this.getFileChooser().setCurrentDirectory(file);
                this.getFileChooser().setCursor(A03Constants.DEFAULT_CURSOR_INSTANCE);
            }
        }
    }

    private boolean isFileModifiable(File file) {
        return !this.getFileChooser().getFileSystemView().isFileSystemRoot(file) && !this.getFileChooser().getFileSystemView().isRoot(file) && !this.getFileChooser().getFileSystemView().isDrive(file);
    }

    private JScrollPane getFileTableScrollPane() {
        if (this.tableScrollPane == null) {
            this.tableScrollPane = new JScrollPane(this.getFileTable());
            this.tableScrollPane.setVerticalScrollBarPolicy(22);
        }
        return this.tableScrollPane;
    }

    private void updateDetails() {
        this.getFileTableModel().setCurrentNode(this.currentNode);
    }

    public void setFileName(String filename) {
        this.filename = filename;
        if (filename != null) {
            File file = this.getFileChooser().getFileSystemView().createFileObject(filename);
            this.filePathSelectionIsAdjusting = true;
            if (this.getFileChooser().isMultiSelectionEnabled()) {
                this.getFileChooser().setSelectedFiles(new File[]{file});
            } else {
                this.getFileChooser().setSelectedFile(file);
            }
        }
        this.approveButton.setEnabled(filename != null);
    }

    public String getFileName() {
        return this.filename;
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser fc) {
        return ALL_FILEFILTER;
    }

    private static class AllFileFilter
    extends FileFilter {
        private AllFileFilter() {
        }

        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return "";
        }
    }

    class DirectoryNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -5338193231571179409L;

        public DirectoryNodeRenderer() {
            this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            DirectoryTreeNode node = (DirectoryTreeNode)value;
            this.setText(A03SimpleFileChooserUI.this.getFileChooser().getName(node.getFile()));
            this.setIcon(A03SimpleFileChooserUI.this.getSystemIcon(node.getFile()));
            return this;
        }
    }

    class DirectoryTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -1254389343396857828L;
        private File file;
        private File[] files;

        public DirectoryTreeNode(File file) {
            super(file);
            this.files = null;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isLeaf() {
            return !this.file.isDirectory();
        }

        public File[] getFiles() {
            if (this.files == null) {
                this.rescan();
            }
            return this.files;
        }

        public void rescan() {
            try {
                this.files = A03SimpleFileChooserUI.this.getFileChooser().getFileSystemView().getFiles(this.file, A03SimpleFileChooserUI.this.getFileChooser().isFileHidingEnabled());
                this.removeAllChildren();
                File[] fileArray = this.files;
                int n = this.files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        this.add(new DirectoryTreeNode(file));
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class DirectoryTreeWillExpandListener
    implements TreeWillExpandListener {
        DirectoryTreeWillExpandListener() {
        }

        public void treeWillExpand(TreeExpansionEvent e) {
            A03SimpleFileChooserUI.this.getFileChooser().setCursor(A03Constants.WAIT_CURSOR_INSTANCE);
            TreePath path = e.getPath();
            DirectoryTreeNode node = (DirectoryTreeNode)path.getLastPathComponent();
            try {
                try {
                    if (!node.isLeaf() && !node.children().hasMoreElements()) {
                        node.rescan();
                    }
                    A03SimpleFileChooserUI.this.currentNode = node;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    A03SimpleFileChooserUI.this.getFileChooser().setCursor(A03Constants.DEFAULT_CURSOR_INSTANCE);
                }
            }
            finally {
                A03SimpleFileChooserUI.this.getFileChooser().setCursor(A03Constants.DEFAULT_CURSOR_INSTANCE);
            }
        }

        public void treeWillCollapse(TreeExpansionEvent e) {
        }
    }

    class DnDTableHandler
    extends DragSourceAdapter
    implements DragGestureListener,
    DropTargetListener {
        private DragSource dragSource;
        private JTable table;

        public DnDTableHandler(JTable table) {
            this.table = table;
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(table, 2, this);
            new DropTarget(table, this);
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            StringBuilder sb = new StringBuilder();
            int[] rows = this.table.getSelectedRows();
            if (rows.length > 0) {
                int[] nArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = nArray[n2];
                    File file = A03SimpleFileChooserUI.this.getFileTableModel().getFileAt(A03SimpleFileChooserUI.this.sorter.getIndexAt(row));
                    sb.append(file.getAbsolutePath());
                    sb.append(File.pathSeparatorChar);
                    ++n2;
                }
                StringSelection ss = new StringSelection(sb.toString());
                this.dragSource.startDrag(dge, DragSource.DefaultCopyDrop, ss, this);
            }
        }

        public void dragEnter(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dte) {
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void drop(DropTargetDropEvent dtde) {
            Transferable t;
            Point mousePoint = dtde.getLocation();
            if (mousePoint != null && (t = dtde.getTransferable()).isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrop(2);
                try {
                    String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                    String[] paths = str.split(File.pathSeparator);
                    int row = this.table.rowAtPoint(mousePoint);
                    File destFile = A03SimpleFileChooserUI.this.getFileTableModel().getFileAt(A03SimpleFileChooserUI.this.sorter.getIndexAt(row));
                    if (destFile.isDirectory()) {
                        String[] stringArray = paths;
                        int n = paths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String newPath;
                            String path = stringArray[n2];
                            File file = A03SimpleFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(path);
                            boolean success = file.renameTo(new File(newPath = String.valueOf(destFile.getAbsolutePath()) + File.separatorChar + file.getName()));
                            if (!success) {
                                JOptionPane.showMessageDialog(A03SimpleFileChooserUI.this.getFileChooser(), "System Message", "Cannot move '" + path + "' file", 0);
                                break;
                            }
                            ++n2;
                        }
                        dtde.getDropTargetContext().dropComplete(true);
                        A03SimpleFileChooserUI.this.getFileChooser().setCurrentDirectory(destFile);
                    } else {
                        dtde.getDropTargetContext().dropComplete(false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dtde.getDropTargetContext().dropComplete(false);
                }
            }
        }
    }

    class DnDTreeHandler
    extends DropTarget {
        private static final long serialVersionUID = 5701314883967362981L;
        private JTree tree;

        public DnDTreeHandler(JTree tree) {
            this.tree = tree;
            new DropTarget(tree, this);
        }

        public void drop(DropTargetDropEvent dtde) {
            Point mousePoint = dtde.getLocation();
            if (mousePoint != null) {
                TreePath selPath = this.tree.getPathForLocation(mousePoint.x, mousePoint.y);
                if (selPath == null) {
                    return;
                }
                DirectoryTreeNode node = (DirectoryTreeNode)selPath.getLastPathComponent();
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dtde.acceptDrop(2);
                    try {
                        String[] paths;
                        String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                        String[] stringArray = paths = str.split(File.pathSeparator);
                        int n = paths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String newPath;
                            String path = stringArray[n2];
                            File file = A03SimpleFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(path);
                            boolean success = file.renameTo(new File(newPath = String.valueOf(node.getFile().getAbsolutePath()) + File.separatorChar + file.getName()));
                            if (!success) {
                                JOptionPane.showMessageDialog(A03SimpleFileChooserUI.this.getFileChooser(), "System Message", "Cannot move '" + path + "' file", 0);
                                break;
                            }
                            ++n2;
                        }
                        dtde.getDropTargetContext().dropComplete(true);
                        A03SimpleFileChooserUI.this.getFileChooser().setCurrentDirectory(node.getFile());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        dtde.getDropTargetContext().dropComplete(false);
                    }
                }
            }
        }
    }

    class FileTableCellRenderer
    extends A03TableCellRenderer {
        private static final long serialVersionUID = -2898644540191122620L;

        FileTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int index = A03SimpleFileChooserUI.this.sorter.getIndexAt(row);
            File file = A03SimpleFileChooserUI.this.getFileTableModel().getFileAt(index);
            Color foreground = table.getForeground();
            switch (column) {
                case 0: {
                    if (file.isDirectory()) {
                        this.setForeground(UIManager.getColor("FileChooser.directoryFileTextColor"));
                    } else if (file.isHidden()) {
                        this.setForeground(UIManager.getColor("FileChooser.hiddenFileTextColor"));
                    } else if (!file.canWrite()) {
                        this.setForeground(UIManager.getColor("FileChooser.readOnlyFileTextColor"));
                    }
                    this.setText(A03SimpleFileChooserUI.this.getFileChooser().getName(file));
                    this.setIcon(A03SimpleFileChooserUI.this.getSystemIcon(file));
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 1: {
                    this.setForeground(foreground);
                    Date date = (Date)value;
                    String text = date != null ? simpleDateTimeFormat.format(date) : "";
                    this.setText(text);
                    this.setIcon(null);
                    this.setHorizontalAlignment(0);
                    break;
                }
                default: {
                    this.setIcon(null);
                    this.setHorizontalAlignment(2);
                }
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileTableModel
    extends AbstractTableModel
    implements DocumentListener {
        private static final long serialVersionUID = -5842775978156316657L;
        String[] columnNames;
        List<File> filteredList;
        FileFilter currentFilter;

        public FileTableModel() {
            this.columnNames = new String[]{UIManager.getString((Object)"FileChooser.fileNameHeaderText", A03SimpleFileChooserUI.this.locale), UIManager.getString((Object)"FileChooser.fileDateHeaderText", A03SimpleFileChooserUI.this.locale)};
            this.filteredList = new ArrayList<File>();
        }

        @Override
        public Object getValueAt(int row, int col) {
            File file = this.filteredList.get(row);
            switch (col) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return new Date(file.lastModified());
                }
            }
            return null;
        }

        public void setCurrentNode(DirectoryTreeNode currentNode) {
            File[] files;
            this.filteredList.clear();
            if (!currentNode.isRoot()) {
                this.addElement(new File(".."));
            }
            if ((files = currentNode.getFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (A03SimpleFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled()) {
                        if (file.isDirectory()) {
                            this.addElement(file);
                        }
                    } else {
                        this.addElement(file);
                    }
                    ++n2;
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.filteredList.size();
        }

        public void addElement(File element) {
            this.filteredList.add(element);
        }

        public File getFileAt(int index) {
            return this.filteredList.get(index);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 1: {
                    return Date.class;
                }
            }
            return String.class;
        }

        public void selectIfPossible(File file) {
            int i = 0;
            while (i < this.filteredList.size()) {
                File filteredFile = this.filteredList.get(A03SimpleFileChooserUI.this.sorter.getIndexAt(i));
                if (filteredFile.getAbsolutePath().equals(file.getAbsolutePath())) {
                    JTable table = A03SimpleFileChooserUI.this.getFileTable();
                    table.getSelectionModel().setSelectionInterval(i, i);
                    break;
                }
                ++i;
            }
        }
    }

    class ListSelectionListenerImpl
    implements ListSelectionListener {
        ListSelectionListenerImpl() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && !A03SimpleFileChooserUI.this.fileSelectionsIsAdjusting) {
                JTable target = A03SimpleFileChooserUI.this.getFileTable();
                File[] selectedFiles = A03SimpleFileChooserUI.this.getSelectedFiles(target);
                if (selectedFiles.length > 0) {
                    ArrayList<File> files = new ArrayList<File>();
                    File[] fileArray = selectedFiles;
                    int n = selectedFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File selectedFile = fileArray[n2];
                        if (A03SimpleFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled() && selectedFile.isDirectory() || !A03SimpleFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled() && !selectedFile.isDirectory()) {
                            files.add(selectedFile);
                        }
                        ++n2;
                    }
                    if (files.isEmpty()) {
                        if (A03SimpleFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                            A03SimpleFileChooserUI.this.getFileChooser().setSelectedFiles(new File[0]);
                        } else {
                            A03SimpleFileChooserUI.this.getFileChooser().setSelectedFile(null);
                        }
                    } else if (files.size() == 1) {
                        if (A03SimpleFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                            A03SimpleFileChooserUI.this.getFileChooser().setSelectedFiles(files.toArray(new File[1]));
                        } else {
                            A03SimpleFileChooserUI.this.getFileChooser().setSelectedFile((File)files.get(0));
                        }
                    } else if (files.size() > 1) {
                        A03SimpleFileChooserUI.this.getFileChooser().setSelectedFiles(files.toArray(new File[files.size()]));
                    }
                } else if (!A03SimpleFileChooserUI.this.filePathSelectionIsAdjusting) {
                    A03SimpleFileChooserUI.this.getFileChooser().setSelectedFile(null);
                }
                A03SimpleFileChooserUI.this.approveButton.setEnabled(A03SimpleFileChooserUI.this.getFileChooser().getSelectedFile() != null);
            }
        }
    }

    class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        PropertyChangeListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("directoryChanged")) {
                File currentDirectory = (File)e.getNewValue();
                A03SimpleFileChooserUI.this.currentNode = A03SimpleFileChooserUI.this.getDirectoryTreeNode(currentDirectory);
                TreePath path = new TreePath(A03SimpleFileChooserUI.this.currentNode.getPath());
                A03SimpleFileChooserUI.this.getDirectoryTree().expandPath(path);
                if (!A03SimpleFileChooserUI.this.directoryTreeSelectionIsAdjusting) {
                    A03SimpleFileChooserUI.this.getDirectoryTree().setSelectionPath(path);
                }
                A03SimpleFileChooserUI.this.updateDetails();
            } else if (name.equals("AccessoryChangedProperty")) {
                A03SimpleFileChooserUI.this.accessoryContainer.removeAll();
                JComponent accessory = (JComponent)e.getNewValue();
                A03SimpleFileChooserUI.this.accessoryContainer.add((Component)accessory, "Center");
            } else if (name.equals("SelectedFileChangedProperty")) {
                A03SimpleFileChooserUI.this.fileSelectionsIsAdjusting = true;
                File file = (File)e.getNewValue();
                if (file != null) {
                    A03SimpleFileChooserUI.this.getFileTableModel().selectIfPossible(file);
                }
                String filename = file != null ? file.getAbsolutePath() : null;
                A03SimpleFileChooserUI.this.setFileName(filename);
                A03SimpleFileChooserUI.this.fileSelectionsIsAdjusting = false;
            } else if (name.equals("DialogTypeChangedProperty")) {
                A03SimpleFileChooserUI.this.approveButton.setText(A03SimpleFileChooserUI.this.getApproveButtonText(A03SimpleFileChooserUI.this.getFileChooser()));
                A03SimpleFileChooserUI.this.approveButton.setToolTipText(A03SimpleFileChooserUI.this.getApproveButtonToolTipText(A03SimpleFileChooserUI.this.getFileChooser()));
            } else if (name.equals("SelectedFilesChangedProperty")) {
                A03SimpleFileChooserUI.this.fileSelectionsIsAdjusting = true;
                StringBuffer sb = new StringBuffer();
                File[] files = (File[])e.getNewValue();
                if (files.length > 0) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (sb.length() > 0) {
                            sb.append(File.pathSeparatorChar);
                        }
                        sb.append(file.getAbsolutePath());
                        A03SimpleFileChooserUI.this.getFileTableModel().selectIfPossible(file);
                        ++n2;
                    }
                }
                A03SimpleFileChooserUI.this.setFileName(sb.toString());
                A03SimpleFileChooserUI.this.fileSelectionsIsAdjusting = false;
            } else if (name.equals("fileSelectionChanged")) {
                int selectionMode = (Integer)e.getNewValue();
                A03SimpleFileChooserUI.this.getFileTable().getSelectionModel().setSelectionMode(selectionMode);
            } else if (name.equals("ApproveButtonTextChangedProperty")) {
                A03SimpleFileChooserUI.this.approveButton.setText((String)e.getNewValue());
            } else if (name.equals("ApproveButtonToolTipTextChangedProperty")) {
                A03SimpleFileChooserUI.this.approveButton.setToolTipText((String)e.getNewValue());
            } else if (name.equals("ControlButtonsAreShownChangedProperty")) {
                boolean shown = (Boolean)e.getNewValue();
                A03SimpleFileChooserUI.this.approveButton.setVisible(shown);
                A03SimpleFileChooserUI.this.cancelButton.setVisible(false);
            } else if (name.equals("componentOrientation")) {
                ComponentOrientation orientation = (ComponentOrientation)e.getNewValue();
                if (orientation != (ComponentOrientation)e.getOldValue()) {
                    A03SimpleFileChooserUI.this.getFileChooser().applyComponentOrientation(orientation);
                }
            } else if (name.equals("ancestor")) {
                A03SimpleFileChooserUI.this.getDirectoryTreeModel().reload();
            }
        }
    }
}

