/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.widget.A03ColorPicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.MaskFormatter;

public class A03RGBColorChooserPanel
extends AbstractColorChooserPanel {
    private static final long serialVersionUID = -1719071802717162681L;
    protected JColorChooser chooser;
    protected ColorPalettePanel colorPalettePanel;
    protected ColorPaletteLabelPanel colorPaletteLabelPanel;
    protected JSlider slider;
    protected JRadioButton rbRadioButton;
    protected JRadioButton gbRadioButton;
    protected JRadioButton grRadioButton;
    private JSpinner redSpinner;
    private JSpinner greenSpinner;
    private JSpinner blueSpinner;
    private JFormattedTextField hexField;
    private JPanel previewContainer;

    public A03RGBColorChooserPanel(JColorChooser chooser) {
        this.chooser = chooser;
        ButtonGroup bg = new ButtonGroup();
        ChangeListener radioListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                A03RGBColorChooserPanel.this.colorPalettePanel.buildImage();
                A03RGBColorChooserPanel.this.colorPaletteLabelPanel.buildImage();
                Color color = A03RGBColorChooserPanel.this.getColorSelectionModel().getSelectedColor();
                int red = color.getRed();
                int green = color.getGreen();
                int blue = color.getBlue();
                int mask = (A03RGBColorChooserPanel.this.rbRadioButton.isSelected() ? 1 : 0) << 2 | (A03RGBColorChooserPanel.this.gbRadioButton.isSelected() ? 1 : 0) << 1 | (A03RGBColorChooserPanel.this.grRadioButton.isSelected() ? 1 : 0);
                if ((mask & 1) != 0) {
                    A03RGBColorChooserPanel.this.slider.setValue(blue);
                } else if ((mask & 2) != 0) {
                    A03RGBColorChooserPanel.this.slider.setValue(red);
                } else {
                    A03RGBColorChooserPanel.this.slider.setValue(green);
                }
                A03RGBColorChooserPanel.this.colorPalettePanel.setSelectedColor(color);
                A03RGBColorChooserPanel.this.colorPalettePanel.repaint();
                A03RGBColorChooserPanel.this.colorPaletteLabelPanel.repaint();
            }
        };
        this.rbRadioButton = new JRadioButton("RB");
        this.rbRadioButton.setSelected(true);
        this.rbRadioButton.addChangeListener(radioListener);
        bg.add(this.rbRadioButton);
        this.gbRadioButton = new JRadioButton("GB");
        this.gbRadioButton.addChangeListener(radioListener);
        bg.add(this.gbRadioButton);
        this.grRadioButton = new JRadioButton("GR");
        this.grRadioButton.addChangeListener(radioListener);
        bg.add(this.grRadioButton);
        this.slider = new JSlider(1, 0, 255, 0);
    }

    protected JComponent buildSliderPalettePanel() {
        this.slider.setInverted(true);
        this.slider.setPaintTrack(false);
        this.slider.setFocusable(false);
        this.slider.setPreferredSize(new Dimension(this.slider.getPreferredSize().width, 270));
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                A03RGBColorChooserPanel.this.colorPalettePanel.buildImage();
                A03RGBColorChooserPanel.this.colorPaletteLabelPanel.buildImage();
                int mask = (A03RGBColorChooserPanel.this.rbRadioButton.isSelected() ? 1 : 0) << 2 | (A03RGBColorChooserPanel.this.gbRadioButton.isSelected() ? 1 : 0) << 1 | (A03RGBColorChooserPanel.this.grRadioButton.isSelected() ? 1 : 0);
                int sliderValue = A03RGBColorChooserPanel.this.slider.getValue();
                Color color = A03RGBColorChooserPanel.this.getColorSelectionModel().getSelectedColor();
                int red = color.getRed();
                int green = color.getGreen();
                int blue = color.getBlue();
                if ((mask & 1) != 0) {
                    blue = sliderValue;
                } else if ((mask & 2) != 0) {
                    red = sliderValue;
                } else {
                    green = sliderValue;
                }
                Color newColor = new Color(red, green, blue);
                A03RGBColorChooserPanel.this.getColorSelectionModel().setSelectedColor(newColor);
            }
        });
        this.slider.setInheritsPopupMenu(true);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.setBorder(new EmptyBorder(30, 0, 0, 0));
        panel.add(this.slider);
        this.colorPaletteLabelPanel = new ColorPaletteLabelPanel();
        panel.add(this.colorPaletteLabelPanel);
        return panel;
    }

    protected void buildChooser() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new EmptyBorder(0, 3, 0, 4));
        this.colorPalettePanel = new ColorPalettePanel();
        JPanel panel = new JPanel();
        FlowLayout layout = new FlowLayout();
        panel.setLayout(layout);
        panel.add(this.rbRadioButton);
        panel.add(this.gbRadioButton);
        panel.add(this.grRadioButton);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add(panel);
        panel2.add(this.colorPalettePanel);
        this.add(panel2);
        this.add(this.buildSliderPalettePanel());
        JPanel panel3 = new JPanel();
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.fill = 3;
        gridBagConstraints8.gridy = 5;
        gridBagConstraints8.weightx = 0.01;
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints8.anchor = 17;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridy = 5;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.weightx = 0.1;
        gridBagConstraints7.insets = new Insets(12, 0, 0, 3);
        JLabel hexLabel = new JLabel();
        hexLabel.setText("#");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 3;
        gridBagConstraints6.gridy = 4;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(3, 0, 0, 0);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.weightx = 0.1;
        gridBagConstraints5.gridy = 4;
        gridBagConstraints5.insets = new Insets(3, 0, 0, 3);
        JLabel blueLabel = new JLabel();
        blueLabel.setText("B");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 3;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(3, 0, 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.weightx = 0.1;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.insets = new Insets(3, 0, 0, 3);
        JLabel greenLabel = new JLabel();
        greenLabel.setText("G");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weightx = 0.1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 3);
        JLabel redLabel = new JLabel();
        redLabel.setText("R");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        GridBagConstraints gridBagConstraintsColorPicker = new GridBagConstraints();
        gridBagConstraintsColorPicker.gridx = 0;
        gridBagConstraintsColorPicker.weightx = 1.0;
        gridBagConstraintsColorPicker.gridy = 0;
        gridBagConstraintsColorPicker.fill = 2;
        gridBagConstraintsColorPicker.gridwidth = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraintsColorPicker.insets = new Insets(0, 1, 12, 0);
        this.redSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.redSpinner.setName("spinnerRed");
        this.redSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Color color = A03RGBColorChooserPanel.this.getColorSelectionModel().getSelectedColor();
                Color newColor = new Color((Integer)A03RGBColorChooserPanel.this.redSpinner.getValue(), color.getGreen(), color.getBlue());
                A03RGBColorChooserPanel.this.getColorSelectionModel().setSelectedColor(newColor);
            }
        });
        this.redSpinner.setInheritsPopupMenu(true);
        this.greenSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.greenSpinner.setName("spinnerGreen");
        this.greenSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Color color = A03RGBColorChooserPanel.this.getColorSelectionModel().getSelectedColor();
                Color newColor = new Color(color.getRed(), (Integer)A03RGBColorChooserPanel.this.greenSpinner.getValue(), color.getBlue());
                A03RGBColorChooserPanel.this.getColorSelectionModel().setSelectedColor(newColor);
            }
        });
        this.greenSpinner.setInheritsPopupMenu(true);
        this.blueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.blueSpinner.setName("spinnerBlue");
        this.blueSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Color color = A03RGBColorChooserPanel.this.getColorSelectionModel().getSelectedColor();
                Color newColor = new Color(color.getRed(), color.getGreen(), (Integer)A03RGBColorChooserPanel.this.blueSpinner.getValue());
                A03RGBColorChooserPanel.this.getColorSelectionModel().setSelectedColor(newColor);
            }
        });
        this.blueSpinner.setInheritsPopupMenu(true);
        try {
            MaskFormatter mf = new MaskFormatter("HHHHHH");
            this.hexField = new JFormattedTextField(mf);
            this.hexField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        Color newColor = Color.decode("#" + A03RGBColorChooserPanel.this.hexField.getText());
                        A03RGBColorChooserPanel.this.getColorSelectionModel().setSelectedColor(newColor);
                    }
                }
            });
            this.hexField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    Color newColor = Color.decode("#" + A03RGBColorChooserPanel.this.hexField.getText());
                    A03RGBColorChooserPanel.this.getColorSelectionModel().setSelectedColor(newColor);
                }
            });
            this.hexField.setPreferredSize(new Dimension(60, 19));
        }
        catch (ParseException mf) {
            // empty catch block
        }
        panel3.setLayout(new GridBagLayout());
        A03ColorPicker colorPicker = new A03ColorPicker(this.chooser);
        panel3.add((Component)colorPicker, gridBagConstraintsColorPicker);
        panel3.add((Component)this.previewContainer, gridBagConstraints);
        panel3.add((Component)redLabel, gridBagConstraints1);
        panel3.add((Component)this.redSpinner, gridBagConstraints2);
        panel3.add((Component)greenLabel, gridBagConstraints3);
        panel3.add((Component)this.greenSpinner, gridBagConstraints4);
        panel3.add((Component)blueLabel, gridBagConstraints5);
        panel3.add((Component)this.blueSpinner, gridBagConstraints6);
        panel3.add((Component)hexLabel, gridBagConstraints7);
        panel3.add((Component)this.hexField, gridBagConstraints8);
        this.add(panel3);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                A03RGBColorChooserPanel.this.updateControls();
            }
        };
        this.getColorSelectionModel().addChangeListener(changeListener);
        this.updateControls();
    }

    private void updateControls() {
        Color color = this.getColorSelectionModel().getSelectedColor();
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        this.redSpinner.setValue(red);
        this.greenSpinner.setValue(green);
        this.blueSpinner.setValue(blue);
        String hex = A03GraphicsUtilities.toHexString(color).substring(1);
        this.hexField.setText(hex);
        int mask = (this.rbRadioButton.isSelected() ? 1 : 0) << 2 | (this.gbRadioButton.isSelected() ? 1 : 0) << 1 | (this.grRadioButton.isSelected() ? 1 : 0);
        if ((mask & 1) != 0) {
            this.slider.setValue(blue);
        } else if ((mask & 2) != 0) {
            this.slider.setValue(red);
        } else {
            this.slider.setValue(green);
        }
        this.colorPalettePanel.setSelectedColor(color);
        this.colorPalettePanel.repaint();
        this.colorPaletteLabelPanel.repaint();
    }

    public String getDisplayName() {
        return "RGB";
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public void updateChooser() {
    }

    public void setPreviewContainer(JPanel previewContainer) {
        this.previewContainer = previewContainer;
    }

    class ColorPaletteLabelPanel
    extends JPanel {
        private static final long serialVersionUID = -1557051113988990668L;
        private Image img;

        public ColorPaletteLabelPanel() {
            this.buildImage();
        }

        private void buildImage() {
            int w = 20;
            int h = 256;
            int[] pix = new int[5120];
            int index = 0;
            int mask = (A03RGBColorChooserPanel.this.rbRadioButton.isSelected() ? 1 : 0) << 2 | (A03RGBColorChooserPanel.this.gbRadioButton.isSelected() ? 1 : 0) << 1 | (A03RGBColorChooserPanel.this.grRadioButton.isSelected() ? 1 : 0);
            int red = 0;
            int green = 0;
            int blue = 0;
            int y = 0;
            while (y < 256) {
                if ((mask & 1) != 0) {
                    blue = y;
                } else if ((mask & 2) != 0) {
                    red = y;
                } else {
                    green = y;
                }
                int x = 0;
                while (x < 20) {
                    pix[index++] = 0xFF000000 | red << 16 | green << 8 | blue;
                    ++x;
                }
                ++y;
            }
            this.img = this.createImage(new MemoryImageSource(w, h, pix, 0, w));
        }

        public Dimension getPreferredSize() {
            return new Dimension(24, 260);
        }

        protected void paintComponent(Graphics g) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.img, 2, 2, this);
            graphics.dispose();
        }
    }

    class ColorPalettePanel
    extends JPanel {
        private static final long serialVersionUID = 8268147385458917437L;
        private Image img;
        private Point selectedLocation = new Point();

        public ColorPalettePanel() {
            this.buildImage();
            this.addMouseMotionListener(new MouseMotionListener(){

                public void mouseDragged(MouseEvent e) {
                    ColorPalettePanel.this.setSelectedLocation(e.getPoint());
                }

                public void mouseMoved(MouseEvent e) {
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ColorPalettePanel.this.setSelectedLocation(e.getPoint());
                }
            });
        }

        protected void buildImage() {
            int[] pix = new int[65536];
            int index = 0;
            int red = 0;
            int green = 0;
            int blue = 0;
            int mask = (A03RGBColorChooserPanel.this.rbRadioButton.isSelected() ? 1 : 0) << 2 | (A03RGBColorChooserPanel.this.gbRadioButton.isSelected() ? 1 : 0) << 1 | (A03RGBColorChooserPanel.this.grRadioButton.isSelected() ? 1 : 0);
            int sliderValue = A03RGBColorChooserPanel.this.slider.getValue();
            if ((mask & 1) != 0) {
                blue = sliderValue;
            } else if ((mask & 2) != 0) {
                red = sliderValue;
            } else {
                green = sliderValue;
            }
            int y = 0;
            while (y < 256) {
                if ((mask & 3) != 0) {
                    green = y;
                } else if ((mask & 4) != 0) {
                    red = y;
                }
                int x = 0;
                while (x < 256) {
                    if ((mask & 1) != 0) {
                        red = x;
                    } else if ((mask & 6) != 0) {
                        blue = x;
                    }
                    pix[index++] = 0xFF000000 | red << 16 | green << 8 | blue;
                    ++x;
                }
                ++y;
            }
            this.img = this.createImage(new MemoryImageSource(256, 256, pix, 0, 256));
        }

        public Dimension getPreferredSize() {
            return new Dimension(262, 262);
        }

        protected void paintComponent(Graphics g) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.img, 3, 3, this);
            graphics.setColor(Color.WHITE);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawOval(this.selectedLocation.x, this.selectedLocation.y, 6, 6);
            graphics.dispose();
        }

        public Point getSelectedLocation() {
            return this.selectedLocation;
        }

        public void setSelectedLocation(Point loc) {
            int green;
            int blue;
            int red;
            this.selectedLocation = loc;
            int mask = (A03RGBColorChooserPanel.this.rbRadioButton.isSelected() ? 1 : 0) << 2 | (A03RGBColorChooserPanel.this.gbRadioButton.isSelected() ? 1 : 0) << 1 | (A03RGBColorChooserPanel.this.grRadioButton.isSelected() ? 1 : 0);
            int sliderValue = A03RGBColorChooserPanel.this.slider.getValue();
            int yComponent = loc.y;
            int xComponent = loc.x;
            if (xComponent < 0) {
                xComponent = 0;
            } else if (xComponent > 255) {
                xComponent = 255;
            }
            if (yComponent < 0) {
                yComponent = 0;
            } else if (yComponent > 255) {
                yComponent = 255;
            }
            if ((mask & 1) != 0) {
                red = xComponent;
                blue = sliderValue;
                green = yComponent;
            } else if ((mask & 2) != 0) {
                red = sliderValue;
                blue = xComponent;
                green = yComponent;
            } else {
                red = yComponent;
                blue = xComponent;
                green = sliderValue;
            }
            Color newColor = new Color(red, green, blue);
            A03RGBColorChooserPanel.this.getColorSelectionModel().setSelectedColor(newColor);
        }

        public void setSelectedColor(Color color) {
            int mask = (A03RGBColorChooserPanel.this.rbRadioButton.isSelected() ? 1 : 0) << 2 | (A03RGBColorChooserPanel.this.gbRadioButton.isSelected() ? 1 : 0) << 1 | (A03RGBColorChooserPanel.this.grRadioButton.isSelected() ? 1 : 0);
            if ((mask & 1) != 0) {
                this.selectedLocation.x = color.getRed();
                this.selectedLocation.y = color.getGreen();
            } else if ((mask & 2) != 0) {
                this.selectedLocation.x = color.getBlue();
                this.selectedLocation.y = color.getGreen();
            } else {
                this.selectedLocation.x = color.getBlue();
                this.selectedLocation.y = color.getRed();
            }
        }
    }
}

