/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03InternalFrameDelegate;
import a03.swing.plaf.A03SwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class A03InternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private static final long serialVersionUID = -5946085458048351590L;
    private static final int TITLE_HGAP = 3;
    private Handler handler;
    private A03InternalFrameDelegate delegate = (A03InternalFrameDelegate)UIManager.get("InternalFrame.delegate");

    public A03InternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    protected void createActions() {
        super.createActions();
        this.maximizeAction.putValue("SmallIcon", UIManager.getIcon("InternalFrame.maximizeIcon"));
        this.iconifyAction.putValue("SmallIcon", UIManager.getIcon("InternalFrame.iconifyIcon"));
        this.closeAction.putValue("SmallIcon", UIManager.getIcon("InternalFrame.closeIcon"));
        this.restoreAction.putValue("SmallIcon", UIManager.getIcon("InternalFrame.minimizeIcon"));
    }

    protected void paintTitleBackground(Graphics g) {
        this.delegate.paintTitleBackground(this.frame, g);
    }

    protected void createButtons() {
        super.createButtons();
        this.iconButton.setBorderPainted(false);
        this.iconButton.setContentAreaFilled(false);
        this.maxButton.setBorderPainted(false);
        this.maxButton.setContentAreaFilled(false);
        this.closeButton.setBorderPainted(false);
        this.closeButton.setContentAreaFilled(false);
    }

    public void paintComponent(Graphics g) {
        this.paintTitleBackground(g);
        if (this.frame.getTitle() != null) {
            int titleX;
            FontMetrics fm = this.frame.getFontMetrics(g.getFont());
            int titleY = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                bounds = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                bounds = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                bounds = this.closeButton.getBounds();
            }
            String title = this.frame.getTitle();
            if (A03SwingUtilities.isLeftToRight(this.frame)) {
                if (bounds.x == 0) {
                    bounds.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                titleX = this.menuBar.getX() + 3 + this.menuBar.getWidth();
                int titleW = bounds.x - titleX - 3;
                title = this.getTitle(this.frame.getTitle(), fm, titleW);
            } else {
                int endX = this.menuBar.getX() - 3;
                int titleW = endX - bounds.x - bounds.width - 3;
                title = this.getTitle(this.frame.getTitle(), fm, titleW);
                titleX = endX - A03GraphicsUtilities.stringWidth(fm, title);
            }
            this.delegate.paintTitleText(this, g, title, titleX, titleY);
        }
    }

    JInternalFrame getFrame() {
        return this.frame;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayout() {
        return this.getHandler();
    }

    public void paint(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        A03GraphicsUtilities.installDesktopHints(graphics);
        super.paint(graphics);
        graphics.dispose();
    }

    private class Handler
    implements LayoutManager,
    PropertyChangeListener {
        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop == "selected") {
                A03InternalFrameTitlePane.this.repaint();
                return;
            }
            if (prop == "icon" || prop == "maximum") {
                A03InternalFrameTitlePane.this.setButtonIcons();
                A03InternalFrameTitlePane.this.enableActions();
                return;
            }
            if ("closable" == prop) {
                if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                    A03InternalFrameTitlePane.this.add(A03InternalFrameTitlePane.this.closeButton);
                } else {
                    A03InternalFrameTitlePane.this.remove(A03InternalFrameTitlePane.this.closeButton);
                }
            } else if ("maximizable" == prop) {
                if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                    A03InternalFrameTitlePane.this.add(A03InternalFrameTitlePane.this.maxButton);
                } else {
                    A03InternalFrameTitlePane.this.remove(A03InternalFrameTitlePane.this.maxButton);
                }
            } else if ("iconable" == prop) {
                if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                    A03InternalFrameTitlePane.this.add(A03InternalFrameTitlePane.this.iconButton);
                } else {
                    A03InternalFrameTitlePane.this.remove(A03InternalFrameTitlePane.this.iconButton);
                }
            }
            A03InternalFrameTitlePane.this.enableActions();
            A03InternalFrameTitlePane.this.revalidate();
            A03InternalFrameTitlePane.this.repaint();
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 22;
            if (A03InternalFrameTitlePane.this.frame.isClosable()) {
                width += 19;
            }
            if (A03InternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 19;
            }
            if (A03InternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 19;
            }
            FontMetrics fm = A03InternalFrameTitlePane.this.frame.getFontMetrics(A03InternalFrameTitlePane.this.getFont());
            String frameTitle = A03InternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = fm.stringWidth(String.valueOf(frameTitle.substring(0, 3)) + "...")) ? title_w : subtitle_w) : (width += title_w);
            Icon icon = A03InternalFrameTitlePane.this.frame.getFrameIcon();
            int fontHeight = fm.getHeight();
            fontHeight += 2;
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            int height = Math.max(fontHeight, iconHeight += 4);
            Dimension dim = new Dimension(width, height);
            if (A03InternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = A03InternalFrameTitlePane.this.getBorder().getBorderInsets(c);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }

        public void layoutContainer(Container c) {
            boolean leftToRight = A03SwingUtilities.isLeftToRight(A03InternalFrameTitlePane.this.frame);
            int w = A03InternalFrameTitlePane.this.getWidth();
            int h = A03InternalFrameTitlePane.this.getHeight();
            int buttonHeight = A03InternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            Icon icon = A03InternalFrameTitlePane.this.frame.getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = icon.getIconHeight();
            }
            int x = leftToRight ? 2 : w - 16 - 2;
            A03InternalFrameTitlePane.this.menuBar.setBounds(x, (h - iconHeight) / 2, 16, 16);
            int n = x = leftToRight ? w - 16 - 2 : 2;
            if (A03InternalFrameTitlePane.this.frame.isClosable()) {
                A03InternalFrameTitlePane.this.closeButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (A03InternalFrameTitlePane.this.frame.isMaximizable()) {
                A03InternalFrameTitlePane.this.maxButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (A03InternalFrameTitlePane.this.frame.isIconifiable()) {
                A03InternalFrameTitlePane.this.iconButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            A03InternalFrameTitlePane.this.getHandler().propertyChange(evt);
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
            A03InternalFrameTitlePane.this.getHandler().addLayoutComponent(name, c);
        }

        public void removeLayoutComponent(Component c) {
            A03InternalFrameTitlePane.this.getHandler().removeLayoutComponent(c);
        }

        public Dimension preferredLayoutSize(Container c) {
            return A03InternalFrameTitlePane.this.getHandler().preferredLayoutSize(c);
        }

        public Dimension minimumLayoutSize(Container c) {
            return A03InternalFrameTitlePane.this.getHandler().minimumLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            A03InternalFrameTitlePane.this.getHandler().layoutContainer(c);
        }
    }
}

