/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterGraphics;
import java.text.Bidi;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import thirdparty.org.apache.batik.ext.awt.LinearGradientPaint;

public class A03GraphicsUtilities {
    public static Map<?, ?> desktopHints;
    static final int CHAR_BUFFER_SIZE = 256;
    public static char[] charsBuffer;
    public static final Object charsBufferLock;
    private static final String PROP_DESKTOPHINTS = "awt.font.desktophints";
    static Map<Long, Image> cachedImages;

    static {
        charsBuffer = new char[256];
        charsBufferLock = new Object();
        cachedImages = new HashMap<Long, Image>();
    }

    private static Map getDesktopHints(Graphics2D graphics) {
        if (A03GraphicsUtilities.isPrinting(graphics)) {
            return null;
        }
        if (desktopHints == null) {
            Object aaHint;
            GraphicsDevice device;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            desktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints." + (device = graphics.getDeviceConfiguration().getDevice()).getIDstring());
            if (desktopHints == null) {
                desktopHints = (Map)toolkit.getDesktopProperty(PROP_DESKTOPHINTS);
            }
            if (desktopHints != null && ((aaHint = desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT)) {
                desktopHints = null;
            }
        }
        return desktopHints;
    }

    private static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    public static void installDesktopHints(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        Map desktopHints = A03GraphicsUtilities.getDesktopHints(graphics);
        if (desktopHints != null && !desktopHints.isEmpty()) {
            graphics.addRenderingHints(desktopHints);
        }
    }

    public static String toHexString(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        String hex = "#";
        if (red < 16) {
            hex = String.valueOf(hex) + "0";
        }
        hex = String.valueOf(hex) + Integer.toHexString(red);
        if (green < 16) {
            hex = String.valueOf(hex) + "0";
        }
        hex = String.valueOf(hex) + Integer.toHexString(green);
        if (blue < 16) {
            hex = String.valueOf(hex) + "0";
        }
        hex = String.valueOf(hex) + Integer.toHexString(blue);
        return hex;
    }

    public static int stringWidth(FontMetrics fm, String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        return fm.stringWidth(string);
    }

    public static Color createColor(Color startColor, Color endColor, double fadeLevel) {
        if (fadeLevel == 0.0) {
            return startColor;
        }
        if (fadeLevel == 1.0) {
            return endColor;
        }
        int red = (int)((double)(endColor.getRed() - startColor.getRed()) * fadeLevel + (double)startColor.getRed());
        if (red > 255) {
            red = 255;
        } else if (red < 0) {
            red = 0;
        }
        int green = (int)((double)(endColor.getGreen() - startColor.getGreen()) * fadeLevel + (double)startColor.getGreen());
        if (green > 255) {
            green = 255;
        } else if (green < 0) {
            green = 0;
        }
        int blue = (int)((double)(endColor.getBlue() - startColor.getBlue()) * fadeLevel + (double)startColor.getBlue());
        if (blue > 255) {
            blue = 255;
        } else if (blue < 0) {
            blue = 0;
        }
        int alpha = endColor.getAlpha();
        if (alpha > 255) {
            alpha = 255;
        } else if (alpha < 0) {
            alpha = 0;
        }
        return new Color(red, green, blue, alpha);
    }

    public static Color createAlphaColor(Color color, int alpha) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return new Color(red, green, blue, alpha);
    }

    public static String clipString(FontMetrics fm, int width, String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        int strWidth = 0;
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            builder.append(ch);
            if ((strWidth += fm.charWidth(ch)) >= width) break;
            ++n2;
        }
        return builder.toString();
    }

    public static Color createColor(Color color, double factor) {
        int red = color.getRed();
        if ((red = (int)((double)red * factor)) > 255) {
            red = 255;
        } else if (red < 0) {
            red = 0;
        }
        int green = color.getGreen();
        green = (int)((double)green * factor);
        if (green > 255) {
            green = 255;
        } else if (green < 0) {
            green = 0;
        }
        int blue = color.getBlue();
        blue = (int)((double)blue * factor);
        if (blue > 255) {
            blue = 255;
        } else if (blue < 0) {
            blue = 0;
        }
        return new Color(red, green, blue, color.getAlpha());
    }

    public static Color[] revertColors(Color[] colors) {
        Color[] reverted = new Color[colors.length];
        int i = 0;
        while (i < colors.length) {
            reverted[i] = colors[colors.length - i - 1];
            ++i;
        }
        return reverted;
    }

    public static float[] revertFractions(float[] fractions) {
        float[] reverted = new float[fractions.length];
        int i = 0;
        while (i < reverted.length) {
            reverted[i] = 1.0f - fractions[fractions.length - i - 1];
            ++i;
        }
        return reverted;
    }

    public static Paint createLinearGradientPaint(float startX, float startY, float endX, float endY, float[] fractions, Color[] colors) {
        return new LinearGradientPaint(startX, startY, endX, endY, fractions, colors);
    }

    public static final boolean isComplexLayout(char[] text, int start, int limit) {
        boolean simpleLayout = true;
        int i = start;
        while (i < limit) {
            char ch = text[i];
            if (A03GraphicsUtilities.isComplexLayout(ch)) {
                return true;
            }
            if (simpleLayout) {
                simpleLayout = A03GraphicsUtilities.isSimpleLayout(ch);
            }
            ++i;
        }
        if (simpleLayout) {
            return false;
        }
        return Bidi.requiresBidi(text, start, limit);
    }

    public static final boolean isComplexLayout(char ch) {
        return ch >= '\u0900' && ch <= '\u0d7f' || ch >= '\u0e00' && ch <= '\u0e7f' || ch >= '\u1780' && ch <= '\u17ff' || ch >= '\ud800' && ch <= '\udfff';
    }

    public static final boolean isSimpleLayout(char ch) {
        return ch < '\u0590' || '\u2e00' <= ch && ch < '\ud800';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawStringUnderlineCharAt(Component c, Graphics g, String text, int underlinedIndex, int x, int y) {
        int textLength = text.length();
        if (text == null || textLength <= 0) {
            return;
        }
        g.drawString(text, x, y);
        if (underlinedIndex >= 0 && underlinedIndex < textLength) {
            int underlineRectY = y;
            int underlineRectHeight = 1;
            int underlineRectX = 0;
            int underlineRectWidth = 0;
            boolean needsTextLayout = false;
            if (!needsTextLayout) {
                Object object = charsBufferLock;
                synchronized (object) {
                    if (charsBuffer == null || charsBuffer.length < textLength) {
                        charsBuffer = text.toCharArray();
                    } else {
                        text.getChars(0, textLength, charsBuffer, 0);
                    }
                    needsTextLayout = A03GraphicsUtilities.isComplexLayout(charsBuffer, 0, textLength);
                }
            }
            if (!needsTextLayout) {
                FontMetrics fm = g.getFontMetrics();
                underlineRectX = x + A03GraphicsUtilities.stringWidth(fm, text.substring(0, underlinedIndex));
                underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            } else {
                Graphics2D graphics = (Graphics2D)g;
                if (graphics != null) {
                    FontRenderContext frc = graphics.getFontRenderContext();
                    TextLayout layout = new TextLayout(text, graphics.getFont(), frc);
                    TextHitInfo leading = TextHitInfo.leading(underlinedIndex);
                    TextHitInfo trailing = TextHitInfo.trailing(underlinedIndex);
                    Shape shape = layout.getVisualHighlightShape(leading, trailing);
                    Rectangle rect = shape.getBounds();
                    underlineRectX = x + rect.x;
                    underlineRectWidth = rect.width;
                }
            }
            g.fillRect(underlineRectX, underlineRectY + 1, underlineRectWidth, underlineRectHeight);
        }
    }

    public static Shape createRoundRectangle(int x, int y, int w, int h, float r) {
        if (r == 0.0f) {
            return new Rectangle(x, y, w, h);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(x + w) - r, y);
        path.quadTo(x + w, y, x + w, (float)y + r);
        path.lineTo(x + w, (float)(y + h) - r);
        path.quadTo(x + w, y + h, (float)(x + w) - r, y + h);
        path.lineTo((float)x + r, y + h);
        path.quadTo(x, y + h, x, (float)(y + h) - r);
        path.lineTo(x, (float)y + r);
        path.quadTo(x, y, (float)x + r, y);
        path.closePath();
        return path;
    }

    public static Image createImage(Component c, int width, int height) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(width, height, 3);
        return image;
    }

    public static Image getTempImage(Component c, int width, int height) {
        long hashCode = Arrays.hashCode(new int[]{width, height});
        Image image = cachedImages.get(hashCode);
        if (image == null) {
            image = A03GraphicsUtilities.createImage(c, width, height);
            cachedImages.put(hashCode, image);
        }
        return image;
    }
}

