/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03ArrowButton;
import a03.swing.plaf.A03ComboBoxDelegate;
import a03.swing.plaf.A03ComboBoxEditor;
import a03.swing.plaf.A03ListCellRenderer;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plugin.A03PluginManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import sun.swing.DefaultLookup;

public class A03ComboBoxUI
extends BasicComboBoxUI {
    private static final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListenerImpl();
    private A03ComboBoxDelegate delegate;

    public static ComponentUI createUI(JComponent c) {
        return new A03ComboBoxUI();
    }

    private void updateEditorBackgroundIfNecessary(JComboBox c) {
        if (c != null) {
            ComboBoxEditor editor;
            Color background = c.getBackground();
            if (c.isEditable() && (editor = c.getEditor()) != null) {
                editor.getEditorComponent().setBackground(background);
            }
        }
    }

    public void installUI(JComponent c) {
        this.delegate = (A03ComboBoxDelegate)A03SwingUtilities.getDelegate(c, UIManager.get("ComboBox.delegate"));
        super.installUI(c);
        A03PluginManager.getInstance().registerComponent(this.comboBox);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateEditorBackgroundIfNecessary(this.comboBox);
    }

    protected void installListeners() {
        super.installListeners();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallUI(JComponent c) {
        if (this.comboBox == null) {
            this.comboBox = new JComboBox();
        }
        if (this.popup == null) {
            this.popup = this.createPopup();
        }
        A03PluginManager.getInstance().unregisterComponent(this.comboBox);
        super.uninstallUI(c);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected JButton createArrowButton() {
        A03ArrowButton button = new A03ArrowButton(5, this.delegate);
        return button;
    }

    protected ComboPopup createPopup() {
        return new A03ComboPopup(this.comboBox);
    }

    protected ListCellRenderer createRenderer() {
        A03ListCellRenderer listCellRender = new A03ListCellRenderer();
        listCellRender.setComponentOrientation(A03SwingUtilities.isLeftToRight(this.comboBox) ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
        return listCellRender;
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintCurrentValue(graphics, r, this.hasFocus);
        }
        graphics.dispose();
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = hasFocus && !this.isPopupVisible(this.comboBox) ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c.setFont(this.comboBox.getFont());
        if (!this.comboBox.isEnabled()) {
            c.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        if (c instanceof JLabel) {
            ((JLabel)c).setHorizontalAlignment(this.comboBox.getComponentOrientation().isLeftToRight() ? 2 : 4);
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
    }

    protected Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    protected Dimension getDefaultSize() {
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = defaultListCellRenderer;
        }
        Dimension d = this.getSizeForComponent(renderer.getListCellRendererComponent(this.listBox, null, -1, true, true));
        return new Dimension(d.width, d.height);
    }

    protected ComboBoxEditor createEditor() {
        A03ComboBoxEditor.UIResource editor = new A03ComboBoxEditor.UIResource();
        Component editorComponent = editor.getEditorComponent();
        if (editorComponent instanceof JTextField) {
            ((JTextField)editorComponent).setHorizontalAlignment(this.comboBox.getComponentOrientation().isLeftToRight() ? 2 : 4);
        }
        return editor;
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    class A03ComboPopup
    extends BasicComboPopup {
        private static final long serialVersionUID = -5637107226644208855L;

        public A03ComboPopup(JComboBox combo) {
            super(combo);
        }

        protected void configurePopup() {
            super.configurePopup();
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }

        protected JScrollPane createScroller() {
            JScrollPane scrollPane = super.createScroller();
            scrollPane.setCorner("LOWER_LEFT_CORNER", null);
            scrollPane.setCorner("LOWER_RIGHT_CORNER", null);
            scrollPane.setComponentOrientation(this.comboBox.getComponentOrientation());
            return scrollPane;
        }

        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            Rectangle rect = super.computePopupBounds(px, py, pw, ph);
            ListModel model = this.list.getModel();
            ListCellRenderer renderer = this.list.getCellRenderer();
            int width = 0;
            int index = 0;
            while (index < model.getSize()) {
                Component c = renderer.getListCellRendererComponent(this.list, model.getElementAt(index), index, true, true);
                width = Math.max(width, A03ComboBoxUI.this.getSizeForComponent((Component)c).width);
                ++index;
            }
            Insets insets = this.list.getInsets();
            width += insets.left + insets.right;
            JScrollBar verticalBar = this.scroller.getVerticalScrollBar();
            if (verticalBar != null && verticalBar.isVisible()) {
                width += verticalBar.getPreferredSize().width;
            }
            rect.width = Math.max(width, this.comboBox.getBounds().width);
            return rect;
        }

        public void setVisible(boolean b) {
            this.comboBox.repaint();
            super.setVisible(b);
        }
    }

    private class ComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private ComboBoxLayoutManager() {
            super(A03ComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = A03ComboBoxUI.this.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (A03ComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    A03ComboBoxUI.this.arrowButton.setBounds(width - buttonSize - insets.right, insets.top, buttonSize, buttonSize);
                } else {
                    A03ComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonSize, buttonSize);
                }
            }
            if (A03ComboBoxUI.this.editor != null) {
                A03ComboBoxUI.this.editor.setBounds(new Rectangle(A03ComboBoxUI.this.rectangleForCurrentValue()));
            }
        }

        protected Rectangle rectangleForCurrentValue() {
            int width = A03ComboBoxUI.this.comboBox.getWidth();
            int height = A03ComboBoxUI.this.comboBox.getHeight();
            Insets insets = A03ComboBoxUI.this.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (A03ComboBoxUI.this.arrowButton != null) {
                buttonSize = A03ComboBoxUI.this.arrowButton.getWidth();
            }
            if (A03ComboBoxUI.this.comboBox.getComponentOrientation().isLeftToRight()) {
                return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize), buttonSize);
            }
            return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), buttonSize);
        }
    }

    class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        PropertyChangeListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                Color background = A03ComboBoxUI.this.comboBox.getBackground();
                if (background instanceof UIResource) {
                    if (A03ComboBoxUI.this.comboBox.isEnabled()) {
                        A03ComboBoxUI.this.comboBox.setBackground(UIManager.getColor("ComboBox.background"));
                    } else {
                        A03ComboBoxUI.this.comboBox.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                    }
                }
            } else if (evt.getPropertyName().equals("background")) {
                A03ComboBoxUI.this.updateEditorBackgroundIfNecessary(A03ComboBoxUI.this.comboBox);
            } else if (evt.getPropertyName().equals("UI")) {
                A03ComboBoxUI.this.updateEditorBackgroundIfNecessary(A03ComboBoxUI.this.comboBox);
                A03ComboBoxUI.this.popup.getList().updateUI();
            } else if (evt.getPropertyName().equals("editable") && A03ComboBoxUI.this.comboBox != null) {
                ComboBoxEditor editor;
                Color background;
                if (!A03ComboBoxUI.this.comboBox.isEnabled() && (background = A03ComboBoxUI.this.comboBox.getBackground()) instanceof UIResource) {
                    A03ComboBoxUI.this.comboBox.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                }
                if ((editor = A03ComboBoxUI.this.comboBox.getEditor()) != null) {
                    editor.getEditorComponent().setComponentOrientation(A03ComboBoxUI.this.comboBox.getComponentOrientation());
                }
                A03ComboBoxUI.this.updateEditorBackgroundIfNecessary(A03ComboBoxUI.this.comboBox);
            }
        }
    }
}

