/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import griffon.util.GriffonClassUtils;
import java.util.Set;
import javax.lang.model.element.Modifier;
import lombok.ast.AbstractMethodDecl;
import lombok.ast.WrappedMethodDecl;
import lombok.core.AST;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;
import lombok.javac.handlers.ast.JavacASTMaker;
import lombok.javac.handlers.ast.JavacType;
import lombok.javac.handlers.types.JCBooleanType;
import lombok.javac.handlers.types.JCNoType;

public class HandlerUtils {
    public static final List<JCTree.JCExpression> NIL_EXPRESSION = List.nil();

    public static JCTree.JCExpression makeType(String type, JavacNode node) {
        return HandlerUtils.makeType(type, node, node.getTreeMaker());
    }

    public static JCTree.JCExpression makeType(String type, JavacNode node, TreeMaker maker) {
        if (type.startsWith("[L")) {
            return maker.TypeArray(JavacHandlerUtil.chainDotsString((JavacNode)node, (String)type.substring(2, type.length() - 1)));
        }
        if (type.startsWith("[")) {
            return maker.TypeArray(JavacHandlerUtil.chainDotsString((JavacNode)node, (String)type.substring(1, type.length() - 1)));
        }
        if ("boolean".equals(type)) {
            return node.getTreeMaker().Type(JCBooleanType.booleanType());
        }
        return JavacHandlerUtil.chainDotsString((JavacNode)node, (String)type);
    }

    public static JavacNode findTypeNodeFrom(JavacNode node) {
        JavacNode n;
        for (n = node; n != null && !HandlerUtils.isTypeDeclaration(n); n = (JavacNode)n.up()) {
        }
        if (!HandlerUtils.isTypeDeclaration(n)) {
            return null;
        }
        return n;
    }

    public static boolean isTypeDeclaration(JavacNode node) {
        return node != null && node.get() instanceof JCTree.JCClassDecl;
    }

    public static JCTree.JCExpression thisExpression(JavacNode typeNode) {
        return typeNode.getTreeMaker().at(((JCTree)typeNode.get()).pos).Ident(typeNode.toName("this"));
    }

    public static List<JCTree.JCExpression> extractArgNames(List<JCTree.JCVariableDecl> params, TreeMaker m) {
        ListBuffer<JCTree.JCIdent> args = new ListBuffer<JCTree.JCIdent>();
        for (JCTree.JCVariableDecl param : params) {
            args.append(m.Ident(param.getName()));
        }
        return HandlerUtils.toList(args);
    }

    public static GriffonClassUtils.MethodDescriptor methodDescriptorFor(JCTree.JCMethodDecl method) {
        java.util.List parameters = method.getParameters();
        String[] parameterTypes = new String[parameters.size()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = ((JCTree.JCVariableDecl)parameters.get((int)i)).getType().type.toString();
        }
        int modifiers = HandlerUtils.toJavacModifier(method.getModifiers().getFlags());
        return new GriffonClassUtils.MethodDescriptor(method.getName().toString(), parameterTypes, modifiers);
    }

    public static boolean hasAnnotation(JavacNode node, Class annotationClass) {
        for (JavacNode child : node.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !JavacHandlerUtil.annotationTypeMatches((Class)annotationClass, (JavacNode)child)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceField(JavacNode field) {
        if (field.getKind() != AST.Kind.FIELD) {
            return false;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
        if (fieldDecl.name.toString().startsWith("$")) {
            return false;
        }
        return (fieldDecl.mods.flags & 8L) == 0L;
    }

    public static JavacNode findMethod(String methodName, JavacNode node) {
        while (node != null && !(node.get() instanceof JCTree.JCClassDecl)) {
            node = (JavacNode)node.up();
        }
        if (node != null && node.get() instanceof JCTree.JCClassDecl) {
            for (JCTree def : ((JCTree.JCClassDecl)node.get()).defs) {
                String name;
                if (!(def instanceof JCTree.JCMethodDecl) || !(name = ((JCTree.JCMethodDecl)def).name.toString()).equals(methodName)) continue;
                return (JavacNode)node.getNodeFor((Object)def);
            }
        }
        return null;
    }

    public static int toJavacModifier(JCTree.JCModifiers modifiers) {
        return HandlerUtils.toJavacModifier(modifiers.getFlags());
    }

    public static int toJavacModifier(Set<Modifier> modifiers) {
        int mods = 0;
        for (Modifier mod : modifiers) {
            switch (mod) {
                case PUBLIC: {
                    mods |= 1;
                    break;
                }
                case PROTECTED: {
                    mods |= 4;
                    break;
                }
                case PRIVATE: {
                    mods |= 2;
                    break;
                }
                case STATIC: {
                    mods |= 8;
                    break;
                }
                case ABSTRACT: {
                    mods |= 0x400;
                    break;
                }
                case FINAL: {
                    mods |= 0x10;
                    break;
                }
                case NATIVE: {
                    mods |= 0x100;
                    break;
                }
                case SYNCHRONIZED: {
                    mods |= 0x20;
                    break;
                }
                case TRANSIENT: {
                    mods |= 0x80;
                    break;
                }
                case VOLATILE: {
                    mods |= 0x40;
                    break;
                }
                case STRICTFP: {
                    mods |= 0x800;
                }
            }
        }
        return mods;
    }

    public static JavacNode getField(JavacNode node, String fieldName) {
        while (node != null && !(node.get() instanceof JCTree.JCClassDecl)) {
            node = (JavacNode)node.up();
        }
        if (node != null && node.get() instanceof JCTree.JCClassDecl) {
            for (JCTree def : ((JCTree.JCClassDecl)node.get()).defs) {
                if (!(def instanceof JCTree.JCVariableDecl) || !((JCTree.JCVariableDecl)def).name.contentEquals(fieldName)) continue;
                return (JavacNode)node.getNodeFor((Object)def);
            }
        }
        return null;
    }

    public static JCTree.JCExpression readField(JavacNode fieldNode) {
        return HandlerUtils.readField(fieldNode, null);
    }

    public static JCTree.JCExpression readField(JavacNode fieldNode, JCTree.JCExpression receiver) {
        TreeMaker maker = fieldNode.getTreeMaker();
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        if (receiver == null) {
            if ((fieldDecl.mods.flags & 8L) == 0L) {
                receiver = maker.Ident(fieldNode.toName("this"));
            } else {
                JavacNode containerNode = (JavacNode)fieldNode.up();
                if (containerNode != null && containerNode.get() instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl container = (JCTree.JCClassDecl)((JavacNode)fieldNode.up()).get();
                    receiver = maker.Ident(container.name);
                }
            }
        }
        return receiver == null ? maker.Ident(fieldDecl.name) : maker.Select(receiver, fieldDecl.name);
    }

    public static <T> List<T> toList(ListBuffer<T> collection) {
        return collection == null ? List.nil() : collection.toList();
    }

    public static JCTree.JCMethodDecl injectMethod(JavacType type, AbstractMethodDecl<?> methodDecl) {
        JavacASTMaker builder = new JavacASTMaker(type.node(), (JCTree)type.get());
        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)builder.build(methodDecl, JCTree.JCMethodDecl.class);
        JavacHandlerUtil.injectMethod((JavacNode)type.node(), (JCTree.JCMethodDecl)method);
        if (methodDecl instanceof WrappedMethodDecl) {
            WrappedMethodDecl node = (WrappedMethodDecl)methodDecl;
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)node.getWrappedObject();
            JCTree.JCClassDecl tree = type.get();
            Symbol.ClassSymbol c = tree.sym;
            c.members_field.enter(methodSymbol, c.members_field, methodSymbol.enclClass().members_field);
            method.sym = methodSymbol;
        }
        return method;
    }

    public static class TokenBuilder {
        public final JavacNode context;

        public TokenBuilder(JavacNode context) {
            this.context = context;
        }

        public JavacNode getContext() {
            return this.context;
        }

        public TreeMaker getTreeMaker() {
            return this.context.getTreeMaker();
        }

        public Name name(String name) {
            return this.context.toName(name);
        }

        public JCTree.JCModifiers mods(int mods) {
            return this.context.getTreeMaker().Modifiers(mods);
        }

        public JCTree.JCExpression type(Class clazz) {
            return this.type(clazz.getName());
        }

        public JCTree.JCExpression type(String type) {
            return JavacHandlerUtil.chainDotsString((JavacNode)this.context, (String)type);
        }

        public JCTree.JCExpression void_t() {
            return this.context.getTreeMaker().Type(JCNoType.voidType());
        }

        public JCTree.JCVariableDecl param(int modifiers, Class clazz, String identifier) {
            return this.param(modifiers, clazz.getName(), identifier);
        }

        public JCTree.JCVariableDecl param(int modifiers, String clazz, String identifier) {
            return this.context.getTreeMaker().VarDef(this.mods(modifiers), this.name(identifier), this.type(clazz), null);
        }

        public JCTree.JCExpression dotExpr(String expr) {
            return JavacHandlerUtil.chainDotsString((JavacNode)this.context, (String)expr);
        }

        public JCTree.JCMethodInvocation call(JCTree.JCExpression method) {
            return this.call(NIL_EXPRESSION, method, NIL_EXPRESSION);
        }

        public JCTree.JCMethodInvocation call(JCTree.JCExpression method, List<JCTree.JCExpression> args) {
            return this.call(NIL_EXPRESSION, method, args);
        }

        public JCTree.JCMethodInvocation call(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression method, List<JCTree.JCExpression> args) {
            return this.context.getTreeMaker().Apply(typeArgs, method, args);
        }

        public void addInterface(String interfaceName, JavacNode node) {
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)node.get();
            ListBuffer implementing = ListBuffer.lb();
            implementing.appendList(classDecl.implementing);
            implementing.append(JavacHandlerUtil.chainDotsString((JavacNode)node, (String)interfaceName));
            classDecl.implementing = implementing.toList();
        }

        public void setSuperclass(String superclassName, JavacNode node) {
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)node.get();
            classDecl.extending = this.dotExpr(superclassName);
        }

        public JCTree.JCExpression staticCallExpr(String classType, String methodName) {
            return this.staticCallExpr(classType, methodName, NIL_EXPRESSION);
        }

        public JCTree.JCExpression staticCallExpr(String classType, String methodName, List<JCTree.JCExpression> args) {
            if (args == null) {
                args = NIL_EXPRESSION;
            }
            JCTree.JCExpression expr = this.dotExpr(classType + "." + methodName);
            return this.context.getTreeMaker().Apply(NIL_EXPRESSION, expr, args);
        }

        public JCTree.JCExpression invoke(JCTree.JCExpression receiver, String methodName) {
            return this.invoke(receiver, methodName, NIL_EXPRESSION);
        }

        public JCTree.JCExpression invoke(JCTree.JCExpression receiver, String methodName, List<JCTree.JCExpression> args) {
            if (args == null) {
                args = NIL_EXPRESSION;
            }
            return this.call(this.context.getTreeMaker().Select(receiver, this.name(methodName)), args);
        }
    }
}

