/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import griffon.transform.ThreadingAware;
import groovy.lang.Closure;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import lombok.core.AnnotationValues;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.AstBuilder;
import lombok.javac.handlers.HandlerUtils;
import lombok.javac.handlers.JavacHandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleThreadingAware
extends JavacAnnotationHandler<ThreadingAware> {
    private static final Logger LOG = LoggerFactory.getLogger(HandleThreadingAware.class);
    private static final String RUNNABLE_PARAM = "runnable";
    private static final String CLOSURE_PARAM = "closure";
    private static final String CALLABLE_PARAM = "callable";
    private static final String EXECUTOR_SERVICE_PARAM = "executorService";
    private static final String EXEC_FUTURE = "execFuture";
    private static final String EXECUTE_FUTURE = "executeFuture";

    public void handle(AnnotationValues<ThreadingAware> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary((JavacNode)annotationNode, ThreadingAware.class);
        JavacNode typeNode = (JavacNode)annotationNode.up();
        switch (typeNode.getKind()) {
            case TYPE: {
                this.addThreadingHandlerSupport(typeNode);
                return;
            }
        }
        annotationNode.addError("@ThreadingHandler is legal only on types.");
    }

    private void addThreadingHandlerSupport(JavacNode typeNode) {
        HandlerUtils.TokenBuilder b = new HandlerUtils.TokenBuilder(typeNode);
        b.addInterface("griffon.core.ThreadingHandler", typeNode);
        TreeMaker m = typeNode.getTreeMaker();
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod("isUIThread").returning(Boolean.TYPE).withBody(this.bodyWithReturn("isUIThread", HandlerUtils.NIL_EXPRESSION, b)).$(typeNode));
        List<JCTree.JCVariableDecl> params = List.of(AstBuilder.defVar(RUNNABLE_PARAM).modifiers(16L).type(Runnable.class).$(typeNode));
        List<JCTree.JCExpression> args = HandlerUtils.extractArgNames(params, m);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod("execInsideUIAsync").withParams(params).withBody(this.body("executeAsync", args, b)).$(typeNode));
        params = List.of(AstBuilder.defVar(RUNNABLE_PARAM).modifiers(16L).type(Runnable.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, m);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod("execInsideUISync").withParams(params).withBody(this.body("executeSync", args, b)).$(typeNode));
        params = List.of(AstBuilder.defVar(RUNNABLE_PARAM).modifiers(16L).type(Runnable.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, m);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod("execOutsideUI").withParams(params).withBody(this.body("executeOutside", args, b)).$(typeNode));
        params = List.of(AstBuilder.defVar(CLOSURE_PARAM).modifiers(16L).type(Closure.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, m);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(EXEC_FUTURE).returning(Future.class).withParams(params).withBody(this.bodyWithReturn(EXECUTE_FUTURE, args, b)).$(typeNode));
        params = List.of(AstBuilder.defVar(EXECUTOR_SERVICE_PARAM).modifiers(16L).type(ExecutorService.class).$(typeNode), AstBuilder.defVar(CLOSURE_PARAM).modifiers(16L).type(Closure.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, m);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(EXEC_FUTURE).returning(Future.class).withParams(params).withBody(this.bodyWithReturn(EXECUTE_FUTURE, args, b)).$(typeNode));
        params = List.of(AstBuilder.defVar(CALLABLE_PARAM).modifiers(16L).type(Callable.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, m);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(EXEC_FUTURE).returning(Future.class).withParams(params).withBody(this.bodyWithReturn(EXECUTE_FUTURE, args, b)).$(typeNode));
        params = List.of(AstBuilder.defVar(EXECUTOR_SERVICE_PARAM).modifiers(16L).type(ExecutorService.class).$(typeNode), AstBuilder.defVar(CALLABLE_PARAM).modifiers(16L).type(Callable.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, m);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(EXEC_FUTURE).returning(Future.class).withParams(params).withBody(this.bodyWithReturn(EXECUTE_FUTURE, args, b)).$(typeNode));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Modified " + typeNode.getName() + " as ThreadingHandler.");
        }
    }

    private List<JCTree.JCStatement> body(String methodName, List<JCTree.JCExpression> args, HandlerUtils.TokenBuilder b) {
        return List.of(b.getTreeMaker().Exec(this.invokeThreadManager(methodName, args, b)));
    }

    private List<JCTree.JCStatement> bodyWithReturn(String methodName, List<JCTree.JCExpression> args, HandlerUtils.TokenBuilder b) {
        return List.of(b.getTreeMaker().Return(this.invokeThreadManager(methodName, args, b)));
    }

    private JCTree.JCExpression invokeThreadManager(String methodName, List<JCTree.JCExpression> args, HandlerUtils.TokenBuilder b) {
        return b.invoke(b.staticCallExpr("griffon.core.UIThreadManager", "getInstance"), methodName, args);
    }
}

