/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import groovy.beans.Bindable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Modifier;
import lombok.core.AnnotationValues;
import lombok.core.util.Naming;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.AstBuilder;
import lombok.javac.handlers.HandlerUtils;
import lombok.javac.handlers.JavacHandlerUtil;
import lombok.javac.handlers.Lombok;
import lombok.javac.handlers.MemberChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleBindable
extends JavacAnnotationHandler<Bindable> {
    private static final Logger LOG = LoggerFactory.getLogger(HandleBindable.class);
    private static final String PROPERTY_SUPPORT_FIELD_NAME = "this$propertyChangeSupport";
    private static final String NAME_PARAM = "name";
    private static final String LISTENER_PARAM = "listener";
    private static final String PROPERTY_NAME_PARAM = "propertyName";
    private static final String OLD_VALUE_PARAM = "oldValue";
    private static final String NEW_VALUE_PARAM = "newValue";

    public void handle(AnnotationValues<Bindable> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary((JavacNode)annotationNode, Bindable.class);
        JavacNode typeNode = (JavacNode)annotationNode.up();
        switch (typeNode.getKind()) {
            case TYPE: {
                if ((((JCTree.JCClassDecl)typeNode.get()).mods.flags & 0x200L) != 0L) {
                    annotationNode.addError("@Bindable is legal only on classes.");
                    break;
                }
                if (JavacHandlerUtil.fieldExists((String)PROPERTY_SUPPORT_FIELD_NAME, (JavacNode)typeNode) != JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
                    annotationNode.addWarning("Field 'this$propertyChangeSupport' already exists.");
                    break;
                }
                this.addBindableSupportToClass(typeNode);
                for (JavacNode field : typeNode.down()) {
                    if (!this.isCandidateField(field) || HandlerUtils.hasAnnotation(field, Bindable.class)) continue;
                    this.createOrAdjustProperty(typeNode, field);
                }
                break;
            }
            case FIELD: {
                if (!this.isCandidateField(typeNode)) break;
                if (JavacHandlerUtil.fieldExists((String)PROPERTY_SUPPORT_FIELD_NAME, (JavacNode)((JavacNode)typeNode.up())) == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
                    this.addBindableSupportToClass(HandlerUtils.findTypeNodeFrom(typeNode));
                }
                this.createOrAdjustProperty((JavacNode)typeNode.up(), typeNode);
                break;
            }
            default: {
                annotationNode.addError("@Bindable is legal only on types or fields.");
            }
        }
    }

    private void addBindableSupportToClass(JavacNode typeNode) {
        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)typeNode.get();
        HandlerUtils.TokenBuilder b = new HandlerUtils.TokenBuilder(typeNode);
        if (classDecl.extending == null) {
            b.setSuperclass("org.codehaus.griffon.runtime.core.AbstractObservable", typeNode);
        } else {
            b.addInterface("griffon.core.Observable", typeNode);
            this.createPropertyChangeSupportField(typeNode);
            this.injectListenerManagementMethod("addPropertyChangeListener", typeNode);
            this.injectListenerManagementMethod("removePropertyChangeListener", typeNode);
            this.injectListenerQueryMethod(typeNode);
            this.injectFirePropertyChangeMethod(typeNode);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Modified " + typeNode.getName() + " as a Bindable class.");
        }
    }

    private boolean isCandidateField(JavacNode node) {
        if (!HandlerUtils.isInstanceField(node)) {
            return false;
        }
        JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)node.get();
        return !PROPERTY_SUPPORT_FIELD_NAME.equals(field.name.toString()) && (field.mods.flags & 0x10L) == 0L && Modifier.isPrivate(HandlerUtils.toJavacModifier(field.mods));
    }

    private void createOrAdjustProperty(JavacNode typeNode, JavacNode field) {
        String propertyNameFieldName = Naming.nameOfConstantBasedOnProperty(field.getName());
        this.generatePropertyNameConstant(propertyNameFieldName, field, typeNode);
        this.generateSetter(field.getName(), propertyNameFieldName, field);
        this.generateGetter(field.getName(), field);
    }

    private void injectFirePropertyChangeMethod(JavacNode typeNode) {
        String methodName = "firePropertyChange";
        TreeMaker treeMaker = typeNode.getTreeMaker();
        List<JCTree.JCVariableDecl> params = List.of(AstBuilder.defVar(PROPERTY_NAME_PARAM).modifiers(16L).type(String.class).$(typeNode), AstBuilder.defVar(OLD_VALUE_PARAM).modifiers(16L).type(Object.class).$(typeNode), AstBuilder.defVar(NEW_VALUE_PARAM).modifiers(16L).type(Object.class).$(typeNode));
        List<JCTree.JCExpression> args = HandlerUtils.extractArgNames(params, treeMaker);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(methodName).modifiers(4L).withParams(params).withBody(this.body(methodName, args, typeNode)).$(typeNode));
    }

    private void injectListenerQueryMethod(JavacNode typeNode) {
        String methodName = "getPropertyChangeListeners";
        TreeMaker treeMaker = typeNode.getTreeMaker();
        List<JCTree.JCVariableDecl> params = List.nil();
        List<JCTree.JCExpression> args = List.nil();
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(methodName).withParams(params).returning(PropertyChangeListener[].class).withBody(this.bodyWithReturn(methodName, args, typeNode)).$(typeNode));
        params = List.of(AstBuilder.defVar(NAME_PARAM).modifiers(16L).type(String.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, treeMaker);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(methodName).withParams(params).returning(PropertyChangeListener[].class).withBody(this.bodyWithReturn(methodName, args, typeNode)).$(typeNode));
    }

    private void injectListenerManagementMethod(String methodName, JavacNode typeNode) {
        TreeMaker treeMaker = typeNode.getTreeMaker();
        List<JCTree.JCVariableDecl> params = List.of(AstBuilder.defVar(LISTENER_PARAM).modifiers(16L).type(PropertyChangeListener.class).$(typeNode));
        List<JCTree.JCExpression> args = HandlerUtils.extractArgNames(params, treeMaker);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(methodName).withParams(params).withBody(this.body(methodName, args, typeNode)).$(typeNode));
        params = List.of(AstBuilder.defVar(NAME_PARAM).modifiers(16L).type(String.class).$(typeNode), AstBuilder.defVar(LISTENER_PARAM).modifiers(16L).type(PropertyChangeListener.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, treeMaker);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(methodName).withParams(params).withBody(this.body(methodName, args, typeNode)).$(typeNode));
    }

    private List<JCTree.JCStatement> body(String methodName, List<JCTree.JCExpression> args, JavacNode typeNode) {
        TreeMaker treeMaker = typeNode.getTreeMaker();
        JCTree.JCExpression delegateToPropertySupport = this.delegateToPropertySupport(methodName, args, typeNode);
        return List.of(treeMaker.Exec(delegateToPropertySupport));
    }

    private List<JCTree.JCStatement> bodyWithReturn(String methodName, List<JCTree.JCExpression> args, JavacNode typeNode) {
        TreeMaker treeMaker = typeNode.getTreeMaker();
        JCTree.JCExpression delegateToPropertySupport = this.delegateToPropertySupport(methodName, args, typeNode);
        return List.of(treeMaker.Return(delegateToPropertySupport));
    }

    private JCTree.JCExpression delegateToPropertySupport(String methodName, List<JCTree.JCExpression> args, JavacNode typeNode) {
        TreeMaker treeMaker = typeNode.getTreeMaker();
        JCTree.JCExpression fn = JavacHandlerUtil.chainDots((JavacNode)typeNode, (String[])new String[]{PROPERTY_SUPPORT_FIELD_NAME, methodName});
        return treeMaker.Apply(List.<JCTree.JCExpression>nil(), fn, args);
    }

    private void createPropertyChangeSupportField(JavacNode typeNode) {
        JCTree.JCVariableDecl fieldDecl = AstBuilder.defVar(PROPERTY_SUPPORT_FIELD_NAME).modifiers(18L).type(PropertyChangeSupport.class).withArgs(HandlerUtils.thisExpression(typeNode)).$(typeNode);
        JavacHandlerUtil.injectFieldSuppressWarnings((JavacNode)typeNode, (JCTree.JCVariableDecl)fieldDecl);
    }

    private void generatePropertyNameConstant(String propertyNameFieldName, JavacNode fieldNode, JavacNode typeNode) {
        String propertyName = fieldNode.getName();
        if (MemberChecks.fieldAlreadyExists(propertyNameFieldName, fieldNode)) {
            return;
        }
        JavacHandlerUtil.injectField((JavacNode)typeNode, (JCTree.JCVariableDecl)AstBuilder.defVar(propertyNameFieldName).modifiers(26L).type(String.class).withValue(fieldNode.getTreeMaker().Literal(propertyName)).$(typeNode));
    }

    private void generateSetter(String fieldName, String propertyNameFieldName, JavacNode fieldNode) {
        String setterName = JavacHandlerUtil.toSetterName((JavacNode)fieldNode);
        if (MemberChecks.methodAlreadyExists(setterName, fieldNode, 1)) {
            return;
        }
        JavacHandlerUtil.injectMethod((JavacNode)((JavacNode)fieldNode.up()), (JCTree.JCMethodDecl)this.createSetterDecl(fieldName, propertyNameFieldName, setterName, fieldNode));
    }

    private void generateGetter(String fieldName, JavacNode fieldNode) {
        String getterName = JavacHandlerUtil.toGetterName((JavacNode)fieldNode);
        if (MemberChecks.methodAlreadyExists(getterName, fieldNode, 0)) {
            return;
        }
        JavacHandlerUtil.injectMethod((JavacNode)((JavacNode)fieldNode.up()), (JCTree.JCMethodDecl)this.createGetterDecl(fieldName, getterName, fieldNode));
    }

    private JCTree.JCMethodDecl createSetterDecl(String fieldName, String propertyNameFieldName, String setterName, JavacNode fieldNode) {
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        List<JCTree.JCVariableDecl> params = List.of(AstBuilder.defVar(fieldName).type(fieldDecl.vartype).$(fieldNode));
        return AstBuilder.defMethod(setterName).withParams(params).withBody(this.setterBody(propertyNameFieldName, fieldNode)).$(fieldNode);
    }

    private JCTree.JCBlock setterBody(String propertyNameFieldName, JavacNode fieldNode) {
        Name oldValueName = fieldNode.toName(OLD_VALUE_PARAM);
        JCTree.JCStatement[] statements = new JCTree.JCStatement[]{this.oldValueVariableDecl(oldValueName, fieldNode), this.assignNewValueToFieldDecl(fieldNode), this.fireChangeEventMethodDecl(propertyNameFieldName, oldValueName, fieldNode)};
        return fieldNode.getTreeMaker().Block(0L, List.from(statements));
    }

    private JCTree.JCStatement oldValueVariableDecl(Name oldValueName, JavacNode fieldNode) {
        TreeMaker treeMaker = fieldNode.getTreeMaker();
        JCTree.JCVariableDecl varDecl = (JCTree.JCVariableDecl)fieldNode.get();
        JCTree.JCExpression init = Lombok.newFieldAccessor(fieldNode);
        return treeMaker.VarDef(treeMaker.Modifiers(16L), oldValueName, varDecl.vartype, init);
    }

    private JCTree.JCStatement assignNewValueToFieldDecl(JavacNode fieldNode) {
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        TreeMaker treeMaker = fieldNode.getTreeMaker();
        JCTree.JCExpression fieldRef = Lombok.newFieldAccessor(fieldNode);
        JCTree.JCAssign assign = treeMaker.Assign(fieldRef, treeMaker.Ident(fieldDecl.name));
        return treeMaker.Exec(assign);
    }

    private JCTree.JCStatement fireChangeEventMethodDecl(String propertyNameFieldName, Name oldValueName, JavacNode fieldNode) {
        TreeMaker treeMaker = fieldNode.getTreeMaker();
        JCTree.JCExpression fn = JavacHandlerUtil.chainDots((JavacNode)fieldNode, (String[])new String[]{"this", "firePropertyChange"});
        List<JCTree.JCExpression> args = List.of(treeMaker.Ident(fieldNode.toName(propertyNameFieldName)), treeMaker.Ident(oldValueName), Lombok.newFieldAccessor(fieldNode));
        JCTree.JCMethodInvocation m = treeMaker.Apply(List.<JCTree.JCExpression>nil(), fn, args);
        return treeMaker.Exec(m);
    }

    private JCTree.JCMethodDecl createGetterDecl(String fieldName, String getterName, JavacNode fieldNode) {
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        return AstBuilder.defMethod(getterName).returning(fieldDecl.vartype).withBody(this.getterBody(fieldNode)).$(fieldNode);
    }

    private List<JCTree.JCStatement> getterBody(JavacNode fieldNode) {
        HandlerUtils.TokenBuilder b = new HandlerUtils.TokenBuilder(fieldNode);
        return List.of(b.getTreeMaker().Return(Lombok.newFieldAccessor(fieldNode)));
    }
}

