/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import lombok.core.util.Naming;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

class FieldBuilder {
    private Class<?> type;
    private String name;
    private long modifiers;
    private List<JCTree.JCExpression> args = List.nil();

    static FieldBuilder newField() {
        return new FieldBuilder();
    }

    FieldBuilder ofType(Class<?> newType) {
        this.type = newType;
        return this;
    }

    FieldBuilder withName(String newName) {
        this.name = newName;
        return this;
    }

    FieldBuilder withModifiers(long newModifiers) {
        this.modifiers = newModifiers;
        return this;
    }

    FieldBuilder withArgs(JCTree.JCExpression ... newArgs) {
        this.args = List.from(newArgs);
        return this;
    }

    JCTree.JCVariableDecl buildWith(JavacNode node) {
        TreeMaker treeMaker = node.getTreeMaker();
        JCTree.JCExpression classType = JavacHandlerUtil.chainDots((JavacNode)node, (String[])Naming.splitNameOf(this.type));
        JCTree.JCNewClass newVar = treeMaker.NewClass(null, null, classType, this.args, null);
        return treeMaker.VarDef(treeMaker.Modifiers(this.modifiers), node.toName(this.name), classType, newVar);
    }

    private FieldBuilder() {
    }
}

