/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import lombok.javac.JavacNode;

class MethodBuilder {
    private long modifiers;
    private String name;
    private JCTree.JCExpression returnType;
    private List<JCTree.JCVariableDecl> parameters = List.nil();
    private List<JCTree.JCExpression> throwsClauses = List.nil();
    private JCTree.JCBlock body;
    private JCTree.JCExpression defaultValue;

    static MethodBuilder newMethod() {
        return new MethodBuilder();
    }

    private MethodBuilder() {
    }

    MethodBuilder withModifiers(long newModifiers) {
        this.modifiers = newModifiers;
        return this;
    }

    MethodBuilder withName(String newName) {
        this.name = newName;
        return this;
    }

    MethodBuilder withReturnType(JCTree.JCExpression newReturnType) {
        this.returnType = newReturnType;
        return this;
    }

    MethodBuilder withParameters(List<JCTree.JCVariableDecl> newParameters) {
        this.parameters = newParameters;
        return this;
    }

    MethodBuilder withThrowsClauses(List<JCTree.JCExpression> newThrowsClauses) {
        this.throwsClauses = newThrowsClauses;
        return this;
    }

    MethodBuilder withBody(JCTree.JCBlock newBody) {
        this.body = newBody;
        return this;
    }

    MethodBuilder withDefaultValue(JCTree.JCExpression newDefaultValue) {
        this.defaultValue = newDefaultValue;
        return this;
    }

    JCTree.JCMethodDecl buildWith(JavacNode node) {
        TreeMaker treeMaker = node.getTreeMaker();
        return treeMaker.MethodDef(treeMaker.Modifiers(this.modifiers), node.toName(this.name), this.returnType, List.<JCTree.JCTypeParameter>nil(), this.parameters, this.throwsClauses, this.body, this.defaultValue);
    }
}

