/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import lombok.core.AST;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

final class MemberChecks {
    static boolean isClass(JavacNode node) {
        JCTree javacNode = (JCTree)node.get();
        if (!(javacNode instanceof JCTree.JCClassDecl)) {
            return false;
        }
        JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)javacNode;
        return (classDecl.mods.flags & 0x6200L) == 0L;
    }

    static boolean isField(JavacNode node) {
        return AST.Kind.FIELD.equals((Object)node.getKind());
    }

    static boolean fieldAlreadyExists(String fieldName, JavacNode node) {
        return MemberChecks.existsYesOrNo(JavacHandlerUtil.fieldExists((String)fieldName, (JavacNode)node));
    }

    static boolean methodAlreadyExists(String methodName, JavacNode node) {
        return MemberChecks.existsYesOrNo(JavacHandlerUtil.methodExists((String)methodName, (JavacNode)node));
    }

    private static boolean existsYesOrNo(JavacHandlerUtil.MemberExistsResult result) {
        return !result.equals((Object)JavacHandlerUtil.MemberExistsResult.NOT_EXISTS);
    }

    private MemberChecks() {
    }
}

