/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import griffon.transform.Threading;
import griffon.util.GriffonClassUtils;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.AstBuilder;
import lombok.javac.handlers.HandlerUtils;
import lombok.javac.handlers.JavacHandlerUtil;
import org.codehaus.griffon.ast.ThreadingASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleThreading
extends JavacAnnotationHandler<Threading> {
    private static final Logger LOG = LoggerFactory.getLogger(HandleThreading.class);

    public void handle(AnnotationValues<Threading> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary((JavacNode)annotationNode, Threading.class);
        JavacNode methodNode = (JavacNode)annotationNode.up();
        if (methodNode == null || methodNode.getKind() != AST.Kind.METHOD || !(methodNode.get() instanceof JCTree.JCMethodDecl)) {
            annotationNode.addError("@Threading is legal only on methods.");
            return;
        }
        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)methodNode.get();
        HandlerUtils.TokenBuilder b = new HandlerUtils.TokenBuilder((JavacNode)methodNode.up());
        if ((method.mods.flags & 0x400L) != 0L) {
            annotationNode.addError("@Threading is legal only on concrete methods.");
            return;
        }
        Threading.Policy threadingPolicy = ((Threading)annotation.getInstance()).value();
        if (threadingPolicy == Threading.Policy.SKIP) {
            return;
        }
        String threadingMethod = ThreadingASTTransformation.getThreadingMethod((Threading.Policy)threadingPolicy);
        this.handleMethodForInjection(b, methodNode, method, threadingMethod);
    }

    private void handleMethodForInjection(HandlerUtils.TokenBuilder b, JavacNode methodNode, JCTree.JCMethodDecl method, String threadingMethod) {
        GriffonClassUtils.MethodDescriptor md = HandlerUtils.methodDescriptorFor(method);
        if (GriffonClassUtils.isPlainMethod((GriffonClassUtils.MethodDescriptor)md) && !GriffonClassUtils.isEventHandler((GriffonClassUtils.MethodDescriptor)md) && this.hasVoidOrDefAsReturnType(method) && !ThreadingASTTransformation.skipInjection((String)(b.context.getName() + "." + method.getName()))) {
            this.wrapStatements(b, methodNode, method, threadingMethod);
        }
    }

    private boolean hasVoidOrDefAsReturnType(JCTree.JCMethodDecl method) {
        String type = method.getReturnType().type.toString();
        return "void".equals(type) || "Object".equals(type) || "java.lang.Object".equals(type);
    }

    private void wrapStatements(HandlerUtils.TokenBuilder b, JavacNode methodNode, JCTree.JCMethodDecl method, String threadingMethod) {
        if (((List)method.getBody().getStatements()).isEmpty()) {
            return;
        }
        for (JCTree.JCVariableDecl parameter : method.getParameters()) {
            this.makeFinal(parameter);
        }
        TreeMaker m = methodNode.getTreeMaker();
        JCTree.JCClassDecl runnableClass = AstBuilder.defClass("ThreadingWrapper_" + methodNode.getName().toString()).modifiers(0L).implementing(Runnable.class).withMembers(AstBuilder.defMethod("run").withBody((List<JCTree.JCStatement>)method.getBody().getStatements()).$(methodNode)).$(methodNode);
        JCTree.JCNewClass runnable = m.NewClass(null, HandlerUtils.NIL_EXPRESSION, b.type(Runnable.class), HandlerUtils.NIL_EXPRESSION, runnableClass);
        JCTree.JCExpression uiThreadManagerInstance = b.dotExpr("griffon.core.UIThreadManager.getInstance");
        JCTree.JCMethodInvocation uiThreadManagerInstanceCall = m.Apply(HandlerUtils.NIL_EXPRESSION, uiThreadManagerInstance, HandlerUtils.NIL_EXPRESSION);
        JCTree.JCMethodInvocation call = b.call(m.Select((JCTree.JCExpression)uiThreadManagerInstanceCall, b.name(threadingMethod)), List.of(runnable));
        method.body = m.Block(0L, List.of(m.Exec(call)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Modified " + b.context.getName() + "." + method.getName() + "() - code wrapped with " + threadingMethod + "{}");
        }
    }

    private void makeFinal(JCTree.JCVariableDecl parameter) {
        if ((parameter.mods.flags & 0x10L) == 0L) {
            parameter.mods.flags |= 0x10L;
        }
    }
}

