/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import griffon.transform.ResourcesAware;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import lombok.ast.AST;
import lombok.ast.Expression;
import lombok.ast.MethodDecl;
import lombok.ast.Statement;
import lombok.ast.TypeRef;
import lombok.core.AnnotationValues;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.AstBuilder;
import lombok.javac.handlers.HandlerUtils;
import lombok.javac.handlers.JavacHandlerUtil;
import lombok.javac.handlers.ast.JavacType;
import org.codehaus.griffon.runtime.core.ResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleResourcesAware
extends JavacAnnotationHandler<ResourcesAware> {
    private static final Logger LOG = LoggerFactory.getLogger(HandleResourcesAware.class);
    private static final String FIELD_NAME = "this$resourceLocator";
    private static final String NAME_PARAM = "name";
    private static final String METHOD_GET_RESOURCE_AS_URL = "getResourceAsURL";
    private static final String METHOD_GET_RESOURCE_AS_STREAM = "getResourceAsStream";
    private static final String METHOD_GET_RESOURCES = "getResources";

    public void handle(AnnotationValues<ResourcesAware> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary((JavacNode)annotationNode, ResourcesAware.class);
        JavacNode typeNode = (JavacNode)annotationNode.up();
        switch (typeNode.getKind()) {
            case TYPE: {
                if ((((JCTree.JCClassDecl)typeNode.get()).mods.flags & 0x200L) != 0L) {
                    annotationNode.addError("@ResourcesAware is legal only on classes and enums.");
                    return;
                }
                if (JavacHandlerUtil.fieldExists((String)FIELD_NAME, (JavacNode)typeNode) != JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
                    annotationNode.addWarning("Field 'this$resourceLocator' already exists.");
                    return;
                }
                JavacType type = JavacType.typeOf((JavacNode)annotationNode, (JCTree)ast);
                this.addResourceLocatorSupport(type);
                type.rebuild();
                return;
            }
        }
        annotationNode.addError("@ResourcesAware is legal only on types.");
    }

    private void addResourceLocatorSupport(JavacType type) {
        this.injectResourceHandlerInterface(type.node());
        this.createResourceLocatorField(type.node());
        this.injectResourceHandlingMethodMethod(type, METHOD_GET_RESOURCE_AS_URL, URL.class);
        this.injectResourceHandlingMethodMethod(type, METHOD_GET_RESOURCE_AS_STREAM, InputStream.class);
        this.injectResourceHandlingMethodMethod(type, METHOD_GET_RESOURCES, List.class, URL.class.getName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Modified " + type.node().getName() + " as a ResourceHandler.");
        }
    }

    private void injectResourceHandlerInterface(JavacNode typeNode) {
        HandlerUtils.TokenBuilder b = new HandlerUtils.TokenBuilder(typeNode);
        b.addInterface("griffon.core.ResourceHandler", typeNode);
    }

    private void injectResourceHandlingMethodMethod(JavacType type, String methodName, Class returnType) {
        this.injectResourceHandlingMethodMethod(type, methodName, returnType, null);
    }

    private void injectResourceHandlingMethodMethod(JavacType type, String methodName, Class returnType, String typeParam) {
        TypeRef returnTypeRef = AST.Type((Class)returnType);
        if (typeParam != null) {
            returnTypeRef.withTypeArgument(AST.Type((String)typeParam));
        }
        type.injectMethod((MethodDecl)((MethodDecl)((MethodDecl)AST.MethodDecl((TypeRef)returnTypeRef, (String)methodName).makePublic()).withArgument(AST.Arg((TypeRef)AST.Type(String.class), (String)NAME_PARAM))).withStatement((Statement)AST.Return((Expression)AST.Call((Expression)AST.Name((String)FIELD_NAME), (String)methodName).withArgument((Expression)AST.Name((String)NAME_PARAM)))));
    }

    private void createResourceLocatorField(JavacNode typeNode) {
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCExpression type = JavacHandlerUtil.chainDotsString((JavacNode)typeNode, (String)ResourceLocator.class.getName());
        JCTree.JCNewClass instance = maker.NewClass(null, HandlerUtils.NIL_EXPRESSION, type, HandlerUtils.NIL_EXPRESSION, null);
        JavacHandlerUtil.injectField((JavacNode)typeNode, (JCTree.JCVariableDecl)AstBuilder.defVar(FIELD_NAME).modifiers(18L).type(ResourceLocator.class).withValue(instance).$(typeNode));
    }
}

