/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import griffon.transform.EventPublisher;
import griffon.util.RunnableWithArgs;
import groovy.lang.Closure;
import lombok.core.AnnotationValues;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.AstBuilder;
import lombok.javac.handlers.HandlerUtils;
import lombok.javac.handlers.JavacHandlerUtil;
import org.codehaus.griffon.runtime.core.EventRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleEventPublisher
extends JavacAnnotationHandler<EventPublisher> {
    private static final Logger LOG = LoggerFactory.getLogger(HandleEventPublisher.class);
    private static final String FIELD_NAME = "this$eventrouter";
    private static final String NAME_PARAM = "name";
    private static final String LISTENER_PARAM = "listener";
    private static final String ARGS_PARAM = "args";

    public void handle(AnnotationValues<EventPublisher> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary((JavacNode)annotationNode, EventPublisher.class);
        JavacNode typeNode = (JavacNode)annotationNode.up();
        switch (typeNode.getKind()) {
            case TYPE: {
                if ((((JCTree.JCClassDecl)typeNode.get()).mods.flags & 0x200L) != 0L) {
                    annotationNode.addError("@EventPublisher is legal only on classes and enums.");
                    return;
                }
                if (JavacHandlerUtil.fieldExists((String)FIELD_NAME, (JavacNode)typeNode) != JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
                    annotationNode.addWarning("Field 'this$eventrouter' already exists.");
                    return;
                }
                this.addEventPublisherSupport(typeNode);
                return;
            }
        }
        annotationNode.addError("@EventPublisher is legal only on types.");
    }

    private void addEventPublisherSupport(JavacNode typeNode) {
        this.injectEventPublisherInterface(typeNode);
        this.createEventRouterField(typeNode);
        this.injectListenerManagementMethod(typeNode, "addEventListener");
        this.injectListenerManagementMethod(typeNode, "removeEventListener");
        this.injectEventPublishingEnabledMethods(typeNode);
        this.injectEventPublisherMethod(typeNode, "publishEvent", "publish");
        this.injectEventPublisherMethod(typeNode, "publishEventOutsideUI", "publishOutsideUI");
        this.injectEventPublisherMethod(typeNode, "publishEventOutside", "publishOutside");
        this.injectEventPublisherMethod(typeNode, "publishEventAsync", "publishAsync");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Modified " + typeNode.getName() + " as an EventPublisher.");
        }
    }

    private void injectEventPublishingEnabledMethods(JavacNode typeNode) {
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod("isEventPublishingEnabled").returning(Boolean.TYPE).withBody(this.bodyWithReturn("isEnabled", HandlerUtils.NIL_EXPRESSION, typeNode)).$(typeNode));
        TreeMaker treeMaker = typeNode.getTreeMaker();
        List<JCTree.JCVariableDecl> params = List.of(AstBuilder.defVar("enabled").type(Boolean.TYPE).$(typeNode));
        List<JCTree.JCExpression> args = HandlerUtils.extractArgNames(params, treeMaker);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod("setEventPublishingEnabled").withParams(params).withBody(this.body("setEnabled", args, typeNode)).$(typeNode));
    }

    private void injectEventPublisherInterface(JavacNode typeNode) {
        HandlerUtils.TokenBuilder b = new HandlerUtils.TokenBuilder(typeNode);
        b.addInterface("griffon.core.EventPublisher", typeNode);
    }

    private void injectListenerManagementMethod(JavacNode typeNode, String methodName) {
        TreeMaker treeMaker = typeNode.getTreeMaker();
        List<JCTree.JCVariableDecl> params = List.of(AstBuilder.defVar(LISTENER_PARAM).modifiers(16L).type(Object.class).$(typeNode));
        List<JCTree.JCExpression> args = HandlerUtils.extractArgNames(params, treeMaker);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(methodName).withParams(params).withBody(this.body(methodName, args, typeNode)).$(typeNode));
        params = List.of(AstBuilder.defVar(NAME_PARAM).modifiers(16L).type(String.class).$(typeNode), AstBuilder.defVar(LISTENER_PARAM).modifiers(16L).type(Closure.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, treeMaker);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(methodName).withParams(params).withBody(this.body(methodName, args, typeNode)).$(typeNode));
        params = List.of(AstBuilder.defVar(NAME_PARAM).modifiers(16L).type(String.class).$(typeNode), AstBuilder.defVar(LISTENER_PARAM).modifiers(16L).type(RunnableWithArgs.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, treeMaker);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(methodName).withParams(params).withBody(this.body(methodName, args, typeNode)).$(typeNode));
    }

    private void injectEventPublisherMethod(JavacNode typeNode, String methodName, String routerMethodName) {
        TreeMaker treeMaker = typeNode.getTreeMaker();
        List<JCTree.JCVariableDecl> params = List.of(AstBuilder.defVar(NAME_PARAM).modifiers(16L).type(String.class).$(typeNode));
        List<JCTree.JCExpression> args = HandlerUtils.extractArgNames(params, treeMaker);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(methodName).withParams(params).withBody(this.body(routerMethodName, args, typeNode)).$(typeNode));
        params = List.of(AstBuilder.defVar(NAME_PARAM).modifiers(16L).type(String.class).$(typeNode), AstBuilder.defVar(ARGS_PARAM).modifiers(16L).type(java.util.List.class).$(typeNode));
        args = HandlerUtils.extractArgNames(params, treeMaker);
        JavacHandlerUtil.injectMethod((JavacNode)typeNode, (JCTree.JCMethodDecl)AstBuilder.defMethod(methodName).withParams(params).withBody(this.body(routerMethodName, args, typeNode)).$(typeNode));
    }

    private List<JCTree.JCStatement> body(String methodName, List<JCTree.JCExpression> args, JavacNode typeNode) {
        TreeMaker treeMaker = typeNode.getTreeMaker();
        JCTree.JCExpression delegateToPropertySupport = this.delegateToEventRouter(methodName, args, typeNode);
        return List.of(treeMaker.Exec(delegateToPropertySupport));
    }

    private List<JCTree.JCStatement> bodyWithReturn(String methodName, List<JCTree.JCExpression> args, JavacNode typeNode) {
        TreeMaker treeMaker = typeNode.getTreeMaker();
        JCTree.JCExpression delegateToPropertySupport = this.delegateToEventRouter(methodName, args, typeNode);
        return List.of(treeMaker.Return(delegateToPropertySupport));
    }

    private JCTree.JCExpression delegateToEventRouter(String methodName, List<JCTree.JCExpression> args, JavacNode typeNode) {
        TreeMaker treeMaker = typeNode.getTreeMaker();
        JCTree.JCExpression fn = JavacHandlerUtil.chainDots((JavacNode)typeNode, (String[])new String[]{FIELD_NAME, methodName});
        return treeMaker.Apply(List.<JCTree.JCExpression>nil(), fn, args);
    }

    private void createEventRouterField(JavacNode typeNode) {
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCExpression type = JavacHandlerUtil.chainDotsString((JavacNode)typeNode, (String)EventRouter.class.getName());
        JCTree.JCNewClass instance = maker.NewClass(null, HandlerUtils.NIL_EXPRESSION, type, HandlerUtils.NIL_EXPRESSION, null);
        JavacHandlerUtil.injectField((JavacNode)typeNode, (JCTree.JCVariableDecl)AstBuilder.defVar(FIELD_NAME).modifiers(18L).type(EventRouter.class).withValue(instance).$(typeNode));
    }
}

