/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import lombok.javac.JavacNode;
import lombok.javac.handlers.HandlerUtils;
import lombok.javac.handlers.JavacHandlerUtil;
import lombok.javac.handlers.types.JCNoType;

public class AstBuilder {
    public static ClassDefBuilder defClass(String className) {
        return new ClassDefBuilder(className);
    }

    public static MethodDefBuilder defMethod(String methodName) {
        return new MethodDefBuilder(methodName);
    }

    public static VariableDefBuilder defVar(String variableName) {
        return new VariableDefBuilder(variableName);
    }

    public static class VariableDefBuilder {
        private final String variableName;
        private long modifiers;
        private String varType;
        private JCTree.JCExpression type;
        private JCTree.JCExpression value;
        private List<JCTree.JCExpression> args;

        public VariableDefBuilder(String variableName) {
            this.variableName = variableName;
            this.modifiers = 0L;
            this.varType = Object.class.getName();
        }

        public VariableDefBuilder modifiers(long mods) {
            this.modifiers = mods;
            return this;
        }

        public VariableDefBuilder type(Class clazz) {
            return this.type(clazz.getName());
        }

        public VariableDefBuilder type(String className) {
            this.varType = className;
            return this;
        }

        public VariableDefBuilder type(JCTree.JCExpression type) {
            this.type = type;
            return this;
        }

        public VariableDefBuilder withValue(JCTree.JCExpression value) {
            this.value = value;
            return this;
        }

        public VariableDefBuilder withArgs(JCTree.JCExpression ... args) {
            this.args = List.from(args);
            return this;
        }

        public JCTree.JCVariableDecl $(JavacNode context) {
            return this.build(context, (JCTree)context.get());
        }

        public JCTree.JCVariableDecl build(JavacNode context) {
            return this.build(context, (JCTree)context.get());
        }

        public JCTree.JCVariableDecl $(JavacNode context, JCTree source) {
            return this.build(context, source);
        }

        public JCTree.JCVariableDecl build(JavacNode context, JCTree source) {
            TreeMaker m = context.getTreeMaker().at(source.pos);
            JCTree.JCExpression typeExpression = this.type != null ? this.type : HandlerUtils.makeType(this.varType, context, m);
            JCTree.JCExpression initExpression = this.value;
            if (this.value == null && this.args != null) {
                initExpression = m.NewClass(null, null, typeExpression, this.args, null);
            }
            return (JCTree.JCVariableDecl)JavacHandlerUtil.recursiveSetGeneratedBy((JCTree)m.VarDef(m.Modifiers(this.modifiers), context.toName(this.variableName), typeExpression, initExpression), (JCTree)source);
        }
    }

    public static class MethodDefBuilder {
        private final String methodName;
        private long modifiers;
        private String returnType;
        private JCTree.JCExpression returnTypeExpr;
        private List<JCTree.JCTypeParameter> typeParameters;
        private List<JCTree.JCVariableDecl> params;
        private List<JCTree.JCExpression> throwables;
        private List<JCTree.JCStatement> statements;

        public MethodDefBuilder(String methodName) {
            this.methodName = methodName;
            this.modifiers = 1L;
            this.returnType = Void.TYPE.getName();
            this.typeParameters = List.nil();
            this.params = List.nil();
            this.throwables = List.nil();
            this.statements = List.nil();
        }

        public MethodDefBuilder modifiers(long mods) {
            this.modifiers = mods;
            return this;
        }

        public MethodDefBuilder returning(Class clazz) {
            return this.returning(clazz.getName());
        }

        public MethodDefBuilder returning(String className) {
            this.returnType = className;
            return this;
        }

        public MethodDefBuilder returning(JCTree.JCExpression type) {
            this.returnTypeExpr = type;
            return this;
        }

        public MethodDefBuilder typeParams(List<JCTree.JCTypeParameter> typeParameters) {
            this.typeParameters = typeParameters;
            return this;
        }

        public MethodDefBuilder withParams(ListBuffer<JCTree.JCVariableDecl> params) {
            return this.withParams(HandlerUtils.toList(params));
        }

        public MethodDefBuilder withParams(List<JCTree.JCVariableDecl> params) {
            this.params = params;
            return this;
        }

        public MethodDefBuilder throwing(List<JCTree.JCExpression> throwables) {
            this.throwables = throwables;
            return this;
        }

        public MethodDefBuilder withBody(List<JCTree.JCStatement> statements) {
            this.statements = statements;
            return this;
        }

        public MethodDefBuilder withBody(JCTree.JCStatement statement) {
            return this.withBody(List.of(statement));
        }

        public JCTree.JCMethodDecl $(JavacNode context) {
            return this.build(context);
        }

        public JCTree.JCMethodDecl build(JavacNode context) {
            TreeMaker m = context.getTreeMaker();
            JCTree.JCExpression returns = this.returnTypeExpr;
            if (returns == null) {
                returns = m.Type(JCNoType.voidType());
                if (!this.returnType.equals(Void.TYPE.getName())) {
                    returns = HandlerUtils.makeType(this.returnType, context);
                }
            }
            return context.getTreeMaker().MethodDef(m.Modifiers(this.modifiers), context.toName(this.methodName), returns, this.typeParameters, this.params, this.throwables, m.Block(0L, this.statements), null);
        }
    }

    public static class ClassDefBuilder {
        private final String className;
        private long modifiers;
        private List<JCTree.JCTypeParameter> typeParameters;
        private JCTree superClass;
        private List<String> interfaces;
        private List<JCTree> members;

        public ClassDefBuilder(String className) {
            this.className = className;
            this.modifiers = 1L;
            this.typeParameters = List.nil();
            this.interfaces = List.nil();
            this.members = List.nil();
        }

        public ClassDefBuilder modifiers(long mods) {
            this.modifiers = mods;
            return this;
        }

        public ClassDefBuilder extending(JCTree superClass) {
            this.superClass = superClass;
            return this;
        }

        public ClassDefBuilder implementing(Class ... interfaces) {
            ListBuffer<String> types = new ListBuffer<String>();
            for (Class type : interfaces) {
                types.append(type.getName());
            }
            this.interfaces = HandlerUtils.toList(types);
            return this;
        }

        public ClassDefBuilder implementing(String ... interfaces) {
            ListBuffer<String> types = new ListBuffer<String>();
            for (String type : interfaces) {
                types.append(type);
            }
            this.interfaces = HandlerUtils.toList(types);
            return this;
        }

        public ClassDefBuilder implementing(List<String> interfaces) {
            this.interfaces = interfaces;
            return this;
        }

        public ClassDefBuilder typeParams(List<JCTree.JCTypeParameter> typeParameters) {
            this.typeParameters = typeParameters;
            return this;
        }

        public ClassDefBuilder withMembers(List<JCTree> members) {
            this.members = members;
            return this;
        }

        public ClassDefBuilder withMembers(JCTree ... members) {
            ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
            for (JCTree member : members) {
                defs.append(member);
            }
            return this.withMembers(HandlerUtils.toList(defs));
        }

        public JCTree.JCClassDecl $(JavacNode context) {
            return this.build(context);
        }

        public JCTree.JCClassDecl build(JavacNode context) {
            TreeMaker m = context.getTreeMaker();
            ListBuffer<JCTree.JCExpression> implemented = new ListBuffer<JCTree.JCExpression>();
            for (String type : this.interfaces) {
                implemented.append(JavacHandlerUtil.chainDotsString((JavacNode)context, (String)type));
            }
            return context.getTreeMaker().ClassDef(m.Modifiers(this.modifiers), context.toName(this.className), this.typeParameters, this.superClass, HandlerUtils.toList(implemented), this.members);
        }
    }
}

