/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.leveldb.LeveldbAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.LeveldbAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleLeveldbAware
extends EclipseAnnotationHandler<LeveldbAware> {
    private final EclipseLeveldbAwareHandler handler = new EclipseLeveldbAwareHandler();

    public void handle(AnnotationValues<LeveldbAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(LeveldbAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.leveldb.LeveldbContributionHandler", (Annotation)source);
        this.handler.addLeveldbProviderField(type);
        this.handler.addLeveldbProviderAccessors(type);
        this.handler.addLeveldbContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseLeveldbAwareHandler
    extends LeveldbAwareHandler<EclipseType> {
        private EclipseLeveldbAwareHandler() {
        }
    }
}

