/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.leveldb;

import griffon.plugins.leveldb.LeveldbProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.iq80.leveldb.DB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLeveldbProvider
implements LeveldbProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLeveldbProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withLeveldb(Closure<R> closure) {
        return this.withLeveldb(DEFAULT, closure);
    }

    @Override
    public <R> R withLeveldb(String databaseName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)databaseName)) {
            databaseName = DEFAULT;
        }
        if (closure != null) {
            DB connection = this.getDatabase(databaseName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on databaseName '" + databaseName + "'");
            }
            return (R)closure.call(new Object[]{databaseName, connection});
        }
        return null;
    }

    @Override
    public <R> R withLeveldb(CallableWithArgs<R> callable) {
        return this.withLeveldb(DEFAULT, callable);
    }

    @Override
    public <R> R withLeveldb(String databaseName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)databaseName)) {
            databaseName = DEFAULT;
        }
        if (callable != null) {
            DB connection = this.getDatabase(databaseName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on databaseName '" + databaseName + "'");
            }
            callable.setArgs(new Object[]{databaseName, connection});
            return (R)callable.call();
        }
        return null;
    }

    protected abstract DB getDatabase(String var1);
}

