/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compiler.support;

import griffon.plugins.ldap.GriffonLdapSchema;
import org.codehaus.griffon.ast.GriffonASTUtils;
import org.codehaus.griffon.compiler.GriffonCompilerContext;
import org.codehaus.griffon.compiler.SourceUnitCollector;
import org.codehaus.griffon.compiler.support.GriffonArtifactASTInjector;
import org.codehaus.griffon.compiler.support.GriffonArtifactASTTransformation;
import org.codehaus.griffon.runtime.ldap.AbstractGriffonLdapSchema;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class GriffonLdapSchemaASTTransformation
extends GriffonArtifactASTTransformation {
    private static final Logger LOG = LoggerFactory.getLogger(GriffonLdapSchemaASTTransformation.class);
    private static final String ARTIFACT_PATH = "ldap";
    private static final ClassNode GRIFFON_LDAP_SCHEMA_CLASS = ClassHelper.makeWithoutCaching(GriffonLdapSchema.class);
    private static final ClassNode ABSTRACT_GRIFFON_LDAP_SCHEMA_CLASS = ClassHelper.makeWithoutCaching(AbstractGriffonLdapSchema.class);

    public static boolean isLdapSchemaArtifact(ClassNode classNode, SourceUnit source) {
        if (classNode == null || source == null) {
            return false;
        }
        return ARTIFACT_PATH.equals(GriffonCompilerContext.getArtifactPath((SourceUnit)source)) && classNode.getName().endsWith("LdapSchema");
    }

    protected void transform(ClassNode classNode, SourceUnit source, String artifactPath) {
        if (!GriffonLdapSchemaASTTransformation.isLdapSchemaArtifact(classNode, source)) {
            return;
        }
        this.doTransform(classNode);
    }

    private void doTransform(ClassNode classNode) {
        ClassNode superClass = classNode.getSuperClass();
        if (ClassHelper.OBJECT_TYPE.equals((Object)superClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting " + ABSTRACT_GRIFFON_LDAP_SCHEMA_CLASS.getName() + " as the superclass of " + classNode.getName());
            }
            classNode.setSuperClass(ABSTRACT_GRIFFON_LDAP_SCHEMA_CLASS);
        } else if (!classNode.implementsInterface(GRIFFON_LDAP_SCHEMA_CLASS)) {
            this.inject(classNode, superClass);
        }
    }

    private void inject(ClassNode classNode, ClassNode superClass) {
        SourceUnit superSource = SourceUnitCollector.getInstance().getSourceUnit(superClass);
        if (GriffonLdapSchemaASTTransformation.isLdapSchemaArtifact(superClass, superSource)) {
            return;
        }
        if (superSource == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting " + GRIFFON_LDAP_SCHEMA_CLASS.getName() + " behavior to " + classNode.getName());
            }
            GriffonASTUtils.injectInterface((ClassNode)classNode, (ClassNode)GRIFFON_LDAP_SCHEMA_CLASS);
            GriffonArtifactASTInjector injector = new GriffonArtifactASTInjector();
            injector.inject(classNode, ARTIFACT_PATH);
        } else {
            this.doTransform(superClass);
        }
    }
}

