/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.swt.layouts;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GridLayout
extends Layout {
    private int _hgap;
    private int _vgap;
    private int _rows;
    private int _columns;

    public GridLayout() {
        this(1, 0);
    }

    public GridLayout(int rows, int columns) {
        this(rows, columns, 0, 0);
    }

    public GridLayout(int rows, int columns, int hgap, int vgap) {
        if (rows == 0 && columns == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        if (rows != 0) {
            this.setRows(rows);
        }
        this.setColumns(columns);
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    protected void layout(Composite target, boolean flushCache) {
        Rectangle r = target.getClientArea();
        Control[] children = target.getChildren();
        int ncomponents = children.length;
        int nrows = this.getRows();
        int ncols = this.getColumns();
        if (ncomponents == 0) {
            return;
        }
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        int w = r.width;
        int h = r.height;
        w = (w - (ncols - 1) * this.getHgap()) / ncols;
        h = (h - (nrows - 1) * this.getVgap()) / nrows;
        int col = 0;
        int x = 0;
        while (col < ncols) {
            int row = 0;
            int y = 0;
            while (row < nrows) {
                int i = row * ncols + col;
                if (i < ncomponents) {
                    children[i].setBounds(x, y, w, h);
                }
                ++row;
                y += h + this.getVgap();
            }
            ++col;
            x += w + this.getHgap();
        }
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int ncomponents = children.length;
        int nrows = this.getRows();
        int ncols = this.getColumns();
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        int w = 0;
        int h = 0;
        int i = 0;
        while (i < ncomponents) {
            Control comp = children[i];
            Point d = comp.computeSize(-1, -1);
            if (w < d.x) {
                w = d.x;
            }
            if (h < d.y) {
                h = d.y;
            }
            ++i;
        }
        return new Point(ncols * w + (ncols - 1) * this.getHgap(), nrows * h + (nrows - 1) * this.getVgap());
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "hgap=" + this.getHgap() + ",vgap=" + this.getVgap() + ",rows=" + this.getRows() + ",cols=" + this.getColumns();
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) {
        if (rows == 0 && this.getColumns() == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this._rows = rows;
    }

    public int getColumns() {
        return this._columns;
    }

    public void setColumns(int columns) {
        if (columns == 0 && this.getRows() == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this._columns = columns;
    }

    public int getHgap() {
        return this._hgap;
    }

    public void setHgap(int hgap) {
        this._hgap = hgap;
    }

    public int getVgap() {
        return this._vgap;
    }

    public void setVgap(int vgap) {
        this._vgap = vgap;
    }
}

