/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.swt.layouts;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FlowLayout
extends Layout {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    private int _alignment;
    private int _hgap;
    private int _vgap;

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int align) {
        this(align, 5, 5);
    }

    public FlowLayout(int align, int hgap, int vgap) {
        this.setHgap(hgap);
        this.setVgap(vgap);
        this.setAlignment(align);
    }

    protected void layout(Composite target, boolean flushCache) {
        Rectangle r = target.getClientArea();
        Control[] children = target.getChildren();
        int maxwidth = r.width - this.getHgap() * 2;
        int nmembers = children.length;
        int x = 0;
        int y = this.getVgap();
        int rowh = 0;
        int start = 0;
        boolean ltr = true;
        int i = 0;
        while (i < nmembers) {
            Control m = children[i];
            if (m.isVisible()) {
                Point d = m.computeSize(-1, -1);
                m.setSize(d.x, d.y);
                if (x == 0 || x + d.x <= maxwidth) {
                    if (x > 0) {
                        x += this.getHgap();
                    }
                    x += d.x;
                    rowh = Math.max(rowh, d.y);
                } else {
                    this.moveComponents(target, r, this.getHgap(), y, maxwidth - x, rowh, start, i, ltr);
                    x = d.x;
                    y += this.getVgap() + rowh;
                    rowh = d.y;
                    start = i;
                }
            }
            ++i;
        }
        this.moveComponents(target, r, this.getHgap(), y, maxwidth - x, rowh, start, nmembers, ltr);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = new Point(0, 0);
        Control[] children = composite.getChildren();
        boolean firstVisibleComponent = true;
        int i = 0;
        while (i < children.length) {
            Control m = children[i];
            if (m.isVisible()) {
                Point d = m.computeSize(-1, -1);
                size.y = Math.max(size.y, d.y);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    size.x += this.getHgap();
                }
                size.x += d.x;
            }
            ++i;
        }
        size.x += this.getHgap() * 2;
        size.y += this.getVgap() * 2;
        return size;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int align) {
        this._alignment = align;
    }

    public int getHgap() {
        return this._hgap;
    }

    public void setHgap(int hgap) {
        this._hgap = hgap;
    }

    public int getVgap() {
        return this._vgap;
    }

    public void setVgap(int vgap) {
        this._vgap = vgap;
    }

    private void moveComponents(Composite target, Rectangle r, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        switch (this.getAlignment()) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                x += width;
            }
        }
        Control[] children = target.getChildren();
        int i = rowStart;
        while (i < rowEnd) {
            Control m = children[i];
            Point size = m.getSize();
            if (m.isVisible()) {
                if (ltr) {
                    m.setLocation(x, y + (height - size.y) / 2);
                } else {
                    m.setLocation(r.width - x - size.x, y + (height - size.y) / 2);
                }
                x += size.x + this.getHgap();
            }
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        String str = "";
        switch (this.getAlignment()) {
            case 0: {
                str = ",align=left";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=right";
                break;
            }
            case 3: {
                str = ",align=leading";
                break;
            }
            case 4: {
                str = ",align=trailing";
            }
        }
        return "hgap=" + this.getHgap() + ",vgap=" + this.getVgap() + str;
    }
}

