/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.swt.layouts;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BorderLayout
extends Layout {
    private boolean _cached;
    private int _hgap;
    private int _vgap;
    private int _north;
    private int _west;
    private int _east;
    private int _south;
    private int _center;
    private int _firstLine;
    private int _lastLine;
    private int _firstItem;
    private int _lastItem;
    protected static final int INT_NONE = -1;
    protected static final int INT_NORTH = 0;
    public static final Integer NORTH = new Integer(0);
    protected static final int INT_SOUTH = 1;
    public static final Integer SOUTH = new Integer(1);
    protected static final int INT_EAST = 2;
    public static final Integer EAST = new Integer(2);
    protected static final int INT_WEST = 3;
    public static final Integer WEST = new Integer(3);
    protected static final int INT_CENTER = 4;
    public static final Integer CENTER = new Integer(4);
    protected static final int INT_BEFORE_FIRST_LINE = 5;
    public static final Integer BEFORE_FIRST_LINE = new Integer(5);
    protected static final int INT_AFTER_LAST_LINE = 6;
    public static final Integer AFTER_LAST_LINE = new Integer(6);
    protected static final int INT_BEFORE_LINE_BEGINS = 7;
    public static final Integer BEFORE_LINE_BEGINS = new Integer(7);
    protected static final int INT_AFTER_LINE_ENDS = 8;
    public static final Integer AFTER_LINE_ENDS = new Integer(8);

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int hgap, int vgap) {
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    public int getHgap() {
        return this._hgap;
    }

    public void setHgap(int hgap) {
        this._hgap = hgap;
    }

    public int getVgap() {
        return this._vgap;
    }

    public void setVgap(int vgap) {
        this._vgap = vgap;
    }

    protected void determineControlPositions(Control[] controls) {
        this.setCenter(-1);
        this.setNorth(-1);
        this.setSouth(-1);
        this.setEast(-1);
        this.setWest(-1);
        this.setFirstLine(-1);
        this.setLastLine(-1);
        this.setFirstItem(-1);
        this.setLastItem(-1);
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            Object layoutData = control.getLayoutData();
            if (layoutData != null && !(layoutData instanceof Integer)) {
                throw new IllegalArgumentException("Bad control layout data");
            }
            Integer positionAsInteger = (Integer)layoutData;
            int position = positionAsInteger == null ? 4 : positionAsInteger;
            switch (position) {
                case 4: {
                    this.setCenter(i);
                    break;
                }
                case 0: {
                    this.setNorth(i);
                    break;
                }
                case 1: {
                    this.setSouth(i);
                    break;
                }
                case 2: {
                    this.setEast(i);
                    break;
                }
                case 3: {
                    this.setWest(i);
                    break;
                }
                case 5: {
                    this.setFirstLine(i);
                    break;
                }
                case 6: {
                    this.setLastLine(i);
                    break;
                }
                case 7: {
                    this.setFirstItem(i);
                    break;
                }
                case 8: {
                    this.setLastItem(i);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + position);
                }
            }
            this.setCached(true);
            ++i;
        }
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point d;
        Control[] children = composite.getChildren();
        if (!this.isCached() || flushCache) {
            this.determineControlPositions(children);
        }
        Point size = new Point(0, 0);
        boolean ltr = true;
        Control c = null;
        c = this.getChild(children, 2, ltr);
        if (c != null) {
            d = c.computeSize(-1, -1);
            size.x += d.x + this.getHgap();
            size.y = Math.max(d.y, size.y);
        }
        if ((c = this.getChild(children, 3, ltr)) != null) {
            d = c.computeSize(-1, -1);
            size.x += d.x + this.getHgap();
            size.y = Math.max(d.y, size.y);
        }
        if ((c = this.getChild(children, 4, ltr)) != null) {
            d = c.computeSize(-1, -1);
            size.x += d.x;
            size.y = Math.max(d.y, size.y);
        }
        if ((c = this.getChild(children, 0, ltr)) != null) {
            d = c.computeSize(-1, -1);
            size.x = Math.max(d.x, size.x);
            size.y += d.y + this.getVgap();
        }
        if ((c = this.getChild(children, 1, ltr)) != null) {
            d = c.computeSize(-1, -1);
            size.x = Math.max(d.x, size.x);
            size.y += d.y + this.getVgap();
        }
        return size;
    }

    protected void layout(Composite composite, boolean flushCache) {
        int delta;
        Point d;
        Control[] children = composite.getChildren();
        if (!this.isCached() || flushCache) {
            this.determineControlPositions(children);
        }
        Rectangle r = composite.getClientArea();
        int count = children.length;
        if (count == 0) {
            return;
        }
        boolean ltr = true;
        Control c = null;
        c = this.getChild(children, 0, ltr);
        if (c != null) {
            d = c.computeSize(-1, -1);
            c.setBounds(r.x, r.y, r.width, d.y);
            delta = d.y + this.getVgap();
            r.y += delta;
        }
        if ((c = this.getChild(children, 1, ltr)) != null) {
            d = c.computeSize(-1, -1);
            c.setBounds(r.x, r.height - d.y, r.width, d.y);
            r.height -= d.y + this.getVgap();
        }
        if ((c = this.getChild(children, 2, ltr)) != null) {
            d = c.computeSize(-1, -1);
            c.setBounds(r.width - d.x, r.y, d.x, r.height - r.y);
            r.width -= d.x + this.getHgap();
        }
        if ((c = this.getChild(children, 3, ltr)) != null) {
            d = c.computeSize(-1, -1);
            c.setBounds(r.x, r.y, d.x, r.height - r.y);
            delta = d.x + this.getHgap();
            r.x += delta;
        }
        if ((c = this.getChild(children, 4, ltr)) != null) {
            c.setBounds(r.x, r.y, r.width - r.x, r.height - r.y);
        }
    }

    protected Control getChild(Control[] children, int key, boolean ltr) {
        int result = -1;
        switch (key) {
            case 0: {
                result = this.getFirstLine() != -1 ? this.getFirstLine() : this.getNorth();
                break;
            }
            case 1: {
                result = this.getLastLine() != -1 ? this.getLastLine() : this.getSouth();
                break;
            }
            case 3: {
                int n = result = ltr ? this.getFirstItem() : this.getLastItem();
                if (result != -1) break;
                result = this.getWest();
                break;
            }
            case 2: {
                int n = result = ltr ? this.getLastItem() : this.getFirstItem();
                if (result != -1) break;
                result = this.getEast();
                break;
            }
            case 4: {
                result = this.getCenter();
            }
        }
        if (result != -1 && !children[result].isVisible()) {
            result = -1;
        }
        if (result == -1) {
            return null;
        }
        return children[result];
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "hgap=" + this.getHgap() + ",vgap=" + this.getVgap();
    }

    protected int getWest() {
        return this._west;
    }

    protected void setWest(int west) {
        this._west = west;
    }

    protected int getSouth() {
        return this._south;
    }

    protected void setSouth(int south) {
        this._south = south;
    }

    protected int getNorth() {
        return this._north;
    }

    protected void setNorth(int north) {
        this._north = north;
    }

    protected int getLastLine() {
        return this._lastLine;
    }

    protected void setLastLine(int lastLine) {
        this._lastLine = lastLine;
    }

    protected int getLastItem() {
        return this._lastItem;
    }

    protected void setLastItem(int lastItem) {
        this._lastItem = lastItem;
    }

    protected int getFirstLine() {
        return this._firstLine;
    }

    protected void setFirstLine(int firstLine) {
        this._firstLine = firstLine;
    }

    protected int getFirstItem() {
        return this._firstItem;
    }

    protected void setFirstItem(int firstItem) {
        this._firstItem = firstItem;
    }

    protected int getEast() {
        return this._east;
    }

    protected void setEast(int east) {
        this._east = east;
    }

    protected int getCenter() {
        return this._center;
    }

    protected void setCenter(int center) {
        this._center = center;
    }

    protected boolean isCached() {
        return this._cached;
    }

    protected void setCached(boolean cached) {
        this._cached = cached;
    }
}

