/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.lanterna;

import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.layout.LayoutManager;
import griffon.lanterna.factory.ComponentFactory;
import griffon.lanterna.factory.LayoutFactory;
import groovy.util.Factory;
import groovy.util.FactoryBuilderSupport;
import org.codehaus.griffon.runtime.builder.DefaultCompositeBuilderCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanternaCompositeBuilderCustomizer
extends DefaultCompositeBuilderCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(LanternaCompositeBuilderCustomizer.class);

    public void registerBeanFactory(FactoryBuilderSupport builder, String name, String groupName, Class<?> beanClass) {
        if (LayoutManager.class.isAssignableFrom(beanClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using LayoutFactory");
            }
            builder.registerFactory(name, groupName, (Factory)new LayoutFactory(beanClass));
        } else if (Component.class.isAssignableFrom(beanClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using ComponentFactory");
            }
            builder.registerFactory(name, groupName, (Factory)new ComponentFactory(beanClass));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using default factory");
            }
            builder.registerBeanFactory(name, groupName, beanClass);
        }
    }
}

