/*
 * Decompiled with CFR 0.152.
 */
package griffon.lanterna.widgets;

import com.googlecode.lanterna.gui.Action;
import org.codehaus.griffon.runtime.core.AbstractObservable;

public class MutableAction
extends AbstractObservable
implements Action {
    public static final String NAME = "name";
    private Runnable runnable;
    private Action delegate;
    private String name;
    private ResolveStrategy resolveStrategy = ResolveStrategy.DELEGATE_FIRST;

    public ResolveStrategy getResolveStrategy() {
        return this.resolveStrategy;
    }

    public void setResolveStrategy(ResolveStrategy resolveStrategy) {
        this.resolveStrategy = resolveStrategy != null ? resolveStrategy : ResolveStrategy.DELEGATE_FIRST;
    }

    public MutableAction() {
    }

    public MutableAction(String name) {
        this.name = name;
    }

    public MutableAction(Runnable runnable) {
        this.runnable = runnable;
    }

    public MutableAction(Action delegate) {
        this.delegate = delegate;
    }

    public Action getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Action delegate) {
        this.delegate = delegate;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.pcs.firePropertyChange(NAME, this.name, this.name);
    }

    public String toString() {
        return this.name;
    }

    public void doAction() {
        switch (this.resolveStrategy) {
            case DELEGATE_ONLY: {
                if (this.delegate == null) break;
                this.delegate.doAction();
                break;
            }
            case DELEGATE_FIRST: {
                if (this.delegate != null) {
                    this.delegate.doAction();
                    break;
                }
                if (this.runnable == null) break;
                this.runnable.run();
                break;
            }
            case RUNNABLE_FIRST: {
                if (this.runnable != null) {
                    this.runnable.run();
                    break;
                }
                if (this.delegate == null) break;
                this.delegate.doAction();
                break;
            }
            case RUNNABLE_ONLY: {
                if (this.runnable == null) break;
                this.runnable.run();
            }
        }
    }

    public static enum ResolveStrategy {
        DELEGATE_FIRST,
        RUNNABLE_FIRST,
        DELEGATE_ONLY,
        RUNNABLE_ONLY;

    }
}

