/*
 * Decompiled with CFR 0.152.
 */
package griffon.lanterna;

import com.googlecode.lanterna.gui.Window;
import com.googlecode.lanterna.gui.listener.WindowAdapter;
import com.googlecode.lanterna.gui.listener.WindowListener;
import griffon.core.ApplicationPhase;
import griffon.core.GriffonApplication;
import griffon.core.ShutdownHandler;
import griffon.lanterna.LanternaGriffonApplication;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import groovy.util.ConfigObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowManager
implements ShutdownHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WindowManager.class);
    private final LanternaGriffonApplication app;
    private final WindowHelper windowHelper = new WindowHelper();
    private final Map<String, Window> windows = new ConcurrentHashMap<String, Window>();

    public WindowManager(LanternaGriffonApplication app) {
        this.app = app;
    }

    public Window findWindow(String name) {
        if (!GriffonNameUtils.isBlank((String)name)) {
            return this.windows.get(name);
        }
        return null;
    }

    public String findWindowName(Window window) {
        if (window != null) {
            for (Map.Entry<String, Window> entry : this.windows.entrySet()) {
                if (entry.getValue() != window) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public Window getStartingWindow() {
        int index;
        Window window = null;
        Object value = ConfigUtils.getConfigValue((Map)this.app.getConfig(), (String)"lanterna.windowManager.startingWindow");
        if (LOG.isDebugEnabled()) {
            LOG.debug("lanterna.windowManager.startingWindow configured to " + value);
        }
        if (value == null || value instanceof ConfigObject) {
            if (this.windows.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No startingWindow configured, selecting the first one in the list of windows");
                }
                window = this.windows.values().iterator().next();
            }
        } else if (value instanceof String) {
            String windowName = (String)value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window " + windowName + " as starting window");
            }
            window = this.findWindow(windowName);
        } else if (value instanceof Number && (index = ((Number)value).intValue()) >= 0 && index < this.windows.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window at index " + index + " as starting window");
            }
            int i = 0;
            Iterator<Window> iter = this.windows.values().iterator();
            while (iter.hasNext()) {
                if (i == index) {
                    window = iter.next();
                    break;
                }
                ++i;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting window is " + window);
        }
        return window;
    }

    public Collection<Window> getWindows() {
        return Collections.unmodifiableCollection(this.windows.values());
    }

    public void attach(String name, Window window) {
        if (window == null || this.windows.values().contains(window)) {
            return;
        }
        window.addWindowListener((WindowListener)this.windowHelper);
        this.windows.put(name, window);
    }

    public void detach(Window window) {
        if (window == null) {
            return;
        }
        if (this.windows.values().contains(window)) {
            this.windows.remove(this.findWindowName(window));
        }
    }

    public void show(final Window window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                WindowManager.this.app.resolveWindowDisplayHandler().show(window, WindowManager.this.app);
            }
        });
    }

    public void hide(final Window window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                WindowManager.this.app.resolveWindowDisplayHandler().hide(window, WindowManager.this.app);
            }
        });
    }

    public boolean canShutdown(GriffonApplication app) {
        return true;
    }

    public void onShutdown(GriffonApplication app) {
        for (Window window : this.windows.values()) {
            this.hide(window);
        }
    }

    private class WindowHelper
    extends WindowAdapter {
        private WindowHelper() {
        }

        public void onWindowClosed(Window window) {
            super.onWindowClosed(window);
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_HIDDEN.getName(), Arrays.asList(window));
            if (WindowManager.this.app.getPhase() == ApplicationPhase.SHUTDOWN) {
                return;
            }
            int visibleWindows = 0;
            for (Window w : WindowManager.this.windows.values()) {
                ++visibleWindows;
            }
            if (visibleWindows > 1) {
                WindowManager.this.hide(window);
            }
            Boolean autoShutdown = (Boolean)WindowManager.this.app.getConfig().flatten().get("application.autoShutdown");
            if (visibleWindows <= 1 && autoShutdown != null && autoShutdown.booleanValue()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attempting to shutdown application");
                }
                if (!WindowManager.this.app.shutdown()) {
                    WindowManager.this.show(window);
                }
            }
        }

        public void onWindowShown(Window window) {
            super.onWindowShown(window);
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_SHOWN.getName(), Arrays.asList(window));
        }
    }
}

